/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.events;

import com.KGitextpdf.text.Document;
import com.KGitextpdf.text.Paragraph;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfPageEvent;
import com.KGitextpdf.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfPageEventForwarder
implements PdfPageEvent {
    protected ArrayList<PdfPageEvent> events = new ArrayList();

    public void addPageEvent(PdfPageEvent event) {
        this.events.add(event);
    }

    @Override
    public void onOpenDocument(PdfWriter writer, Document document) {
        for (PdfPageEvent event : this.events) {
            event.onOpenDocument(writer, document);
        }
    }

    @Override
    public void onStartPage(PdfWriter writer, Document document) {
        for (PdfPageEvent event : this.events) {
            event.onStartPage(writer, document);
        }
    }

    @Override
    public void onEndPage(PdfWriter writer, Document document) {
        for (PdfPageEvent event : this.events) {
            event.onEndPage(writer, document);
        }
    }

    @Override
    public void onCloseDocument(PdfWriter writer, Document document) {
        for (PdfPageEvent event : this.events) {
            event.onCloseDocument(writer, document);
        }
    }

    @Override
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {
        for (PdfPageEvent event : this.events) {
            event.onParagraph(writer, document, paragraphPosition);
        }
    }

    @Override
    public void onParagraphEnd(PdfWriter writer, Document document, float paragraphPosition) {
        for (PdfPageEvent event : this.events) {
            event.onParagraphEnd(writer, document, paragraphPosition);
        }
    }

    @Override
    public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
        for (PdfPageEvent event : this.events) {
            event.onChapter(writer, document, paragraphPosition, title);
        }
    }

    @Override
    public void onChapterEnd(PdfWriter writer, Document document, float position) {
        for (PdfPageEvent event : this.events) {
            event.onChapterEnd(writer, document, position);
        }
    }

    @Override
    public void onSection(PdfWriter writer, Document document, float paragraphPosition, int depth, Paragraph title) {
        for (PdfPageEvent event : this.events) {
            event.onSection(writer, document, paragraphPosition, depth, title);
        }
    }

    @Override
    public void onSectionEnd(PdfWriter writer, Document document, float position) {
        for (PdfPageEvent event : this.events) {
            event.onSectionEnd(writer, document, position);
        }
    }

    @Override
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
        Iterator<PdfPageEvent> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent element;
            PdfPageEvent event = element = iterator.next();
            event.onGenericTag(writer, document, rect, text);
        }
    }
}

