/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfLayer;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;

public class PdfVisibilityExpression
extends PdfArray {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int NOT = -1;

    public PdfVisibilityExpression(int type) {
        switch (type) {
            case 0: {
                super.add(PdfName.OR);
                break;
            }
            case 1: {
                super.add(PdfName.AND);
                break;
            }
            case -1: {
                super.add(PdfName.NOT);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.ve.value", new Object[0]));
            }
        }
    }

    @Override
    public void add(int index, PdfObject element) {
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.ve.value", new Object[0]));
    }

    @Override
    public boolean add(PdfObject object) {
        if (object instanceof PdfLayer) {
            return super.add(((PdfLayer)object).getRef());
        }
        if (object instanceof PdfVisibilityExpression) {
            return super.add(object);
        }
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.ve.value", new Object[0]));
    }

    @Override
    public void addFirst(PdfObject object) {
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.ve.value", new Object[0]));
    }

    @Override
    public boolean add(float[] values) {
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.ve.value", new Object[0]));
    }

    @Override
    public boolean add(int[] values) {
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.ve.value", new Object[0]));
    }
}

