/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.Document;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.exceptions.BadPasswordException;
import com.KGitextpdf.text.log.Counter;
import com.KGitextpdf.text.log.CounterFactory;
import com.KGitextpdf.text.pdf.AcroFields;
import com.KGitextpdf.text.pdf.BadPdfFormatException;
import com.KGitextpdf.text.pdf.ByteBuffer;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PageResources;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfContentByte;
import com.KGitextpdf.text.pdf.PdfContents;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfDocument;
import com.KGitextpdf.text.pdf.PdfException;
import com.KGitextpdf.text.pdf.PdfFormField;
import com.KGitextpdf.text.pdf.PdfImportedPage;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfLiteral;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNull;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfOutline;
import com.KGitextpdf.text.pdf.PdfPage;
import com.KGitextpdf.text.pdf.PdfPageEvent;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfReaderInstance;
import com.KGitextpdf.text.pdf.PdfRectangle;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfStructTreeController;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.KGitextpdf.text.pdf.RefKey;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;

public class PdfCopy
extends PdfWriter {
    protected static Counter COUNTER = CounterFactory.getCounter(PdfCopy.class);
    protected HashMap<RefKey, IndirectReferences> indirects;
    protected HashMap<PdfReader, HashMap<RefKey, IndirectReferences>> indirectMap;
    protected HashMap<PdfObject, PdfObject> parentObjects;
    protected HashSet<PdfObject> disableIndirects;
    protected PdfReader reader;
    protected int[] namePtr = new int[1];
    private boolean rotateContents = true;
    protected PdfArray fieldArray;
    protected HashSet<PdfTemplate> fieldTemplates;
    private PdfStructTreeController structTreeController = null;
    private int currentStructArrayNumber = 0;
    protected PRIndirectReference structTreeRootReference;
    protected HashMap<RefKey, PdfIndirectObject> indirectObjects;
    protected ArrayList<PdfIndirectObject> savedObjects;
    protected ArrayList<ImportedPage> importedPages;
    protected boolean updateRootKids = false;
    private static PdfName annotId = new PdfName("iTextAnnotId");
    private static int annotIdCnt = 0;
    protected boolean mergeFields = false;
    private boolean hasSignature;
    private PdfIndirectReference acroForm;
    private HashMap<PdfArray, ArrayList<Integer>> tabOrder;
    private ArrayList<Object> calculationOrderRefs;
    private PdfDictionary resources;
    protected ArrayList<AcroFields> fields;
    private ArrayList<String> calculationOrder;
    private HashMap<String, Object> fieldTree;
    private HashMap<Integer, PdfIndirectObject> unmergedMap;
    private HashSet<PdfIndirectObject> unmergedSet;
    private HashMap<Integer, PdfIndirectObject> mergedMap;
    private HashSet<PdfIndirectObject> mergedSet;
    private boolean mergeFieldsInternalCall = false;
    private static final PdfName iTextTag = new PdfName("_iTextTag_");
    private static final Integer zero = 0;
    protected static final HashSet<PdfName> widgetKeys = new HashSet();
    protected static final HashSet<PdfName> fieldKeys = new HashSet();

    static {
        widgetKeys.add(PdfName.SUBTYPE);
        widgetKeys.add(PdfName.CONTENTS);
        widgetKeys.add(PdfName.RECT);
        widgetKeys.add(PdfName.NM);
        widgetKeys.add(PdfName.M);
        widgetKeys.add(PdfName.F);
        widgetKeys.add(PdfName.BS);
        widgetKeys.add(PdfName.BORDER);
        widgetKeys.add(PdfName.AP);
        widgetKeys.add(PdfName.AS);
        widgetKeys.add(PdfName.C);
        widgetKeys.add(PdfName.A);
        widgetKeys.add(PdfName.STRUCTPARENT);
        widgetKeys.add(PdfName.OC);
        widgetKeys.add(PdfName.H);
        widgetKeys.add(PdfName.MK);
        widgetKeys.add(PdfName.DA);
        widgetKeys.add(PdfName.Q);
        widgetKeys.add(PdfName.P);
        widgetKeys.add(PdfName.TYPE);
        widgetKeys.add(annotId);
        fieldKeys.add(PdfName.AA);
        fieldKeys.add(PdfName.FT);
        fieldKeys.add(PdfName.TU);
        fieldKeys.add(PdfName.TM);
        fieldKeys.add(PdfName.FF);
        fieldKeys.add(PdfName.V);
        fieldKeys.add(PdfName.DV);
        fieldKeys.add(PdfName.DS);
        fieldKeys.add(PdfName.RV);
        fieldKeys.add(PdfName.OPT);
        fieldKeys.add(PdfName.MAXLEN);
        fieldKeys.add(PdfName.TI);
        fieldKeys.add(PdfName.I);
        fieldKeys.add(PdfName.LOCK);
        fieldKeys.add(PdfName.SV);
    }

    @Override
    protected Counter getCounter() {
        return COUNTER;
    }

    public PdfCopy(Document document, OutputStream os) throws DocumentException {
        super(new PdfDocument(), os);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
        this.parentObjects = new HashMap();
        this.disableIndirects = new HashSet();
        this.indirectObjects = new HashMap();
        this.savedObjects = new ArrayList();
        this.importedPages = new ArrayList();
    }

    @Override
    public void setPageEvent(PdfPageEvent event) {
        throw new UnsupportedOperationException();
    }

    public boolean isRotateContents() {
        return this.rotateContents;
    }

    public void setRotateContents(boolean rotateContents) {
        this.rotateContents = rotateContents;
    }

    public void setMergeFields() {
        this.mergeFields = true;
        this.resources = new PdfDictionary();
        this.fields = new ArrayList();
        this.calculationOrder = new ArrayList();
        this.fieldTree = new HashMap();
        this.unmergedMap = new HashMap();
        this.unmergedSet = new HashSet();
        this.mergedMap = new HashMap();
        this.mergedSet = new HashSet();
    }

    @Override
    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        if (this.mergeFields && !this.mergeFieldsInternalCall) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.method.cannot.be.used.in.mergeFields.mode.please.use.addDocument", "getImportedPage"));
        }
        if (this.mergeFields) {
            ImportedPage newPage = new ImportedPage(reader, pageNumber, this.mergeFields);
            this.importedPages.add(newPage);
        }
        if (this.structTreeController != null) {
            this.structTreeController.reader = null;
        }
        this.disableIndirects.clear();
        this.parentObjects.clear();
        return this.getImportedPageImpl(reader, pageNumber);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber, boolean keepTaggedPdfStructure) throws BadPdfFormatException {
        if (this.mergeFields && !this.mergeFieldsInternalCall) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.method.cannot.be.used.in.mergeFields.mode.please.use.addDocument", "getImportedPage"));
        }
        this.updateRootKids = false;
        if (!keepTaggedPdfStructure) {
            if (this.mergeFields) {
                ImportedPage newPage = new ImportedPage(reader, pageNumber, this.mergeFields);
                this.importedPages.add(newPage);
            }
            return this.getImportedPageImpl(reader, pageNumber);
        }
        if (this.structTreeController != null) {
            if (reader != this.structTreeController.reader) {
                this.structTreeController.setReader(reader);
            }
        } else {
            this.structTreeController = new PdfStructTreeController(reader, this);
        }
        ImportedPage newPage = new ImportedPage(reader, pageNumber, this.mergeFields);
        switch (this.checkStructureTreeRootKids(newPage)) {
            case -1: {
                this.clearIndirects(reader);
                this.updateRootKids = true;
                break;
            }
            case 0: {
                this.updateRootKids = false;
                break;
            }
            case 1: {
                this.updateRootKids = true;
            }
        }
        this.importedPages.add(newPage);
        this.disableIndirects.clear();
        this.parentObjects.clear();
        return this.getImportedPageImpl(reader, pageNumber);
    }

    private void clearIndirects(PdfReader reader) {
        HashMap<RefKey, IndirectReferences> currIndirects = this.indirectMap.get(reader);
        ArrayList<RefKey> forDelete = new ArrayList<RefKey>();
        for (Map.Entry<RefKey, IndirectReferences> entry : currIndirects.entrySet()) {
            PdfIndirectReference iRef = entry.getValue().theRef;
            RefKey key = new RefKey(iRef);
            PdfIndirectObject iobj = this.indirectObjects.get(key);
            if (iobj == null) {
                forDelete.add(entry.getKey());
                continue;
            }
            if (!iobj.object.isArray() && !iobj.object.isDictionary() && !iobj.object.isStream()) continue;
            forDelete.add(entry.getKey());
        }
        for (RefKey key : forDelete) {
            currIndirects.remove(key);
        }
    }

    private int checkStructureTreeRootKids(ImportedPage newPage) {
        if (this.importedPages.size() == 0) {
            return 1;
        }
        boolean readerExist = false;
        for (ImportedPage page : this.importedPages) {
            if (!page.reader.equals(newPage.reader)) continue;
            readerExist = true;
            break;
        }
        if (!readerExist) {
            return 1;
        }
        ImportedPage lastPage = this.importedPages.get(this.importedPages.size() - 1);
        boolean equalReader = lastPage.reader.equals(newPage.reader);
        if (equalReader && newPage.pageNumber > lastPage.pageNumber) {
            return 0;
        }
        return -1;
    }

    protected void fixStructureTreeRoot(HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        HashMap<PdfName, PdfObject> newClassMap = new HashMap<PdfName, PdfObject>(activeClassMaps.size());
        for (PdfName key : activeClassMaps) {
            PdfObject cm = this.structureTreeRoot.classes.get(key);
            if (cm == null) continue;
            newClassMap.put(key, cm);
        }
        this.structureTreeRoot.classes = newClassMap;
        PdfArray kids = this.structureTreeRoot.getAsArray(PdfName.K);
        if (kids != null) {
            int i = 0;
            while (i < kids.size()) {
                PdfIndirectReference iref = (PdfIndirectReference)kids.getPdfObject(i);
                RefKey key = new RefKey(iref);
                if (!activeKeys.contains(key)) {
                    kids.remove(i--);
                }
                ++i;
            }
        }
    }

    protected PdfImportedPage getImportedPageImpl(PdfReader reader, int pageNumber) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != reader) {
                this.currentPdfReaderInstance = super.getPdfReaderInstance(reader);
            }
        } else {
            this.currentPdfReaderInstance = super.getPdfReaderInstance(reader);
        }
        return this.currentPdfReaderInstance.getImportedPage(pageNumber);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in, boolean keepStructure, boolean directRootKids) throws IOException, BadPdfFormatException {
        PdfObject type;
        PdfIndirectReference theRef;
        PdfDictionary dict;
        RefKey key = new RefKey(in);
        IndirectReferences iRef = this.indirects.get(key);
        PdfObject obj = PdfReader.getPdfObjectRelease(in);
        if (keepStructure && directRootKids && obj instanceof PdfDictionary && (dict = (PdfDictionary)obj).contains(PdfName.PG)) {
            return null;
        }
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        if (obj != null && obj.isDictionary() && (type = PdfReader.getPdfObjectRelease(((PdfDictionary)obj).get(PdfName.TYPE))) != null && PdfName.PAGE.equals(type)) {
            return theRef;
        }
        iRef.setCopied();
        if (obj != null) {
            this.parentObjects.put(obj, in);
        }
        PdfObject res = this.copyObject(obj, keepStructure, directRootKids);
        if (this.disableIndirects.contains(obj)) {
            iRef.setNotCopied();
        }
        if (res != null) {
            this.addToBody(res, theRef);
            return theRef;
        }
        this.indirects.remove(key);
        return null;
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        return this.copyIndirect(in, false, false);
    }

    protected PdfDictionary copyDictionary(PdfDictionary in, boolean keepStruct, boolean directRootKids) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary();
        PdfObject type = PdfReader.getPdfObjectRelease(in.get(PdfName.TYPE));
        if (keepStruct) {
            if (directRootKids && in.contains(PdfName.PG)) {
                PdfObject curr = in;
                this.disableIndirects.add(curr);
                while (this.parentObjects.containsKey(curr) && !this.disableIndirects.contains(curr)) {
                    curr = this.parentObjects.get(curr);
                    this.disableIndirects.add(curr);
                }
                return null;
            }
            PdfName structType = in.getAsName(PdfName.S);
            this.structTreeController.addRole(structType);
            this.structTreeController.addClass(in);
        }
        if (this.structTreeController != null && this.structTreeController.reader != null && (in.contains(PdfName.STRUCTPARENTS) || in.contains(PdfName.STRUCTPARENT))) {
            PdfName key = PdfName.STRUCTPARENT;
            if (in.contains(PdfName.STRUCTPARENTS)) {
                key = PdfName.STRUCTPARENTS;
            }
            PdfObject value = in.get(key);
            out.put(key, new PdfNumber(this.currentStructArrayNumber));
            this.structTreeController.copyStructTreeForPage((PdfNumber)value, this.currentStructArrayNumber++);
        }
        Iterator<PdfName> iterator = in.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfObject res;
            PdfName element;
            PdfName key = element = iterator.next();
            PdfObject value = in.get(key);
            if (this.structTreeController != null && this.structTreeController.reader != null && (key.equals(PdfName.STRUCTPARENTS) || key.equals(PdfName.STRUCTPARENT))) continue;
            if (PdfName.PAGE.equals(type)) {
                if (key.equals(PdfName.B) || key.equals(PdfName.PARENT)) continue;
                this.parentObjects.put(value, in);
                res = this.copyObject(value, keepStruct, directRootKids);
                if (res == null) continue;
                out.put(key, res);
                continue;
            }
            res = this.tagged && value.isIndirect() && this.isStructTreeRootReference((PRIndirectReference)value) ? this.structureTreeRoot.getReference() : this.copyObject(value, keepStruct, directRootKids);
            if (res == null) continue;
            out.put(key, res);
        }
        return out;
    }

    protected PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        return this.copyDictionary(in, false, false);
    }

    protected PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        Iterator<PdfName> iterator = in.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName element;
            PdfName key = element = iterator.next();
            PdfObject value = in.get(key);
            this.parentObjects.put(value, in);
            PdfObject res = this.copyObject(value);
            if (res == null) continue;
            out.put(key, res);
        }
        return out;
    }

    protected PdfArray copyArray(PdfArray in, boolean keepStruct, boolean directRootKids) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        ListIterator<PdfObject> i = in.listIterator();
        while (i.hasNext()) {
            PdfObject value = (PdfObject)i.next();
            this.parentObjects.put(value, in);
            PdfObject res = this.copyObject(value, keepStruct, directRootKids);
            if (res == null) continue;
            out.add(res);
        }
        return out;
    }

    protected PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        return this.copyArray(in, false, false);
    }

    protected PdfObject copyObject(PdfObject in, boolean keepStruct, boolean directRootKids) throws IOException, BadPdfFormatException {
        if (in == null) {
            return PdfNull.PDFNULL;
        }
        switch (in.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in, keepStruct, directRootKids);
            }
            case 10: {
                if (!keepStruct && !directRootKids) {
                    return this.copyIndirect((PRIndirectReference)in);
                }
                return this.copyIndirect((PRIndirectReference)in, keepStruct, directRootKids);
            }
            case 5: {
                return this.copyArray((PdfArray)in, keepStruct, directRootKids);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.out.println("CANNOT COPY type " + in.type);
        return null;
    }

    protected PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        return this.copyObject(in, false, false);
    }

    protected int setFromIPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance inst = this.currentPdfReaderInstance = iPage.getPdfReaderInstance();
        this.reader = inst.getReader();
        this.setFromReader(this.reader);
        return pageNum;
    }

    protected void setFromReader(PdfReader reader) {
        this.reader = reader;
        this.indirects = this.indirectMap.get(reader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(reader, this.indirects);
        }
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        if (this.mergeFields && !this.mergeFieldsInternalCall) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.method.cannot.be.used.in.mergeFields.mode.please.use.addDocument", "addPage"));
        }
        int pageNum = this.setFromIPage(iPage);
        PdfDictionary thePage = this.reader.getPageN(pageNum);
        PRIndirectReference origRef = this.reader.getPageOrigRef(pageNum);
        this.reader.releasePage(pageNum);
        RefKey key = new RefKey(origRef);
        IndirectReferences iRef = this.indirects.get(key);
        if (iRef != null && !iRef.getCopied()) {
            this.pageReferences.add(iRef.getRef());
            iRef.setCopied();
        }
        PdfIndirectReference pageRef = this.getCurrentPage();
        if (iRef == null) {
            iRef = new IndirectReferences(pageRef);
            this.indirects.put(key, iRef);
        }
        iRef.setCopied();
        if (this.tagged) {
            this.structTreeRootReference = (PRIndirectReference)this.reader.getCatalog().get(PdfName.STRUCTTREEROOT);
        }
        PdfDictionary newPage = this.copyDictionary(thePage);
        this.root.addPage(newPage);
        iPage.setCopied();
        ++this.currentPageNumber;
        this.structTreeRootReference = null;
    }

    public void addPage(Rectangle rect, int rotation) throws DocumentException {
        if (this.mergeFields && !this.mergeFieldsInternalCall) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.method.cannot.be.used.in.mergeFields.mode.please.use.addDocument", "addPage"));
        }
        PdfRectangle mediabox = new PdfRectangle(rect, rotation);
        PageResources resources = new PageResources();
        PdfPage page = new PdfPage(mediabox, new HashMap<String, PdfRectangle>(), resources.getResources(), 0);
        page.put(PdfName.TABS, this.getTabs());
        this.root.addPage(page);
        ++this.currentPageNumber;
    }

    public void addDocument(PdfReader reader, List<Integer> pagesToKeep) throws DocumentException, IOException {
        if (this.indirectMap.containsKey(reader)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("document.1.has.already.been.added", reader.toString()));
        }
        reader.selectPages(pagesToKeep, false);
        this.addDocument(reader);
    }

    public void addDocument(PdfReader reader) throws DocumentException, IOException {
        if (this.indirectMap.containsKey(reader)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("document.1.has.already.been.added", reader.toString()));
        }
        if (!reader.isOpenedWithFullPermissions()) {
            throw new BadPasswordException(MessageLocalization.getComposedMessage("pdfreader.not.opened.with.owner.password", new Object[0]));
        }
        if (this.mergeFields) {
            reader.consolidateNamedDestinations();
            reader.shuffleSubsetNames();
            int i = 1;
            while (i <= reader.getNumberOfPages()) {
                PdfArray annots;
                PdfDictionary page = reader.getPageNRelease(i);
                if (page != null && page.contains(PdfName.ANNOTS) && (annots = page.getAsArray(PdfName.ANNOTS)) != null) {
                    int j = 0;
                    while (j < annots.size()) {
                        PdfDictionary annot = annots.getAsDict(j);
                        if (annot != null) {
                            annot.put(annotId, new PdfNumber(++annotIdCnt));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.fields.add(reader.getAcroFields());
            this.updateCalculationOrder(reader);
        }
        boolean tagged = this.tagged && PdfStructTreeController.checkTagged(reader);
        this.mergeFieldsInternalCall = true;
        int i = 1;
        while (i <= reader.getNumberOfPages()) {
            this.addPage(this.getImportedPage(reader, i, tagged));
            ++i;
        }
        this.mergeFieldsInternalCall = false;
    }

    @Override
    public PdfIndirectObject addToBody(PdfObject object, PdfIndirectReference ref) throws IOException {
        return this.addToBody(object, ref, false);
    }

    @Override
    public PdfIndirectObject addToBody(PdfObject object, PdfIndirectReference ref, boolean formBranching) throws IOException {
        PdfNumber annotId;
        PdfIndirectObject iobj;
        if (formBranching) {
            this.updateReferences(object);
        }
        if ((this.tagged || this.mergeFields) && this.indirectObjects != null && (object.isArray() || object.isDictionary() || object.isStream() || object.isNull())) {
            RefKey key = new RefKey(ref);
            PdfIndirectObject obj = this.indirectObjects.get(key);
            if (obj == null) {
                obj = new PdfIndirectObject(ref, object, (PdfWriter)this);
                this.indirectObjects.put(key, obj);
            }
            iobj = obj;
        } else {
            iobj = super.addToBody(object, ref);
        }
        if (this.mergeFields && object.isDictionary() && (annotId = ((PdfDictionary)object).getAsNumber(PdfCopy.annotId)) != null) {
            if (formBranching) {
                this.mergedMap.put(annotId.intValue(), iobj);
                this.mergedSet.add(iobj);
            } else {
                this.unmergedMap.put(annotId.intValue(), iobj);
                this.unmergedSet.add(iobj);
            }
        }
        return iobj;
    }

    @Override
    public PdfIndirectObject addToBody(PdfObject object) throws IOException {
        PdfIndirectObject iobj = super.addToBody(object);
        if ((this.tagged || this.mergeFields) && this.indirectObjects != null) {
            this.savedObjects.add(iobj);
            RefKey key = new RefKey(iobj.number, iobj.generation);
            if (!this.indirectObjects.containsKey(key)) {
                this.indirectObjects.put(key, iobj);
            }
        }
        return iobj;
    }

    @Override
    protected void flushTaggedObjects() throws IOException {
        try {
            try {
                this.fixTaggedStructure();
            }
            catch (ClassCastException classCastException) {
                this.flushIndirectObjects();
            }
        }
        finally {
            this.flushIndirectObjects();
        }
    }

    @Override
    protected void flushAcroFields() throws IOException, BadPdfFormatException {
        if (this.mergeFields) {
            try {
                try {
                    for (PdfReader reader : this.indirectMap.keySet()) {
                        reader.removeFields();
                    }
                    this.mergeFields();
                    this.createAcroForms();
                }
                catch (ClassCastException classCastException) {
                    if (!this.tagged) {
                        this.flushIndirectObjects();
                    }
                }
            }
            finally {
                if (!this.tagged) {
                    this.flushIndirectObjects();
                }
            }
        }
    }

    protected void fixTaggedStructure() throws IOException {
        HashMap<Integer, PdfIndirectReference> numTree = this.structureTreeRoot.getNumTree();
        HashSet<RefKey> activeKeys = new HashSet<RefKey>();
        ArrayList<PdfIndirectReference> actives = new ArrayList<PdfIndirectReference>();
        int pageRefIndex = 0;
        if (this.mergeFields && this.acroForm != null) {
            actives.add(this.acroForm);
            activeKeys.add(new RefKey(this.acroForm));
        }
        for (PdfIndirectReference page : this.pageReferences) {
            actives.add(page);
            activeKeys.add(new RefKey(page));
        }
        int i = numTree.size() - 1;
        while (i >= 0) {
            PdfIndirectReference currNum = numTree.get(i);
            RefKey numKey = new RefKey(currNum);
            PdfObject obj = this.indirectObjects.get((Object)numKey).object;
            if (obj.isDictionary()) {
                boolean addActiveKeys = false;
                if (this.pageReferences.contains(((PdfDictionary)obj).get(PdfName.PG))) {
                    addActiveKeys = true;
                } else {
                    PdfDictionary k = PdfStructTreeController.getKDict((PdfDictionary)obj);
                    if (k != null && this.pageReferences.contains(k.get(PdfName.PG))) {
                        addActiveKeys = true;
                    }
                }
                if (addActiveKeys) {
                    activeKeys.add(numKey);
                    actives.add(currNum);
                } else {
                    numTree.remove(i);
                }
            } else if (obj.isArray()) {
                activeKeys.add(numKey);
                actives.add(currNum);
                PdfArray currNums = (PdfArray)obj;
                PdfIndirectReference currPage = (PdfIndirectReference)this.pageReferences.get(pageRefIndex++);
                actives.add(currPage);
                activeKeys.add(new RefKey(currPage));
                PdfIndirectReference prevKid = null;
                int j = 0;
                while (j < currNums.size()) {
                    PdfIndirectReference currKid = (PdfIndirectReference)currNums.getDirectObject(j);
                    if (!currKid.equals(prevKid)) {
                        PdfDictionary dict;
                        PdfIndirectReference pg;
                        RefKey kidKey = new RefKey(currKid);
                        activeKeys.add(kidKey);
                        actives.add(currKid);
                        PdfIndirectObject iobj = this.indirectObjects.get(kidKey);
                        if (iobj.object.isDictionary() && !this.pageReferences.contains(pg = (PdfIndirectReference)(dict = (PdfDictionary)iobj.object).get(PdfName.PG)) && !pg.equals(currPage)) {
                            PdfObject firstKid;
                            dict.put(PdfName.PG, currPage);
                            PdfArray kids = dict.getAsArray(PdfName.K);
                            if (kids != null && (firstKid = kids.getDirectObject(0)).isNumber()) {
                                kids.remove(0);
                            }
                        }
                        prevKid = currKid;
                    }
                    ++j;
                }
            }
            --i;
        }
        HashSet<PdfName> activeClassMaps = new HashSet<PdfName>();
        this.findActives(actives, activeKeys, activeClassMaps);
        ArrayList<PdfIndirectReference> newRefs = this.findActiveParents(activeKeys);
        this.fixPgKey(newRefs, activeKeys);
        this.fixStructureTreeRoot(activeKeys, activeClassMaps);
        for (Map.Entry<RefKey, PdfIndirectObject> entry : this.indirectObjects.entrySet()) {
            PdfObject kids;
            if (!activeKeys.contains(entry.getKey())) {
                entry.setValue(null);
                continue;
            }
            if (entry.getValue().object.isArray()) {
                this.removeInactiveReferences((PdfArray)entry.getValue().object, activeKeys);
                continue;
            }
            if (!entry.getValue().object.isDictionary() || (kids = ((PdfDictionary)entry.getValue().object).get(PdfName.K)) == null || !kids.isArray()) continue;
            this.removeInactiveReferences((PdfArray)kids, activeKeys);
        }
    }

    private void removeInactiveReferences(PdfArray array, HashSet<RefKey> activeKeys) {
        int i = 0;
        while (i < array.size()) {
            PdfObject obj = array.getPdfObject(i);
            if (obj.type() == 0 && !activeKeys.contains(new RefKey((PdfIndirectReference)obj)) || obj.isDictionary() && this.containsInactivePg((PdfDictionary)obj, activeKeys)) {
                array.remove(i--);
            }
            ++i;
        }
    }

    private boolean containsInactivePg(PdfDictionary dict, HashSet<RefKey> activeKeys) {
        PdfObject pg = dict.get(PdfName.PG);
        return pg != null && !activeKeys.contains(new RefKey((PdfIndirectReference)pg));
    }

    private ArrayList<PdfIndirectReference> findActiveParents(HashSet<RefKey> activeKeys) {
        ArrayList<PdfIndirectReference> newRefs = new ArrayList<PdfIndirectReference>();
        ArrayList<RefKey> tmpActiveKeys = new ArrayList<RefKey>(activeKeys);
        int i = 0;
        while (i < tmpActiveKeys.size()) {
            RefKey key;
            PdfObject parent;
            PdfIndirectObject iobj = this.indirectObjects.get(tmpActiveKeys.get(i));
            if (iobj != null && iobj.object.isDictionary() && (parent = ((PdfDictionary)iobj.object).get(PdfName.P)) != null && parent.type() == 0 && !activeKeys.contains(key = new RefKey((PdfIndirectReference)parent))) {
                activeKeys.add(key);
                tmpActiveKeys.add(key);
                newRefs.add((PdfIndirectReference)parent);
            }
            ++i;
        }
        return newRefs;
    }

    private void fixPgKey(ArrayList<PdfIndirectReference> newRefs, HashSet<RefKey> activeKeys) {
        block0: for (PdfIndirectReference iref : newRefs) {
            PdfArray kids;
            PdfDictionary dict;
            PdfObject pg;
            PdfIndirectObject iobj = this.indirectObjects.get(new RefKey(iref));
            if (iobj == null || !iobj.object.isDictionary() || (pg = (dict = (PdfDictionary)iobj.object).get(PdfName.PG)) == null || activeKeys.contains(new RefKey((PdfIndirectReference)pg)) || (kids = dict.getAsArray(PdfName.K)) == null) continue;
            int i = 0;
            while (i < kids.size()) {
                PdfObject obj = kids.getPdfObject(i);
                if (obj.type() != 0) {
                    kids.remove(i--);
                } else {
                    PdfObject kidPg;
                    PdfIndirectObject kid = this.indirectObjects.get(new RefKey((PdfIndirectReference)obj));
                    if (kid != null && kid.object.isDictionary() && (kidPg = ((PdfDictionary)kid.object).get(PdfName.PG)) != null && activeKeys.contains(new RefKey((PdfIndirectReference)kidPg))) {
                        dict.put(PdfName.PG, kidPg);
                        continue block0;
                    }
                }
                ++i;
            }
        }
    }

    private void findActives(ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        int i = 0;
        while (i < actives.size()) {
            RefKey key = new RefKey(actives.get(i));
            PdfIndirectObject iobj = this.indirectObjects.get(key);
            if (iobj != null && iobj.object != null) {
                switch (iobj.object.type()) {
                    case 0: {
                        this.findActivesFromReference((PdfIndirectReference)iobj.object, actives, activeKeys);
                        break;
                    }
                    case 5: {
                        this.findActivesFromArray((PdfArray)iobj.object, actives, activeKeys, activeClassMaps);
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.findActivesFromDict((PdfDictionary)iobj.object, actives, activeKeys, activeClassMaps);
                    }
                }
            }
            ++i;
        }
    }

    private void findActivesFromReference(PdfIndirectReference iref, ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys) {
        RefKey key = new RefKey(iref);
        PdfIndirectObject iobj = this.indirectObjects.get(key);
        if (iobj != null && iobj.object.isDictionary() && this.containsInactivePg((PdfDictionary)iobj.object, activeKeys)) {
            return;
        }
        if (!activeKeys.contains(key)) {
            activeKeys.add(key);
            actives.add(iref);
        }
    }

    private void findActivesFromArray(PdfArray array, ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        for (PdfObject obj : array) {
            switch (obj.type()) {
                case 0: {
                    this.findActivesFromReference((PdfIndirectReference)obj, actives, activeKeys);
                    break;
                }
                case 5: {
                    this.findActivesFromArray((PdfArray)obj, actives, activeKeys, activeClassMaps);
                    break;
                }
                case 6: 
                case 7: {
                    this.findActivesFromDict((PdfDictionary)obj, actives, activeKeys, activeClassMaps);
                }
            }
        }
    }

    private void findActivesFromDict(PdfDictionary dict, ArrayList<PdfIndirectReference> actives, HashSet<RefKey> activeKeys, HashSet<PdfName> activeClassMaps) {
        if (this.containsInactivePg(dict, activeKeys)) {
            return;
        }
        for (PdfName key : dict.getKeys()) {
            PdfObject obj = dict.get(key);
            if (key.equals(PdfName.P)) continue;
            if (key.equals(PdfName.C)) {
                if (obj.isArray()) {
                    for (PdfObject cm : (PdfArray)obj) {
                        if (!cm.isName()) continue;
                        activeClassMaps.add((PdfName)cm);
                    }
                    continue;
                }
                if (!obj.isName()) continue;
                activeClassMaps.add((PdfName)obj);
                continue;
            }
            switch (obj.type()) {
                case 0: {
                    this.findActivesFromReference((PdfIndirectReference)obj, actives, activeKeys);
                    break;
                }
                case 5: {
                    this.findActivesFromArray((PdfArray)obj, actives, activeKeys, activeClassMaps);
                    break;
                }
                case 6: 
                case 7: {
                    this.findActivesFromDict((PdfDictionary)obj, actives, activeKeys, activeClassMaps);
                }
            }
        }
    }

    protected void flushIndirectObjects() throws IOException {
        for (PdfIndirectObject iobj : this.savedObjects) {
            this.indirectObjects.remove(new RefKey(iobj.number, iobj.generation));
        }
        HashSet<RefKey> inactives = new HashSet<RefKey>();
        for (Map.Entry<RefKey, PdfIndirectObject> entry : this.indirectObjects.entrySet()) {
            if (entry.getValue() != null) {
                this.writeObjectToBody(entry.getValue());
                continue;
            }
            inactives.add(entry.getKey());
        }
        ArrayList<PdfWriter.PdfBody.PdfCrossReference> pdfCrossReferences = new ArrayList<PdfWriter.PdfBody.PdfCrossReference>(this.body.xrefs);
        for (PdfWriter.PdfBody.PdfCrossReference cr : pdfCrossReferences) {
            RefKey key = new RefKey(cr.getRefnum(), 0);
            if (!inactives.contains(key)) continue;
            this.body.xrefs.remove(cr);
        }
        this.indirectObjects = null;
    }

    private void writeObjectToBody(PdfIndirectObject object) throws IOException {
        PdfNumber annotId;
        PdfDictionary dictionary;
        boolean skipWriting = false;
        if (this.mergeFields) {
            this.updateAnnotationReferences(object.object);
            if (object.object.isDictionary() || object.object.isStream()) {
                PdfNumber structParent;
                PdfIndirectObject unmerged;
                dictionary = (PdfDictionary)object.object;
                if (this.unmergedSet.contains(object) && (annotId = dictionary.getAsNumber(PdfCopy.annotId)) != null && this.mergedMap.containsKey(annotId.intValue())) {
                    skipWriting = true;
                }
                if (this.mergedSet.contains(object) && (annotId = dictionary.getAsNumber(PdfCopy.annotId)) != null && (unmerged = this.unmergedMap.get(annotId.intValue())) != null && unmerged.object.isDictionary() && (structParent = ((PdfDictionary)unmerged.object).getAsNumber(PdfName.STRUCTPARENT)) != null) {
                    dictionary.put(PdfName.STRUCTPARENT, structParent);
                }
            }
        }
        if (!skipWriting) {
            dictionary = null;
            annotId = null;
            if (this.mergeFields && object.object.isDictionary() && (annotId = (dictionary = (PdfDictionary)object.object).getAsNumber(PdfCopy.annotId)) != null) {
                dictionary.remove(PdfCopy.annotId);
            }
            this.body.write(object, object.number, object.generation);
            if (annotId != null) {
                dictionary.put(PdfCopy.annotId, annotId);
            }
        }
    }

    private void updateAnnotationReferences(PdfObject obj) {
        block8: {
            block7: {
                if (!obj.isArray()) break block7;
                PdfArray array = (PdfArray)obj;
                int i = 0;
                while (i < array.size()) {
                    PdfObject o = array.getPdfObject(i);
                    if (o instanceof PdfIndirectReference) {
                        for (PdfIndirectObject entry : this.unmergedSet) {
                            PdfIndirectObject merged;
                            PdfNumber annotId;
                            if (!entry.getIndirectReference().toString().equals(o.toString()) || !entry.object.isDictionary() || (annotId = ((PdfDictionary)entry.object).getAsNumber(PdfCopy.annotId)) == null || (merged = this.mergedMap.get(annotId.intValue())) == null) continue;
                            array.set(i, merged.getIndirectReference());
                        }
                    } else {
                        this.updateAnnotationReferences(o);
                    }
                    ++i;
                }
                break block8;
            }
            if (!obj.isDictionary() && !obj.isStream()) break block8;
            PdfDictionary dictionary = (PdfDictionary)obj;
            for (PdfName key : dictionary.getKeys()) {
                PdfObject o = dictionary.get(key);
                if (o instanceof PdfIndirectReference) {
                    for (PdfIndirectObject entry : this.unmergedSet) {
                        PdfIndirectObject merged;
                        PdfNumber annotId;
                        if (!entry.getIndirectReference().toString().equals(o.toString()) || !entry.object.isDictionary() || (annotId = ((PdfDictionary)entry.object).getAsNumber(PdfCopy.annotId)) == null || (merged = this.mergedMap.get(annotId.intValue())) == null) continue;
                        dictionary.put(key, merged.getIndirectReference());
                    }
                    continue;
                }
                this.updateAnnotationReferences(o);
            }
        }
    }

    private void updateCalculationOrder(PdfReader reader) {
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary acro = catalog.getAsDict(PdfName.ACROFORM);
        if (acro == null) {
            return;
        }
        PdfArray co = acro.getAsArray(PdfName.CO);
        if (co == null || co.size() == 0) {
            return;
        }
        AcroFields af = reader.getAcroFields();
        int k = 0;
        while (k < co.size()) {
            String name;
            PdfObject obj = co.getPdfObject(k);
            if (obj != null && obj.isIndirect() && af.getFieldItem(name = PdfCopy.getCOName(reader, (PRIndirectReference)obj)) != null && !this.calculationOrder.contains(name = "." + name)) {
                this.calculationOrder.add(name);
            }
            ++k;
        }
    }

    private static String getCOName(PdfReader reader, PRIndirectReference ref) {
        String name = "";
        while (ref != null) {
            PdfObject obj = PdfReader.getPdfObject(ref);
            if (obj == null || obj.type() != 6) break;
            PdfDictionary dic = (PdfDictionary)obj;
            PdfString t = dic.getAsString(PdfName.T);
            if (t != null) {
                name = String.valueOf(t.toUnicodeString()) + "." + name;
            }
            ref = (PRIndirectReference)dic.get(PdfName.PARENT);
        }
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    private void mergeFields() {
        int pageOffset = 0;
        int k = 0;
        while (k < this.fields.size()) {
            AcroFields af = this.fields.get(k);
            Map<String, AcroFields.Item> fd = af.getFields();
            this.addPageOffsetToField(fd, pageOffset);
            this.mergeWithMaster(fd);
            pageOffset += af.reader.getNumberOfPages();
            ++k;
        }
    }

    private void addPageOffsetToField(Map<String, AcroFields.Item> fd, int pageOffset) {
        if (pageOffset == 0) {
            return;
        }
        for (AcroFields.Item item : fd.values()) {
            int k = 0;
            while (k < item.size()) {
                int p = item.getPage(k);
                item.forcePage(k, p + pageOffset);
                ++k;
            }
        }
    }

    private void mergeWithMaster(Map<String, AcroFields.Item> fd) {
        for (Map.Entry<String, AcroFields.Item> entry : fd.entrySet()) {
            String name = entry.getKey();
            this.mergeField(name, entry.getValue());
        }
    }

    private void mergeField(String name, AcroFields.Item item) {
        Object obj;
        String s;
        HashMap map;
        block16: {
            map = this.fieldTree;
            StringTokenizer tk = new StringTokenizer(name, ".");
            if (!tk.hasMoreTokens()) {
                return;
            }
            while (true) {
                s = tk.nextToken();
                obj = map.get(s);
                if (!tk.hasMoreTokens()) break block16;
                if (obj == null) {
                    map.put((String)s, (Object)obj);
                    map = (HashMap)obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return;
        }
        if (obj instanceof HashMap) {
            return;
        }
        PdfDictionary merged = item.getMerged(0);
        if (obj == null) {
            PdfDictionary field = new PdfDictionary();
            if (PdfName.SIG.equals(merged.get(PdfName.FT))) {
                this.hasSignature = true;
            }
            for (PdfName element : merged.getKeys()) {
                PdfName key = element;
                if (!fieldKeys.contains(key)) continue;
                field.put(key, merged.get(key));
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(field);
            this.createWidgets(list, item);
            map.put(s, list);
        } else {
            ArrayList list = (ArrayList)obj;
            PdfDictionary field = (PdfDictionary)list.get(0);
            PdfName type1 = (PdfName)field.get(PdfName.FT);
            PdfName type2 = (PdfName)merged.get(PdfName.FT);
            if (type1 == null || !type1.equals(type2)) {
                return;
            }
            int flag1 = 0;
            PdfObject f1 = field.get(PdfName.FF);
            if (f1 != null && f1.isNumber()) {
                flag1 = ((PdfNumber)f1).intValue();
            }
            int flag2 = 0;
            PdfObject f2 = merged.get(PdfName.FF);
            if (f2 != null && f2.isNumber()) {
                flag2 = ((PdfNumber)f2).intValue();
            }
            if (type1.equals(PdfName.BTN)) {
                if (((flag1 ^ flag2) & 0x10000) != 0) {
                    return;
                }
                if ((flag1 & 0x10000) == 0 && ((flag1 ^ flag2) & 0x8000) != 0) {
                    return;
                }
            } else if (type1.equals(PdfName.CH) && ((flag1 ^ flag2) & 0x20000) != 0) {
                return;
            }
            this.createWidgets(list, item);
        }
    }

    private void createWidgets(ArrayList<Object> list, AcroFields.Item item) {
        int k = 0;
        while (k < item.size()) {
            list.add(item.getPage(k));
            PdfDictionary merged = item.getMerged(k);
            PdfObject dr = merged.get(PdfName.DR);
            if (dr != null) {
                PdfFormField.mergeResources(this.resources, (PdfDictionary)PdfReader.getPdfObject(dr));
            }
            PdfDictionary widget = new PdfDictionary();
            for (PdfName element : merged.getKeys()) {
                PdfName key = element;
                if (!widgetKeys.contains(key)) continue;
                widget.put(key, merged.get(key));
            }
            widget.put(iTextTag, new PdfNumber(item.getTabOrder(k) + 1));
            list.add(widget);
            ++k;
        }
    }

    private PdfObject propagate(PdfObject obj) throws IOException {
        if (obj == null) {
            return new PdfNull();
        }
        if (obj.isArray()) {
            PdfArray a = (PdfArray)obj;
            int i = 0;
            while (i < a.size()) {
                a.set(i, this.propagate(a.getPdfObject(i)));
                ++i;
            }
            return a;
        }
        if (obj.isDictionary() || obj.isStream()) {
            PdfDictionary d = (PdfDictionary)obj;
            for (PdfName key : d.getKeys()) {
                d.put(key, this.propagate(d.get(key)));
            }
            return d;
        }
        if (obj.isIndirect()) {
            obj = PdfReader.getPdfObject(obj);
            return this.addToBody(this.propagate(obj)).getIndirectReference();
        }
        return obj;
    }

    private void createAcroForms() throws IOException, BadPdfFormatException {
        if (this.fieldTree.isEmpty()) {
            return;
        }
        PdfDictionary form = new PdfDictionary();
        form.put(PdfName.DR, this.propagate(this.resources));
        form.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        this.tabOrder = new HashMap();
        this.calculationOrderRefs = new ArrayList<String>(this.calculationOrder);
        form.put(PdfName.FIELDS, this.branchForm(this.fieldTree, null, ""));
        if (this.hasSignature) {
            form.put(PdfName.SIGFLAGS, new PdfNumber(3));
        }
        PdfArray co = new PdfArray();
        int k = 0;
        while (k < this.calculationOrderRefs.size()) {
            Object obj = this.calculationOrderRefs.get(k);
            if (obj instanceof PdfIndirectReference) {
                co.add((PdfIndirectReference)obj);
            }
            ++k;
        }
        if (co.size() > 0) {
            form.put(PdfName.CO, co);
        }
        this.acroForm = this.addToBody(form).getIndirectReference();
    }

    private void updateReferences(PdfObject obj) {
        block7: {
            block6: {
                if (!obj.isDictionary() && !obj.isStream()) break block6;
                PdfDictionary dictionary = (PdfDictionary)obj;
                for (PdfName key : dictionary.getKeys()) {
                    PdfObject o = dictionary.get(key);
                    if (o.isIndirect()) {
                        PdfReader reader = ((PRIndirectReference)o).getReader();
                        HashMap<RefKey, IndirectReferences> indirects = this.indirectMap.get(reader);
                        IndirectReferences indRef = indirects.get(new RefKey((PRIndirectReference)o));
                        if (indRef == null) continue;
                        dictionary.put(key, indRef.getRef());
                        continue;
                    }
                    this.updateReferences(o);
                }
                break block7;
            }
            if (!obj.isArray()) break block7;
            PdfArray array = (PdfArray)obj;
            int i = 0;
            while (i < array.size()) {
                PdfObject o = array.getPdfObject(i);
                if (o.isIndirect()) {
                    PdfReader reader = ((PRIndirectReference)o).getReader();
                    HashMap<RefKey, IndirectReferences> indirects = this.indirectMap.get(reader);
                    IndirectReferences indRef = indirects.get(new RefKey((PRIndirectReference)o));
                    if (indRef != null) {
                        array.set(i, indRef.getRef());
                    }
                } else {
                    this.updateReferences(o);
                }
                ++i;
            }
        }
    }

    private PdfArray branchForm(HashMap<String, Object> level, PdfIndirectReference parent, String fname) throws IOException {
        PdfArray arr = new PdfArray();
        for (Map.Entry<String, Object> entry : level.entrySet()) {
            String name = entry.getKey();
            Object obj = entry.getValue();
            PdfIndirectReference ind = this.getPdfIndirectReference();
            PdfDictionary dic = new PdfDictionary();
            if (parent != null) {
                dic.put(PdfName.PARENT, parent);
            }
            dic.put(PdfName.T, new PdfString(name, "UnicodeBig"));
            String fname2 = String.valueOf(fname) + "." + name;
            int coidx = this.calculationOrder.indexOf(fname2);
            if (coidx >= 0) {
                this.calculationOrderRefs.set(coidx, ind);
            }
            if (obj instanceof HashMap) {
                dic.put(PdfName.KIDS, this.branchForm((HashMap)obj, ind, fname2));
                arr.add(ind);
                this.addToBody((PdfObject)dic, ind, true);
                continue;
            }
            ArrayList list = (ArrayList)obj;
            dic.mergeDifferent((PdfDictionary)list.get(0));
            if (list.size() == 3) {
                dic.mergeDifferent((PdfDictionary)list.get(2));
                int page = (Integer)list.get(1);
                PdfArray annots = this.importedPages.get((int)(page - 1)).mergedFields;
                PdfNumber nn = (PdfNumber)dic.get(iTextTag);
                dic.remove(iTextTag);
                dic.put(PdfName.TYPE, PdfName.ANNOT);
                this.adjustTabOrder(annots, ind, nn);
            } else {
                PdfArray kids = new PdfArray();
                int k = 1;
                while (k < list.size()) {
                    int page = (Integer)list.get(k);
                    PdfArray annots = this.importedPages.get((int)(page - 1)).mergedFields;
                    PdfDictionary widget = new PdfDictionary();
                    widget.merge((PdfDictionary)list.get(k + 1));
                    widget.put(PdfName.PARENT, ind);
                    PdfNumber nn = (PdfNumber)widget.get(iTextTag);
                    widget.remove(iTextTag);
                    widget.put(PdfName.TYPE, PdfName.ANNOT);
                    PdfIndirectReference wref = this.addToBody((PdfObject)widget, this.getPdfIndirectReference(), true).getIndirectReference();
                    this.adjustTabOrder(annots, wref, nn);
                    kids.add(wref);
                    k += 2;
                }
                dic.put(PdfName.KIDS, kids);
            }
            arr.add(ind);
            this.addToBody((PdfObject)dic, ind, true);
        }
        return arr;
    }

    private void adjustTabOrder(PdfArray annots, PdfIndirectReference ind, PdfNumber nn) {
        int v = nn.intValue();
        ArrayList<Integer> t = this.tabOrder.get(annots);
        if (t == null) {
            t = new ArrayList();
            int size = annots.size() - 1;
            int k = 0;
            while (k < size) {
                t.add(zero);
                ++k;
            }
            t.add(v);
            this.tabOrder.put(annots, t);
            annots.add(ind);
        } else {
            int size;
            int k = size = t.size() - 1;
            while (k >= 0) {
                if (t.get(k) <= v) {
                    t.add(k + 1, v);
                    annots.add(k + 1, ind);
                    size = -2;
                    break;
                }
                --k;
            }
            if (size != -2) {
                t.add(0, v);
                annots.add(0, ind);
            }
        }
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        try {
            PdfDocument.PdfCatalog theCat = this.pdf.getCatalog(rootObj);
            this.buildStructTreeRootForTagged(theCat);
            if (this.fieldArray != null) {
                this.addFieldResources(theCat);
            } else if (this.mergeFields && this.acroForm != null) {
                theCat.put(PdfName.ACROFORM, this.acroForm);
            }
            return theCat;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    protected boolean isStructTreeRootReference(PdfIndirectReference prRef) {
        if (prRef == null || this.structTreeRootReference == null) {
            return false;
        }
        return prRef.number == this.structTreeRootReference.number && prRef.generation == this.structTreeRootReference.generation;
    }

    private void addFieldResources(PdfDictionary catalog) throws IOException {
        PdfDictionary dic;
        if (this.fieldArray == null) {
            return;
        }
        PdfDictionary acroForm = new PdfDictionary();
        catalog.put(PdfName.ACROFORM, acroForm);
        acroForm.put(PdfName.FIELDS, this.fieldArray);
        acroForm.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        if (this.fieldTemplates.isEmpty()) {
            return;
        }
        PdfDictionary dr = new PdfDictionary();
        acroForm.put(PdfName.DR, dr);
        for (PdfTemplate template : this.fieldTemplates) {
            PdfFormField.mergeResources(dr, (PdfDictionary)template.getResources());
        }
        PdfDictionary fonts = dr.getAsDict(PdfName.FONT);
        if (fonts == null) {
            fonts = new PdfDictionary();
            dr.put(PdfName.FONT, fonts);
        }
        if (!fonts.contains(PdfName.HELV)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.HELVETICA);
            dic.put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
            dic.put(PdfName.NAME, PdfName.HELV);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.HELV, this.addToBody(dic).getIndirectReference());
        }
        if (!fonts.contains(PdfName.ZADB)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
            dic.put(PdfName.NAME, PdfName.ZADB);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.ZADB, this.addToBody(dic).getIndirectReference());
        }
    }

    @Override
    public void close() {
        if (this.open) {
            this.pdf.close();
            super.close();
        }
    }

    public PdfIndirectReference add(PdfOutline outline) {
        return null;
    }

    @Override
    public void addAnnotation(PdfAnnotation annot) {
    }

    @Override
    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        return null;
    }

    @Override
    public void freeReader(PdfReader reader) throws IOException {
        PdfArray array = reader.trailer.getAsArray(PdfName.ID);
        if (array != null) {
            this.originalFileID = array.getAsString(0).getBytes();
        }
        this.indirectMap.remove(reader);
        this.currentPdfReaderInstance = null;
        super.freeReader(reader);
    }

    public PageStamp createPageStamp(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReader reader = iPage.getPdfReaderInstance().getReader();
        PdfDictionary pageN = reader.getPageN(pageNum);
        return new PageStamp(reader, pageN, this);
    }

    protected static class ImportedPage {
        int pageNumber;
        PdfReader reader;
        PdfArray mergedFields;

        ImportedPage(PdfReader reader, int pageNumber, boolean keepFields) {
            this.pageNumber = pageNumber;
            this.reader = reader;
            if (keepFields) {
                this.mergedFields = new PdfArray();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImportedPage)) {
                return false;
            }
            ImportedPage other = (ImportedPage)o;
            return this.pageNumber == other.pageNumber && this.reader.equals(other.reader);
        }

        public String toString() {
            return Integer.toString(this.pageNumber);
        }
    }

    static class IndirectReferences {
        PdfIndirectReference theRef;
        boolean hasCopied;

        IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        void setCopied() {
            this.hasCopied = true;
        }

        void setNotCopied() {
            this.hasCopied = false;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }

        public String toString() {
            String ext = "";
            if (this.hasCopied) {
                ext = String.valueOf(ext) + " Copied";
            }
            return this.getRef() + ext;
        }
    }

    public static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;
        PdfReader reader;
        PdfCopy cstp;

        PageStamp(PdfReader reader, PdfDictionary pageN, PdfCopy cstp) {
            this.pageN = pageN;
            this.reader = reader;
            this.cstp = cstp;
        }

        public PdfContentByte getUnderContent() {
            if (this.under == null) {
                if (this.pageResources == null) {
                    this.pageResources = new PageResources();
                    PdfDictionary resources = this.pageN.getAsDict(PdfName.RESOURCES);
                    this.pageResources.setOriginalResources(resources, this.cstp.namePtr);
                }
                this.under = new StampContent(this.cstp, this.pageResources);
            }
            return this.under;
        }

        public PdfContentByte getOverContent() {
            if (this.over == null) {
                if (this.pageResources == null) {
                    this.pageResources = new PageResources();
                    PdfDictionary resources = this.pageN.getAsDict(PdfName.RESOURCES);
                    this.pageResources.setOriginalResources(resources, this.cstp.namePtr);
                }
                this.over = new StampContent(this.cstp, this.pageResources);
            }
            return this.over;
        }

        public void alterContents() throws IOException {
            if (this.over == null && this.under == null) {
                return;
            }
            PdfArray ar = null;
            PdfObject content = PdfReader.getPdfObject(this.pageN.get(PdfName.CONTENTS), this.pageN);
            if (content == null) {
                ar = new PdfArray();
                this.pageN.put(PdfName.CONTENTS, ar);
            } else if (content.isArray()) {
                ar = (PdfArray)content;
            } else if (content.isStream()) {
                ar = new PdfArray();
                ar.add(this.pageN.get(PdfName.CONTENTS));
                this.pageN.put(PdfName.CONTENTS, ar);
            } else {
                ar = new PdfArray();
                this.pageN.put(PdfName.CONTENTS, ar);
            }
            ByteBuffer out = new ByteBuffer();
            if (this.under != null) {
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(this.pageN, out);
                out.append(this.under.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
            }
            if (this.over != null) {
                out.append(PdfContents.SAVESTATE);
            }
            PdfStream stream = new PdfStream(out.toByteArray());
            stream.flateCompress(this.cstp.getCompressionLevel());
            PdfIndirectReference ref1 = this.cstp.addToBody(stream).getIndirectReference();
            ar.addFirst(ref1);
            out.reset();
            if (this.over != null) {
                out.append(' ');
                out.append(PdfContents.RESTORESTATE);
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(this.pageN, out);
                out.append(this.over.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
                stream = new PdfStream(out.toByteArray());
                stream.flateCompress(this.cstp.getCompressionLevel());
                ar.add(this.cstp.addToBody(stream).getIndirectReference());
            }
            this.pageN.put(PdfName.RESOURCES, this.pageResources.getResources());
        }

        void applyRotation(PdfDictionary pageN, ByteBuffer out) {
            if (!this.cstp.rotateContents) {
                return;
            }
            Rectangle page = this.reader.getPageSizeWithRotation(pageN);
            int rotation = page.getRotation();
            switch (rotation) {
                case 90: {
                    out.append(PdfContents.ROTATE90);
                    out.append(page.getTop());
                    out.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                    break;
                }
                case 180: {
                    out.append(PdfContents.ROTATE180);
                    out.append(page.getRight());
                    out.append(' ');
                    out.append(page.getTop());
                    out.append(PdfContents.ROTATEFINAL);
                    break;
                }
                case 270: {
                    out.append(PdfContents.ROTATE270);
                    out.append('0').append(' ');
                    out.append(page.getRight());
                    out.append(PdfContents.ROTATEFINAL);
                }
            }
        }

        private void addDocumentField(PdfIndirectReference ref) {
            if (this.cstp.fieldArray == null) {
                this.cstp.fieldArray = new PdfArray();
            }
            this.cstp.fieldArray.add(ref);
        }

        private void expandFields(PdfFormField field, ArrayList<PdfAnnotation> allAnnots) {
            allAnnots.add(field);
            ArrayList<PdfFormField> kids = field.getKids();
            if (kids != null) {
                for (PdfFormField f : kids) {
                    this.expandFields(f, allAnnots);
                }
            }
        }

        public void addAnnotation(PdfAnnotation annot) {
            try {
                ArrayList<PdfAnnotation> allAnnots = new ArrayList<PdfAnnotation>();
                if (annot.isForm()) {
                    PdfFormField field = (PdfFormField)annot;
                    if (field.getParent() != null) {
                        return;
                    }
                    this.expandFields(field, allAnnots);
                    if (this.cstp.fieldTemplates == null) {
                        this.cstp.fieldTemplates = new HashSet();
                    }
                } else {
                    allAnnots.add(annot);
                }
                int k = 0;
                while (k < allAnnots.size()) {
                    annot = allAnnots.get(k);
                    if (annot.isForm()) {
                        PdfFormField field;
                        HashSet<PdfTemplate> templates;
                        if (!annot.isUsed() && (templates = annot.getTemplates()) != null) {
                            this.cstp.fieldTemplates.addAll(templates);
                        }
                        if ((field = (PdfFormField)annot).getParent() == null) {
                            this.addDocumentField(field.getIndirectReference());
                        }
                    }
                    if (annot.isAnnotation()) {
                        PdfRectangle rect;
                        PdfObject pdfobj = PdfReader.getPdfObject(this.pageN.get(PdfName.ANNOTS), this.pageN);
                        PdfArray annots = null;
                        if (pdfobj == null || !pdfobj.isArray()) {
                            annots = new PdfArray();
                            this.pageN.put(PdfName.ANNOTS, annots);
                        } else {
                            annots = (PdfArray)pdfobj;
                        }
                        annots.add(annot.getIndirectReference());
                        if (!(annot.isUsed() || (rect = (PdfRectangle)annot.get(PdfName.RECT)) == null || rect.left() == 0.0f && rect.right() == 0.0f && rect.top() == 0.0f && rect.bottom() == 0.0f)) {
                            int rotation = this.reader.getPageRotation(this.pageN);
                            Rectangle pageSize = this.reader.getPageSizeWithRotation(this.pageN);
                            switch (rotation) {
                                case 90: {
                                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.getTop() - rect.bottom(), rect.left(), pageSize.getTop() - rect.top(), rect.right()));
                                    break;
                                }
                                case 180: {
                                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.getRight() - rect.left(), pageSize.getTop() - rect.bottom(), pageSize.getRight() - rect.right(), pageSize.getTop() - rect.top()));
                                    break;
                                }
                                case 270: {
                                    annot.put(PdfName.RECT, new PdfRectangle(rect.bottom(), pageSize.getRight() - rect.left(), rect.top(), pageSize.getRight() - rect.right()));
                                }
                            }
                        }
                    }
                    if (!annot.isUsed()) {
                        annot.setUsed();
                        this.cstp.addToBody((PdfObject)annot, annot.getIndirectReference());
                    }
                    ++k;
                }
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    public static class StampContent
    extends PdfContentByte {
        PageResources pageResources;

        StampContent(PdfWriter writer, PageResources pageResources) {
            super(writer);
            this.pageResources = pageResources;
        }

        @Override
        public PdfContentByte getDuplicate() {
            return new StampContent(this.writer, this.pageResources);
        }

        @Override
        PageResources getPageResources() {
            return this.pageResources;
        }
    }
}

