/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfContentByte;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.xmp.XMPException;
import com.KGitextpdf.xmp.XMPMeta;
import com.KGitextpdf.xmp.XMPMetaFactory;
import com.KGitextpdf.xmp.XMPUtils;
import com.KGitextpdf.xmp.options.SerializeOptions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CompareTool {
    private String gsExec;
    private String compareExec;
    private String gsParams = " -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 -sOutputFile=<outputfile> <inputfile>";
    private String compareParams = " <image1> <image2> <difference>";
    private static String cannotOpenTargetDirectory = "Cannot open target directory for <filename>.";
    private static String gsFailed = "GhostScript failed for <filename>.";
    private static String unexpectedNumberOfPages = "Unexpected number of pages for <filename>.";
    private static String differentPages = "File <filename> differs on page <pagenumber>.";
    private static String undefinedGsPath = "Path to GhostScript is not specified. Please use -DgsExec=<path_to_ghostscript> (e.g. -DgsExec=\"C:/Program Files/gs/gs8.64/bin/gswin32c.exe\")";
    private static String ignoredAreasPrefix = "ignored_areas_";
    private String cmpPdf;
    private String cmpPdfName;
    private String cmpImage;
    private String outPdf;
    private String outPdfName;
    private String outImage;

    public CompareTool(String outPdf, String cmpPdf) {
        this.init(outPdf, cmpPdf);
        this.gsExec = System.getProperty("gsExec");
        this.compareExec = System.getProperty("compareExec");
    }

    public String compare(String outPath, String differenceImagePrefix) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPath, differenceImagePrefix, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String compare(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        int cnt;
        String line;
        File[] cmpImageFiles;
        File[] imageFiles;
        if (this.gsExec == null || !new File(this.gsExec).exists()) {
            return undefinedGsPath;
        }
        File targetDir = new File(outPath);
        if (!targetDir.exists()) {
            targetDir.mkdir();
        } else {
            File file;
            File[] fileArray = imageFiles = targetDir.listFiles(new PngFileFilter());
            int n = imageFiles.length;
            int n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                file.delete();
                ++n2;
            }
            fileArray = cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter());
            n = cmpImageFiles.length;
            n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
        File diffFile = new File(String.valueOf(outPath) + differenceImagePrefix);
        if (diffFile.exists()) {
            diffFile.delete();
        }
        if (ignoredAreas != null && !ignoredAreas.isEmpty()) {
            PdfReader cmpReader = new PdfReader(this.cmpPdf);
            PdfReader outReader = new PdfReader(this.outPdf);
            PdfStamper outStamper = new PdfStamper(outReader, new FileOutputStream(String.valueOf(outPath) + ignoredAreasPrefix + this.outPdfName));
            PdfStamper cmpStamper = new PdfStamper(cmpReader, new FileOutputStream(String.valueOf(outPath) + ignoredAreasPrefix + this.cmpPdfName));
            for (Map.Entry<Integer, List<Rectangle>> entry : ignoredAreas.entrySet()) {
                int pageNumber = entry.getKey();
                List<Rectangle> rectangles = entry.getValue();
                if (rectangles == null || rectangles.isEmpty()) continue;
                PdfContentByte outCB = outStamper.getOverContent(pageNumber);
                PdfContentByte cmpCB = cmpStamper.getOverContent(pageNumber);
                for (Rectangle rect : rectangles) {
                    rect.setBackgroundColor(BaseColor.BLACK);
                    outCB.rectangle(rect);
                    cmpCB.rectangle(rect);
                }
            }
            outStamper.close();
            cmpStamper.close();
            outReader.close();
            cmpReader.close();
            this.init(String.valueOf(outPath) + ignoredAreasPrefix + this.outPdfName, String.valueOf(outPath) + ignoredAreasPrefix + this.cmpPdfName);
        }
        if (!targetDir.exists()) return cannotOpenTargetDirectory.replace("<filename>", this.outPdf);
        String gsParams = this.gsParams.replace("<outputfile>", String.valueOf(outPath) + this.cmpImage).replace("<inputfile>", this.cmpPdf);
        Process p = Runtime.getRuntime().exec(String.valueOf(this.gsExec) + gsParams);
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        if (p.waitFor() != 0) return gsFailed.replace("<filename>", this.cmpPdf);
        gsParams = this.gsParams.replace("<outputfile>", String.valueOf(outPath) + this.outImage).replace("<inputfile>", this.outPdf);
        p = Runtime.getRuntime().exec(String.valueOf(this.gsExec) + gsParams);
        bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        int exitValue = p.waitFor();
        if (exitValue != 0) return gsFailed.replace("<filename>", this.outPdf);
        imageFiles = targetDir.listFiles(new PngFileFilter());
        cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter());
        boolean bUnexpectedNumberOfPages = false;
        if (imageFiles.length != cmpImageFiles.length) {
            bUnexpectedNumberOfPages = true;
        }
        if ((cnt = Math.min(imageFiles.length, cmpImageFiles.length)) < 1) {
            return "No files for comparing!!!\nThe result or sample pdf file is not processed by GhostScript.";
        }
        Arrays.sort(imageFiles, new ImageNameComparator());
        Arrays.sort(cmpImageFiles, new ImageNameComparator());
        String differentPagesFail = null;
        int i = 0;
        while (i < cnt) {
            System.out.print("Comparing page " + Integer.toString(i + 1) + " (" + imageFiles[i].getAbsolutePath() + ")...");
            FileInputStream is1 = new FileInputStream(imageFiles[i]);
            FileInputStream is2 = new FileInputStream(cmpImageFiles[i]);
            boolean cmpResult = this.compareStreams(is1, is2);
            is1.close();
            is2.close();
            if (!cmpResult) {
                if (new File(this.compareExec).exists()) {
                    String compareParams = this.compareParams.replace("<image1>", imageFiles[i].getAbsolutePath()).replace("<image2>", cmpImageFiles[i].getAbsolutePath()).replace("<difference>", String.valueOf(outPath) + differenceImagePrefix + Integer.toString(i + 1) + ".png");
                    p = Runtime.getRuntime().exec(String.valueOf(this.compareExec) + compareParams);
                    bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = bre.readLine()) != null) {
                        System.out.println(line);
                    }
                    bre.close();
                    int cmpExitValue = p.waitFor();
                    if (cmpExitValue == 0) {
                        if (differentPagesFail == null) {
                            differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                            differentPagesFail = String.valueOf(differentPagesFail) + "\nPlease, examine " + outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png for more details.";
                        } else {
                            differentPagesFail = "File " + this.outPdf + " differs.\nPlease, examine difference images for more details.";
                        }
                    } else {
                        differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    }
                } else {
                    differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    differentPagesFail = String.valueOf(differentPagesFail) + "\nYou can optionally specify path to ImageMagick compare tool (e.g. -DcompareExec=\"C:/Program Files/ImageMagick-6.5.4-2/compare.exe\") to visualize differences.";
                    break;
                }
                System.out.println(differentPagesFail);
            } else {
                System.out.println("done.");
            }
            ++i;
        }
        if (differentPagesFail != null) {
            return differentPagesFail;
        }
        if (!bUnexpectedNumberOfPages) return null;
        return String.valueOf(unexpectedNumberOfPages.replace("<filename>", this.outPdf)) + "\n" + differentPagesFail;
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        this.init(outPdf, cmpPdf);
        return this.compare(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    public String compareXmp() {
        return this.compareXmp(false);
    }

    public String compareXmp(boolean ignoreDateAndProducerProperties) {
        PdfReader cmpReader = null;
        PdfReader outReader = null;
        try {
            cmpReader = new PdfReader(this.cmpPdf);
            outReader = new PdfReader(this.outPdf);
            byte[] cmpBytes = cmpReader.getMetadata();
            byte[] outBytes = outReader.getMetadata();
            if (ignoreDateAndProducerProperties) {
                XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(cmpBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                cmpBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
                xmpMeta = XMPMetaFactory.parseFromBuffer(outBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                outBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
            }
            if (!this.compareXmls(cmpBytes, outBytes)) {
                return "The XMP packages different!!!";
            }
        }
        catch (XMPException xmpExc) {
            return "XMP parsing failure!!!";
        }
        catch (IOException ioExc) {
            return "XMP parsing failure!!!";
        }
        catch (ParserConfigurationException parseExc) {
            return "XMP parsing failure!!!";
        }
        catch (SAXException parseExc) {
            return "XMP parsing failure!!!";
        }
        finally {
            if (cmpReader != null) {
                cmpReader.close();
            }
            if (outReader != null) {
                outReader.close();
            }
        }
        return null;
    }

    public boolean compareXmls(byte[] xml1, byte[] xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new ByteArrayInputStream(xml1));
        doc1.normalizeDocument();
        Document doc2 = db.parse(new ByteArrayInputStream(xml2));
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    private void init(String outPdf, String cmpPdf) {
        this.outPdf = outPdf;
        this.cmpPdf = cmpPdf;
        this.outPdfName = new File(outPdf).getName();
        this.cmpPdfName = new File(cmpPdf).getName();
        this.outImage = String.valueOf(this.outPdfName) + "-%03d.png";
        this.cmpImage = "cmp_" + this.cmpPdfName + "-%03d.png";
    }

    private boolean compareStreams(InputStream is1, InputStream is2) throws IOException {
        byte[] buffer1 = new byte[65536];
        byte[] buffer2 = new byte[65536];
        int len1 = 0;
        int len2 = 0;
        do {
            if ((len1 = is1.read(buffer1)) != (len2 = is2.read(buffer2))) {
                return false;
            }
            if (Arrays.equals(buffer1, buffer2)) continue;
            return false;
        } while (len1 != -1 && len2 != -1);
        return true;
    }

    class CmpPngFileFilter
    implements FileFilter {
        CmpPngFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && b2 && ap.contains(CompareTool.this.cmpPdfName);
        }
    }

    class ImageNameComparator
    implements Comparator<File> {
        ImageNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String f1Name = f1.getAbsolutePath();
            String f2Name = f2.getAbsolutePath();
            return f1Name.compareTo(f2Name);
        }
    }

    class PngFileFilter
    implements FileFilter {
        PngFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && !b2 && ap.contains(CompareTool.this.outPdfName);
        }
    }
}

