/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.io;

import com.KGitextpdf.text.io.RandomAccessSource;
import java.io.IOException;

class ArrayRandomAccessSource
implements RandomAccessSource {
    private byte[] array;

    public ArrayRandomAccessSource(byte[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        this.array = array;
    }

    @Override
    public int get(long offset) {
        if (offset >= (long)this.array.length) {
            return -1;
        }
        return 0xFF & this.array[(int)offset];
    }

    @Override
    public int get(long offset, byte[] bytes, int off, int len) {
        if (this.array == null) {
            throw new IllegalStateException("Already closed");
        }
        if (offset >= (long)this.array.length) {
            return -1;
        }
        if (offset + (long)len > (long)this.array.length) {
            len = (int)((long)this.array.length - offset);
        }
        System.arraycopy(this.array, (int)offset, bytes, off, len);
        return len;
    }

    @Override
    public long length() {
        return this.array.length;
    }

    @Override
    public void close() throws IOException {
        this.array = null;
    }
}

