/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.Font;
import com.KGitextpdf.text.FontProvider;
import com.KGitextpdf.text.log.Level;
import com.KGitextpdf.text.log.Logger;
import com.KGitextpdf.text.log.LoggerFactory;
import com.KGitextpdf.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public class FontFactoryImp
implements FontProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontFactoryImp.class);
    private final Hashtable<String, String> trueTypeFonts = new Hashtable();
    private static String[] TTFamilyOrder = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private final Hashtable<String, ArrayList<String>> fontFamilies = new Hashtable();
    public String defaultEncoding = "Cp1252";
    public boolean defaultEmbedding = false;

    public FontFactoryImp() {
        this.trueTypeFonts.put("Courier".toLowerCase(), "Courier");
        this.trueTypeFonts.put("Courier-Bold".toLowerCase(), "Courier-Bold");
        this.trueTypeFonts.put("Courier-Oblique".toLowerCase(), "Courier-Oblique");
        this.trueTypeFonts.put("Courier-BoldOblique".toLowerCase(), "Courier-BoldOblique");
        this.trueTypeFonts.put("Helvetica".toLowerCase(), "Helvetica");
        this.trueTypeFonts.put("Helvetica-Bold".toLowerCase(), "Helvetica-Bold");
        this.trueTypeFonts.put("Helvetica-Oblique".toLowerCase(), "Helvetica-Oblique");
        this.trueTypeFonts.put("Helvetica-BoldOblique".toLowerCase(), "Helvetica-BoldOblique");
        this.trueTypeFonts.put("Symbol".toLowerCase(), "Symbol");
        this.trueTypeFonts.put("Times-Roman".toLowerCase(), "Times-Roman");
        this.trueTypeFonts.put("Times-Bold".toLowerCase(), "Times-Bold");
        this.trueTypeFonts.put("Times-Italic".toLowerCase(), "Times-Italic");
        this.trueTypeFonts.put("Times-BoldItalic".toLowerCase(), "Times-BoldItalic");
        this.trueTypeFonts.put("ZapfDingbats".toLowerCase(), "ZapfDingbats");
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("Courier");
        tmp.add("Courier-Bold");
        tmp.add("Courier-Oblique");
        tmp.add("Courier-BoldOblique");
        this.fontFamilies.put("Courier".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Helvetica");
        tmp.add("Helvetica-Bold");
        tmp.add("Helvetica-Oblique");
        tmp.add("Helvetica-BoldOblique");
        this.fontFamilies.put("Helvetica".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Symbol");
        this.fontFamilies.put("Symbol".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Times-Roman");
        tmp.add("Times-Bold");
        tmp.add("Times-Italic");
        tmp.add("Times-BoldItalic");
        this.fontFamilies.put("Times".toLowerCase(), tmp);
        this.fontFamilies.put("Times-Roman".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("ZapfDingbats");
        this.fontFamilies.put("ZapfDingbats".toLowerCase(), tmp);
    }

    @Override
    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color) {
        return this.getFont(fontname, encoding, embedded, size, style, color, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color, boolean cached) {
        if (fontname == null) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        String lowercasefontname = fontname.toLowerCase();
        ArrayList<String> tmp = this.fontFamilies.get(lowercasefontname);
        if (tmp != null) {
            ArrayList<String> arrayList = tmp;
            synchronized (arrayList) {
                int s = style == -1 ? 0 : style;
                int fs = 0;
                boolean found = false;
                for (String f : tmp) {
                    String lcf = f.toLowerCase();
                    fs = 0;
                    if (lcf.indexOf("bold") != -1) {
                        fs |= 1;
                    }
                    if (lcf.indexOf("italic") != -1 || lcf.indexOf("oblique") != -1) {
                        fs |= 2;
                    }
                    if ((s & 3) != fs) continue;
                    fontname = f;
                    found = true;
                    break;
                }
                if (style != -1 && found) {
                    style &= ~fs;
                }
            }
        }
        BaseFont basefont = null;
        try {
            try {
                basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null, true);
            }
            catch (DocumentException s) {
                // empty catch block
            }
            if (basefont == null) {
                if ((fontname = this.trueTypeFonts.get(fontname.toLowerCase())) == null) {
                    return new Font(Font.FontFamily.UNDEFINED, size, style, color);
                }
                basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        catch (NullPointerException npe) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        return new Font(basefont, size, style, color);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style) {
        return this.getFont(fontname, encoding, embedded, size, style, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size) {
        return this.getFont(fontname, encoding, embedded, size, -1, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded) {
        return this.getFont(fontname, encoding, embedded, -1.0f, -1, null);
    }

    public Font getFont(String fontname, String encoding, float size, int style, BaseColor color) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, String encoding, float size, int style) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, String encoding, float size) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname, float size, BaseColor color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, color);
    }

    public Font getFont(String fontname, String encoding) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public Font getFont(String fontname, float size, int style, BaseColor color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, float size, int style) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, float size) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFamily(String familyName, String fullName, String path) {
        ArrayList<String> tmp;
        if (path != null) {
            this.trueTypeFonts.put(fullName, path);
        }
        Cloneable cloneable = this.fontFamilies;
        synchronized (cloneable) {
            tmp = this.fontFamilies.get(familyName);
            if (tmp == null) {
                tmp = new ArrayList();
                this.fontFamilies.put(familyName, tmp);
            }
        }
        cloneable = tmp;
        synchronized (cloneable) {
            if (!tmp.contains(fullName)) {
                int fullNameLength = fullName.length();
                boolean inserted = false;
                int j = 0;
                while (j < tmp.size()) {
                    if (tmp.get(j).length() >= fullNameLength) {
                        tmp.add(j, fullName);
                        inserted = true;
                        break;
                    }
                    ++j;
                }
                if (!inserted) {
                    tmp.add(fullName);
                }
            }
        }
    }

    public void register(String path) {
        this.register(path, null);
    }

    public void register(String path, String alias) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                String[] name;
                int n;
                int n2;
                String[][] stringArray;
                String[][] names;
                Object[] allNames = BaseFont.getAllFontNames(path, "Cp1252", null);
                this.trueTypeFonts.put(((String)allNames[0]).toLowerCase(), path);
                if (alias != null) {
                    this.trueTypeFonts.put(alias.toLowerCase(), path);
                }
                String[][] stringArray2 = names = (String[][])allNames[2];
                int n3 = names.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] name2 = stringArray2[n4];
                    this.trueTypeFonts.put(name2[3].toLowerCase(), path);
                    ++n4;
                }
                String fullName = null;
                String familyName = null;
                names = (String[][])allNames[1];
                int k = 0;
                while (k < TTFamilyOrder.length) {
                    stringArray = names;
                    n2 = names.length;
                    n = 0;
                    while (n < n2) {
                        name = stringArray[n];
                        if (TTFamilyOrder[k].equals(name[0]) && TTFamilyOrder[k + 1].equals(name[1]) && TTFamilyOrder[k + 2].equals(name[2])) {
                            familyName = name[3].toLowerCase();
                            k = TTFamilyOrder.length;
                            break;
                        }
                        ++n;
                    }
                    k += 3;
                }
                if (familyName != null) {
                    String lastName = "";
                    stringArray = names = (String[][])allNames[2];
                    n2 = names.length;
                    n = 0;
                    while (n < n2) {
                        name = stringArray[n];
                        int k2 = 0;
                        while (k2 < TTFamilyOrder.length) {
                            if (TTFamilyOrder[k2].equals(name[0]) && TTFamilyOrder[k2 + 1].equals(name[1]) && TTFamilyOrder[k2 + 2].equals(name[2]) && !(fullName = name[3]).equals(lastName)) {
                                lastName = fullName;
                                this.registerFamily(familyName, fullName, null);
                                break;
                            }
                            k2 += 3;
                        }
                        ++n;
                    }
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                if (alias != null) {
                    LOGGER.error("You can't define an alias for a true type collection.");
                }
                String[] names = BaseFont.enumerateTTCNames(path);
                int i = 0;
                while (i < names.length) {
                    this.register(String.valueOf(path) + "," + i);
                    ++i;
                }
            } else if (path.toLowerCase().endsWith(".afm") || path.toLowerCase().endsWith(".pfm")) {
                BaseFont bf = BaseFont.createFont(path, "Cp1252", false);
                String fullName = bf.getFullFontName()[0][3].toLowerCase();
                String familyName = bf.getFamilyFontName()[0][3].toLowerCase();
                String psName = bf.getPostscriptFontName().toLowerCase();
                this.registerFamily(familyName, fullName, null);
                this.trueTypeFonts.put(psName, path);
                this.trueTypeFonts.put(fullName, path);
            }
            if (LOGGER.isLogging(Level.TRACE)) {
                LOGGER.trace(String.format("Registered %s", path));
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public int registerDirectory(String dir) {
        return this.registerDirectory(dir, false);
    }

    public int registerDirectory(String dir, boolean scanSubdirectories) {
        String[] files;
        File file;
        int count;
        block16: {
            block15: {
                if (LOGGER.isLogging(Level.DEBUG)) {
                    LOGGER.debug(String.format("Registering directory %s, looking for fonts", dir));
                }
                count = 0;
                file = new File(dir);
                if (file.exists() && file.isDirectory()) break block15;
                return 0;
            }
            files = file.list();
            if (files != null) break block16;
            return 0;
        }
        try {
            int k = 0;
            while (k < files.length) {
                try {
                    file = new File(dir, files[k]);
                    if (file.isDirectory()) {
                        if (scanSubdirectories) {
                            count += this.registerDirectory(file.getAbsolutePath(), true);
                        }
                    } else {
                        String suffix;
                        String name = file.getPath();
                        String string = suffix = name.length() < 4 ? null : name.substring(name.length() - 4).toLowerCase();
                        if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                            File pfb = new File(String.valueOf(name.substring(0, name.length() - 4)) + ".pfb");
                            if (pfb.exists()) {
                                this.register(name, null);
                                ++count;
                            }
                        } else if (".ttf".equals(suffix) || ".otf".equals(suffix) || ".ttc".equals(suffix)) {
                            this.register(name, null);
                            ++count;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++k;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public int registerDirectories() {
        int count = 0;
        String windir = System.getenv("windir");
        String fileseparator = System.getProperty("file.separator");
        if (windir != null && fileseparator != null) {
            count += this.registerDirectory(String.valueOf(windir) + fileseparator + "fonts");
        }
        count += this.registerDirectory("/usr/share/X11/fonts", true);
        count += this.registerDirectory("/usr/X/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/openwin/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/share/fonts", true);
        count += this.registerDirectory("/usr/X11R6/lib/X11/fonts", true);
        count += this.registerDirectory("/Library/Fonts");
        return count += this.registerDirectory("/System/Library/Fonts");
    }

    public Set<String> getRegisteredFonts() {
        return this.trueTypeFonts.keySet();
    }

    public Set<String> getRegisteredFamilies() {
        return this.fontFamilies.keySet();
    }

    @Override
    public boolean isRegistered(String fontname) {
        return this.trueTypeFonts.containsKey(fontname.toLowerCase());
    }
}

