/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.tsp.cms;

import java.io.IOException;
import java.io.OutputStream;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.cms.AttributeTable;
import org.kg.bouncycastle.asn1.cms.ContentInfo;
import org.kg.bouncycastle.asn1.cms.Evidence;
import org.kg.bouncycastle.asn1.cms.TimeStampAndCRL;
import org.kg.bouncycastle.asn1.cms.TimeStampedData;
import org.kg.bouncycastle.asn1.cms.TimeStampedDataParser;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.operator.DigestCalculator;
import org.kg.bouncycastle.operator.DigestCalculatorProvider;
import org.kg.bouncycastle.operator.OperatorCreationException;
import org.kg.bouncycastle.tsp.TSPException;
import org.kg.bouncycastle.tsp.TimeStampToken;
import org.kg.bouncycastle.tsp.TimeStampTokenInfo;
import org.kg.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import org.kg.bouncycastle.tsp.cms.MetaDataUtil;
import org.kg.bouncycastle.util.Arrays;

class TimeStampDataUtil {
    private final TimeStampAndCRL[] timeStamps;
    private final MetaDataUtil metaDataUtil;

    TimeStampDataUtil(TimeStampedData timeStampedData) {
        this.metaDataUtil = new MetaDataUtil(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.timeStamps = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampDataUtil(TimeStampedDataParser timeStampedData) throws IOException {
        this.metaDataUtil = new MetaDataUtil(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.timeStamps = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampToken getTimeStampToken(TimeStampAndCRL timeStampAndCRL) throws CMSException {
        ContentInfo timeStampToken = timeStampAndCRL.getTimeStampToken();
        try {
            TimeStampToken token = new TimeStampToken(timeStampToken);
            return token;
        }
        catch (IOException e) {
            throw new CMSException("unable to parse token data: " + e.getMessage(), e);
        }
        catch (TSPException e) {
            if (e.getCause() instanceof CMSException) {
                throw (CMSException)e.getCause();
            }
            throw new CMSException("token data invalid: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("token data invalid: " + e.getMessage(), e);
        }
    }

    void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        this.metaDataUtil.initialiseMessageImprintDigestCalculator(calculator);
    }

    DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider calculatorProvider) throws OperatorCreationException {
        try {
            TimeStampToken token = this.getTimeStampToken(this.timeStamps[0]);
            TimeStampTokenInfo info = token.getTimeStampInfo();
            ASN1ObjectIdentifier algOID = info.getMessageImprintAlgOID();
            DigestCalculator calc = calculatorProvider.get(new AlgorithmIdentifier(algOID));
            this.initialiseMessageImprintDigestCalculator(calc);
            return calc;
        }
        catch (CMSException e) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + e.getMessage(), e);
        }
    }

    TimeStampToken[] getTimeStampTokens() throws CMSException {
        TimeStampToken[] tokens = new TimeStampToken[this.timeStamps.length];
        int i = 0;
        while (i < this.timeStamps.length) {
            tokens[i] = this.getTimeStampToken(this.timeStamps[i]);
            ++i;
        }
        return tokens;
    }

    TimeStampAndCRL[] getTimeStamps() {
        return this.timeStamps;
    }

    byte[] calculateNextHash(DigestCalculator calculator) throws CMSException {
        TimeStampAndCRL tspToken = this.timeStamps[this.timeStamps.length - 1];
        OutputStream out = calculator.getOutputStream();
        try {
            out.write(tspToken.getEncoded("DER"));
            out.close();
            return calculator.getDigest();
        }
        catch (IOException e) {
            throw new CMSException("exception calculating hash: " + e.getMessage(), e);
        }
    }

    void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest) throws ImprintDigestInvalidException, CMSException {
        byte[] currentDigest = dataDigest;
        int i = 0;
        while (i < this.timeStamps.length) {
            try {
                TimeStampToken token = this.getTimeStampToken(this.timeStamps[i]);
                if (i > 0) {
                    TimeStampTokenInfo info = token.getTimeStampInfo();
                    DigestCalculator calculator = calculatorProvider.get(info.getHashAlgorithm());
                    calculator.getOutputStream().write(this.timeStamps[i - 1].getEncoded("DER"));
                    currentDigest = calculator.getDigest();
                }
                this.compareDigest(token, currentDigest);
            }
            catch (IOException e) {
                throw new CMSException("exception calculating hash: " + e.getMessage(), e);
            }
            catch (OperatorCreationException e) {
                throw new CMSException("cannot create digest: " + e.getMessage(), e);
            }
            ++i;
        }
    }

    void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        byte[] encToken;
        byte[] currentDigest = dataDigest;
        try {
            encToken = timeStampToken.getEncoded();
        }
        catch (IOException e) {
            throw new CMSException("exception encoding timeStampToken: " + e.getMessage(), e);
        }
        int i = 0;
        while (i < this.timeStamps.length) {
            try {
                TimeStampToken token = this.getTimeStampToken(this.timeStamps[i]);
                if (i > 0) {
                    TimeStampTokenInfo info = token.getTimeStampInfo();
                    DigestCalculator calculator = calculatorProvider.get(info.getHashAlgorithm());
                    calculator.getOutputStream().write(this.timeStamps[i - 1].getEncoded("DER"));
                    currentDigest = calculator.getDigest();
                }
                this.compareDigest(token, currentDigest);
                if (Arrays.areEqual(token.getEncoded(), encToken)) {
                    return;
                }
            }
            catch (IOException e) {
                throw new CMSException("exception calculating hash: " + e.getMessage(), e);
            }
            catch (OperatorCreationException e) {
                throw new CMSException("cannot create digest: " + e.getMessage(), e);
            }
            ++i;
        }
        throw new ImprintDigestInvalidException("passed in token not associated with timestamps present", timeStampToken);
    }

    private void compareDigest(TimeStampToken timeStampToken, byte[] digest) throws ImprintDigestInvalidException {
        TimeStampTokenInfo info = timeStampToken.getTimeStampInfo();
        byte[] tsrMessageDigest = info.getMessageImprintDigest();
        if (!Arrays.areEqual(digest, tsrMessageDigest)) {
            throw new ImprintDigestInvalidException("hash calculated is different from MessageImprintDigest found in TimeStampToken", timeStampToken);
        }
    }

    String getFileName() {
        return this.metaDataUtil.getFileName();
    }

    String getMediaType() {
        return this.metaDataUtil.getMediaType();
    }

    AttributeTable getOtherMetaData() {
        return new AttributeTable(this.metaDataUtil.getOtherMetaData());
    }
}

