/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.pqc.jcajce.provider.mceliece;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.kg.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.kg.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import org.kg.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import org.kg.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import org.kg.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;

public class McElieceKeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePublicKey) {
            BCMcEliecePublicKey k = (BCMcEliecePublicKey)key;
            return new McEliecePublicKeyParameters(k.getOIDString(), k.getN(), k.getT(), k.getG(), k.getMcElieceParameters());
        }
        throw new InvalidKeyException("can't identify McEliece public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePrivateKey) {
            BCMcEliecePrivateKey k = (BCMcEliecePrivateKey)key;
            return new McEliecePrivateKeyParameters(k.getOIDString(), k.getN(), k.getK(), k.getField(), k.getGoppaPoly(), k.getSInv(), k.getP1(), k.getP2(), k.getH(), k.getQInv(), k.getMcElieceParameters());
        }
        throw new InvalidKeyException("can't identify McEliece private key.");
    }
}

