/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.pkcs;

import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.pkcs.ContentInfo;
import org.kg.bouncycastle.asn1.pkcs.MacData;
import org.kg.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.kg.bouncycastle.asn1.pkcs.Pfx;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.cert.CertIOException;
import org.kg.bouncycastle.pkcs.MacDataGenerator;
import org.kg.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import org.kg.bouncycastle.pkcs.PKCSException;
import org.kg.bouncycastle.util.Arrays;

public class PKCS12PfxPdu {
    private Pfx pfx;

    private static Pfx parseBytes(byte[] pfxEncoding) throws IOException {
        try {
            return Pfx.getInstance(ASN1Primitive.fromByteArray(pfxEncoding));
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public PKCS12PfxPdu(Pfx pfx) {
        this.pfx = pfx;
    }

    public PKCS12PfxPdu(byte[] pfx) throws IOException {
        this(PKCS12PfxPdu.parseBytes(pfx));
    }

    public ContentInfo[] getContentInfos() {
        ASN1Sequence seq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
        ContentInfo[] content = new ContentInfo[seq.size()];
        int i = 0;
        while (i != seq.size()) {
            content[i] = ContentInfo.getInstance(seq.getObjectAt(i));
            ++i;
        }
        return content;
    }

    public boolean hasMac() {
        return this.pfx.getMacData() != null;
    }

    public AlgorithmIdentifier getMacAlgorithmID() {
        MacData md = this.pfx.getMacData();
        if (md != null) {
            return md.getMac().getAlgorithmId();
        }
        return null;
    }

    public boolean isMacValid(PKCS12MacCalculatorBuilderProvider macCalcProviderBuilder, char[] password) throws PKCSException {
        if (this.hasMac()) {
            MacData pfxmData = this.pfx.getMacData();
            MacDataGenerator mdGen = new MacDataGenerator(macCalcProviderBuilder.get(new AlgorithmIdentifier(pfxmData.getMac().getAlgorithmId().getAlgorithm(), (ASN1Encodable)new PKCS12PBEParams(pfxmData.getSalt(), pfxmData.getIterationCount().intValue()))));
            try {
                MacData mData = mdGen.build(password, ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
                return Arrays.constantTimeAreEqual(mData.getEncoded(), this.pfx.getMacData().getEncoded());
            }
            catch (IOException e) {
                throw new PKCSException("unable to process AuthSafe: " + e.getMessage());
            }
        }
        throw new IllegalStateException("no MAC present on PFX");
    }

    public Pfx toASN1Structure() {
        return this.pfx;
    }

    public byte[] getEncoded() throws IOException {
        return this.toASN1Structure().getEncoded();
    }

    public byte[] getEncoded(String encoding) throws IOException {
        return this.toASN1Structure().getEncoded(encoding);
    }
}

