/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.operator.bc;

import java.io.IOException;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.crypto.ExtendedDigest;
import org.kg.bouncycastle.crypto.Signer;
import org.kg.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.kg.bouncycastle.crypto.signers.RSADigestSigner;
import org.kg.bouncycastle.crypto.util.PublicKeyFactory;
import org.kg.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.kg.bouncycastle.operator.OperatorCreationException;
import org.kg.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new RSADigestSigner(dig);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

