/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.openssl;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.cms.ContentInfo;
import org.kg.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.kg.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.kg.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.kg.bouncycastle.asn1.x509.DSAParameter;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.kg.bouncycastle.cert.X509AttributeCertificateHolder;
import org.kg.bouncycastle.cert.X509CRLHolder;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.openssl.PEMEncryptor;
import org.kg.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.kg.bouncycastle.util.Strings;
import org.kg.bouncycastle.util.io.pem.PemGenerationException;
import org.kg.bouncycastle.util.io.pem.PemHeader;
import org.kg.bouncycastle.util.io.pem.PemObject;
import org.kg.bouncycastle.util.io.pem.PemObjectGenerator;

public class MiscPEMGenerator
implements PemObjectGenerator {
    private static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};
    private static final byte[] hexEncodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final Object obj;
    private final PEMEncryptor encryptor;

    public MiscPEMGenerator(Object o) {
        this.obj = o;
        this.encryptor = null;
    }

    public MiscPEMGenerator(Object o, PEMEncryptor encryptor) {
        this.obj = o;
        this.encryptor = encryptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PemObject createPemObject(Object o) throws IOException {
        byte[] encoding;
        String type;
        if (o instanceof PemObject) {
            return (PemObject)o;
        }
        if (o instanceof PemObjectGenerator) {
            return ((PemObjectGenerator)o).generate();
        }
        if (o instanceof X509CertificateHolder) {
            type = "CERTIFICATE";
            encoding = ((X509CertificateHolder)o).getEncoded();
        } else if (o instanceof X509CRLHolder) {
            type = "X509 CRL";
            encoding = ((X509CRLHolder)o).getEncoded();
        } else if (o instanceof PrivateKeyInfo) {
            PrivateKeyInfo info = (PrivateKeyInfo)o;
            ASN1ObjectIdentifier algOID = info.getPrivateKeyAlgorithm().getAlgorithm();
            if (algOID.equals(PKCSObjectIdentifiers.rsaEncryption)) {
                type = "RSA PRIVATE KEY";
                encoding = info.parsePrivateKey().toASN1Primitive().getEncoded();
            } else if (algOID.equals(dsaOids[0]) || algOID.equals(dsaOids[1])) {
                type = "DSA PRIVATE KEY";
                DSAParameter p = DSAParameter.getInstance(info.getPrivateKeyAlgorithm().getParameters());
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(new DERInteger(0L));
                v.add(new DERInteger(p.getP()));
                v.add(new DERInteger(p.getQ()));
                v.add(new DERInteger(p.getG()));
                BigInteger x = ASN1Integer.getInstance(info.parsePrivateKey()).getValue();
                BigInteger y = p.getG().modPow(x, p.getP());
                v.add(new DERInteger(y));
                v.add(new DERInteger(x));
                encoding = new DERSequence(v).getEncoded();
            } else {
                if (!algOID.equals(X9ObjectIdentifiers.id_ecPublicKey)) throw new IOException("Cannot identify private key");
                type = "EC PRIVATE KEY";
                encoding = info.parsePrivateKey().toASN1Primitive().getEncoded();
            }
        } else if (o instanceof SubjectPublicKeyInfo) {
            type = "PUBLIC KEY";
            encoding = ((SubjectPublicKeyInfo)o).getEncoded();
        } else if (o instanceof X509AttributeCertificateHolder) {
            type = "ATTRIBUTE CERTIFICATE";
            encoding = ((X509AttributeCertificateHolder)o).getEncoded();
        } else if (o instanceof PKCS10CertificationRequest) {
            type = "CERTIFICATE REQUEST";
            encoding = ((PKCS10CertificationRequest)o).getEncoded();
        } else {
            if (!(o instanceof ContentInfo)) throw new PemGenerationException("unknown object passed - can't encode.");
            type = "PKCS7";
            encoding = ((ContentInfo)o).getEncoded();
        }
        if (this.encryptor == null) return new PemObject(type, encoding);
        String dekAlgName = Strings.toUpperCase(this.encryptor.getAlgorithm());
        if (dekAlgName.equals("DESEDE")) {
            dekAlgName = "DES-EDE3-CBC";
        }
        byte[] iv = this.encryptor.getIV();
        byte[] encData = this.encryptor.encrypt(encoding);
        ArrayList<PemHeader> headers = new ArrayList<PemHeader>(2);
        headers.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        headers.add(new PemHeader("DEK-Info", String.valueOf(dekAlgName) + "," + this.getHexEncoded(iv)));
        return new PemObject(type, headers, encData);
    }

    private String getHexEncoded(byte[] bytes) throws IOException {
        char[] chars = new char[bytes.length * 2];
        int i = 0;
        while (i != bytes.length) {
            int v = bytes[i] & 0xFF;
            chars[2 * i] = (char)hexEncodingTable[v >>> 4];
            chars[2 * i + 1] = (char)hexEncodingTable[v & 0xF];
            ++i;
        }
        return new String(chars);
    }

    public PemObject generate() throws PemGenerationException {
        try {
            return this.createPemObject(this.obj);
        }
        catch (IOException e) {
            throw new PemGenerationException("encoding exception: " + e.getMessage(), e);
        }
    }
}

