/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.math.ec;

import java.math.BigInteger;
import org.kg.bouncycastle.math.ec.AbstractECMultiplier;
import org.kg.bouncycastle.math.ec.ECCurve;
import org.kg.bouncycastle.math.ec.ECPoint;
import org.kg.bouncycastle.math.ec.PreCompInfo;
import org.kg.bouncycastle.math.ec.Tnaf;
import org.kg.bouncycastle.math.ec.WTauNafPreCompInfo;
import org.kg.bouncycastle.math.ec.ZTauElement;

public class WTauNafMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint point, BigInteger k) {
        if (!(point instanceof ECPoint.F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint.F2m p = (ECPoint.F2m)point;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        int m = curve.getM();
        byte a = curve.getA().toBigInteger().byteValue();
        byte mu = curve.getMu();
        BigInteger[] s = curve.getSi();
        ZTauElement rho = Tnaf.partModReduction(k, m, a, s, mu, (byte)10);
        return this.multiplyWTnaf(p, rho, curve.getPreCompInfo(p), a, mu);
    }

    private ECPoint.F2m multiplyWTnaf(ECPoint.F2m p, ZTauElement lambda, PreCompInfo preCompInfo, byte a, byte mu) {
        ZTauElement[] alpha = a == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigInteger tw = Tnaf.getTw(mu, 4);
        byte[] u = Tnaf.tauAdicWNaf(mu, lambda, (byte)4, BigInteger.valueOf(16L), tw, alpha);
        return WTauNafMultiplier.multiplyFromWTnaf(p, u, preCompInfo);
    }

    private static ECPoint.F2m multiplyFromWTnaf(ECPoint.F2m p, byte[] u, PreCompInfo preCompInfo) {
        ECPoint.F2m[] pu;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        byte a = curve.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            pu = Tnaf.getPreComp(p, a);
            curve.setPreCompInfo(p, new WTauNafPreCompInfo(pu));
        } else {
            pu = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        ECPoint.F2m q = (ECPoint.F2m)p.getCurve().getInfinity();
        int i = u.length - 1;
        while (i >= 0) {
            q = Tnaf.tau(q);
            if (u[i] != 0) {
                q = u[i] > 0 ? q.addSimple(pu[u[i]]) : q.subtractSimple(pu[-u[i]]);
            }
            --i;
        }
        return q;
    }
}

