/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.kg.bouncycastle.jce.exception.ExtCertPathValidatorException;
import org.kg.bouncycastle.jce.provider.AnnotatedException;
import org.kg.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.kg.bouncycastle.jce.provider.RFC3281CertPathUtilities;
import org.kg.bouncycastle.util.Selector;
import org.kg.bouncycastle.x509.ExtendedPKIXParameters;
import org.kg.bouncycastle.x509.X509AttributeCertStoreSelector;
import org.kg.bouncycastle.x509.X509AttributeCertificate;

public class PKIXAttrCertPathValidatorSpi
extends CertPathValidatorSpi {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (!(params instanceof ExtendedPKIXParameters)) {
            StringBuffer stringBuffer = new StringBuffer("Parameters must be a ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.kg.bouncycastle.x509.ExtendedPKIXParameters");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new InvalidAlgorithmParameterException(stringBuffer.append(clazz.getName()).append(" instance.").toString());
        }
        ExtendedPKIXParameters pkixParams = (ExtendedPKIXParameters)params;
        Selector certSelect = pkixParams.getTargetConstraints();
        if (!(certSelect instanceof X509AttributeCertStoreSelector)) {
            StringBuffer stringBuffer = new StringBuffer("TargetConstraints must be an instance of ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.kg.bouncycastle.x509.X509AttributeCertStoreSelector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new InvalidAlgorithmParameterException(stringBuffer.append(clazz.getName()).append(" for ").append(this.getClass().getName()).append(" class.").toString());
        }
        X509AttributeCertificate attrCert = ((X509AttributeCertStoreSelector)certSelect).getAttributeCert();
        CertPath holderCertPath = RFC3281CertPathUtilities.processAttrCert1(attrCert, pkixParams);
        CertPathValidatorResult result = RFC3281CertPathUtilities.processAttrCert2(certPath, pkixParams);
        X509Certificate issuerCert = (X509Certificate)certPath.getCertificates().get(0);
        RFC3281CertPathUtilities.processAttrCert3(issuerCert, pkixParams);
        RFC3281CertPathUtilities.processAttrCert4(issuerCert, pkixParams);
        RFC3281CertPathUtilities.processAttrCert5(attrCert, pkixParams);
        RFC3281CertPathUtilities.processAttrCert7(attrCert, certPath, holderCertPath, pkixParams);
        RFC3281CertPathUtilities.additionalChecks(attrCert, pkixParams);
        Date date = null;
        try {
            date = CertPathValidatorUtilities.getValidCertDateFromValidityModel(pkixParams, null, -1);
        }
        catch (AnnotatedException e) {
            throw new ExtCertPathValidatorException("Could not get validity date from attribute certificate.", e);
        }
        RFC3281CertPathUtilities.checkCRLs(attrCert, pkixParams, issuerCert, date, certPath.getCertificates());
        return result;
    }
}

