/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.kg.bouncycastle.crypto.BlockCipher;
import org.kg.bouncycastle.crypto.BufferedBlockCipher;
import org.kg.bouncycastle.crypto.CipherKeyGenerator;
import org.kg.bouncycastle.crypto.engines.RC6Engine;
import org.kg.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.kg.bouncycastle.crypto.macs.GMac;
import org.kg.bouncycastle.crypto.modes.CBCBlockCipher;
import org.kg.bouncycastle.crypto.modes.CFBBlockCipher;
import org.kg.bouncycastle.crypto.modes.GCMBlockCipher;
import org.kg.bouncycastle.crypto.modes.OFBBlockCipher;
import org.kg.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class RC6 {
    static /* synthetic */ Class class$0;

    private RC6() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for RC6 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("RC6", "KGBC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "RC6 IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new RC6Engine()), 128);
        }
    }

    public static class CFB
    extends BaseBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new RC6Engine(), 128)), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new RC6Engine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new RC6Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("RC6", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.kg.bouncycastle.jcajce.provider.symmetric.RC6");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.RC6", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.RC6", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.RC6", String.valueOf(PREFIX) + "$AlgParams");
            this.addGMacAlgorithm(provider, "RC6", String.valueOf(PREFIX) + "$GMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "RC6", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new RC6Engine(), 128)), 128);
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.kg.bouncycastle.crypto.macs.Poly1305(new RC6Engine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-RC6", 256, new Poly1305KeyGenerator());
        }
    }
}

