/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.digest;

import org.kg.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import org.kg.bouncycastle.crypto.CipherKeyGenerator;
import org.kg.bouncycastle.crypto.digests.TigerDigest;
import org.kg.bouncycastle.crypto.macs.HMac;
import org.kg.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.kg.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import org.kg.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public class Tiger {
    static /* synthetic */ Class class$0;

    private Tiger() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new TigerDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new TigerDigest((TigerDigest)this.digest);
            return d;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new TigerDigest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACTIGER", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.kg.bouncycastle.jcajce.provider.digest.Tiger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.TIGER", String.valueOf(PREFIX) + "$Digest");
            provider.addAlgorithm("MessageDigest.Tiger", String.valueOf(PREFIX) + "$Digest");
            this.addHMACAlgorithm(provider, "TIGER", String.valueOf(PREFIX) + "$HashMac", String.valueOf(PREFIX) + "$KeyGenerator");
            this.addHMACAlias(provider, "TIGER", IANAObjectIdentifiers.hmacTIGER);
            provider.addAlgorithm("SecretKeyFactory.PBEWITHHMACTIGER", String.valueOf(PREFIX) + "$PBEWithMacKeyFactory");
        }
    }

    public static class PBEWithHashMac
    extends BaseMac {
        public PBEWithHashMac() {
            super(new HMac(new TigerDigest()), 2, 3, 192);
        }
    }

    public static class PBEWithMacKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithMacKeyFactory() {
            super("PBEwithHmacTiger", null, false, 2, 3, 192, 0);
        }
    }

    public static class TigerHmac
    extends BaseMac {
        public TigerHmac() {
            super(new HMac(new TigerDigest()));
        }
    }
}

