/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.asymmetric.util;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.EllipticCurve;
import org.kg.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.kg.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.kg.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.kg.bouncycastle.jce.spec.ECParameterSpec;
import org.kg.bouncycastle.math.ec.ECCurve;
import org.kg.bouncycastle.math.ec.ECPoint;

public class EC5Util {
    public static EllipticCurve convertCurve(ECCurve curve, byte[] seed) {
        if (curve instanceof ECCurve.Fp) {
            return new EllipticCurve(new ECFieldFp(((ECCurve.Fp)curve).getQ()), curve.getA().toBigInteger(), curve.getB().toBigInteger(), null);
        }
        ECCurve.F2m curveF2m = (ECCurve.F2m)curve;
        if (curveF2m.isTrinomial()) {
            int[] ks = new int[]{curveF2m.getK1()};
            return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), null);
        }
        int[] ks = new int[]{curveF2m.getK3(), curveF2m.getK2(), curveF2m.getK1()};
        return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), null);
    }

    public static ECCurve convertCurve(EllipticCurve ec) {
        ECField field = ec.getField();
        BigInteger a = ec.getA();
        BigInteger b = ec.getB();
        if (field instanceof ECFieldFp) {
            return new ECCurve.Fp(((ECFieldFp)field).getP(), a, b);
        }
        ECFieldF2m fieldF2m = (ECFieldF2m)field;
        int m = fieldF2m.getM();
        int[] ks = ECUtil.convertMidTerms(fieldF2m.getMidTermsOfReductionPolynomial());
        return new ECCurve.F2m(m, ks[0], ks[1], ks[2], a, b);
    }

    public static java.security.spec.ECParameterSpec convertSpec(EllipticCurve ellipticCurve, ECParameterSpec spec) {
        if (spec instanceof ECNamedCurveParameterSpec) {
            return new ECNamedCurveSpec(((ECNamedCurveParameterSpec)spec).getName(), ellipticCurve, new java.security.spec.ECPoint(spec.getG().getAffineXCoord().toBigInteger(), spec.getG().getAffineYCoord().toBigInteger()), spec.getN(), spec.getH());
        }
        return new java.security.spec.ECParameterSpec(ellipticCurve, new java.security.spec.ECPoint(spec.getG().getAffineXCoord().toBigInteger(), spec.getG().getAffineYCoord().toBigInteger()), spec.getN(), spec.getH().intValue());
    }

    public static ECParameterSpec convertSpec(java.security.spec.ECParameterSpec ecSpec, boolean withCompression) {
        ECCurve curve = EC5Util.convertCurve(ecSpec.getCurve());
        return new ECParameterSpec(curve, EC5Util.convertPoint(curve, ecSpec.getGenerator(), withCompression), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
    }

    public static ECPoint convertPoint(java.security.spec.ECParameterSpec ecSpec, java.security.spec.ECPoint point, boolean withCompression) {
        return EC5Util.convertPoint(EC5Util.convertCurve(ecSpec.getCurve()), point, withCompression);
    }

    public static ECPoint convertPoint(ECCurve curve, java.security.spec.ECPoint point, boolean withCompression) {
        return curve.createPoint(point.getAffineX(), point.getAffineY(), withCompression);
    }
}

