/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.asymmetric.dstu;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.kg.bouncycastle.crypto.generators.DSTU4145KeyPairGenerator;
import org.kg.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.kg.bouncycastle.crypto.params.ECDomainParameters;
import org.kg.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.kg.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.kg.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PrivateKey;
import org.kg.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import org.kg.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kg.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.kg.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.kg.bouncycastle.jce.spec.ECParameterSpec;
import org.kg.bouncycastle.math.ec.ECCurve;
import org.kg.bouncycastle.math.ec.ECPoint;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    Object ecParams = null;
    ECKeyPairGenerator engine = new DSTU4145KeyPairGenerator();
    String algorithm = "DSTU4145";
    ECKeyGenerationParameters param;
    SecureRandom random = null;
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSTU4145");
    }

    public void initialize(int strength, SecureRandom random) {
        this.random = random;
        if (this.ecParams != null) {
            try {
                this.initialize((ECGenParameterSpec)this.ecParams, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidParameterException("key size not configurable.");
            }
        } else {
            throw new InvalidParameterException("unknown key size.");
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof ECParameterSpec) {
            ECParameterSpec p = (ECParameterSpec)params;
            this.ecParams = params;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params instanceof java.security.spec.ECParameterSpec) {
            java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)params;
            this.ecParams = params;
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params instanceof ECGenParameterSpec || params instanceof ECNamedCurveGenParameterSpec) {
            String curveName = params instanceof ECGenParameterSpec ? ((ECGenParameterSpec)params).getName() : ((ECNamedCurveGenParameterSpec)params).getName();
            ECDomainParameters ecP = DSTU4145NamedCurves.getByOID(new ASN1ObjectIdentifier(curveName));
            if (ecP == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
            }
            this.ecParams = new ECNamedCurveSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() != null) {
            ECParameterSpec p = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            this.ecParams = params;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else {
            if (params == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec: " + params.getClass().getName());
        }
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            throw new IllegalStateException("DSTU Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
        ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
        if (this.ecParams instanceof ECParameterSpec) {
            ECParameterSpec p = (ECParameterSpec)this.ecParams;
            BCDSTU4145PublicKey pubKey = new BCDSTU4145PublicKey(this.algorithm, pub, p);
            return new KeyPair(pubKey, new BCDSTU4145PrivateKey(this.algorithm, priv, pubKey, p));
        }
        if (this.ecParams == null) {
            return new KeyPair(new BCDSTU4145PublicKey(this.algorithm, pub), new BCDSTU4145PrivateKey(this.algorithm, priv));
        }
        java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
        BCDSTU4145PublicKey pubKey = new BCDSTU4145PublicKey(this.algorithm, pub, p);
        return new KeyPair(pubKey, new BCDSTU4145PrivateKey(this.algorithm, priv, pubKey, p));
    }
}

