/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kg.bouncycastle.asn1.dvcs.CertEtcToken;
import org.kg.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import org.kg.bouncycastle.asn1.dvcs.DVCSTime;
import org.kg.bouncycastle.asn1.dvcs.Data;
import org.kg.bouncycastle.asn1.dvcs.ServiceType;
import org.kg.bouncycastle.asn1.dvcs.TargetEtcChain;
import org.kg.bouncycastle.asn1.x509.Extension;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.dvcs.DVCSException;
import org.kg.bouncycastle.dvcs.DVCSRequest;
import org.kg.bouncycastle.dvcs.DVCSRequestBuilder;
import org.kg.bouncycastle.dvcs.TargetChain;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder cert) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, cert.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date requestTime) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(requestTime));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

