/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.kg.bouncycastle.crypto.tls.AbstractTlsPeer;
import org.kg.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.kg.bouncycastle.crypto.tls.NewSessionTicket;
import org.kg.bouncycastle.crypto.tls.ProtocolVersion;
import org.kg.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.kg.bouncycastle.crypto.tls.TlsCipherFactory;
import org.kg.bouncycastle.crypto.tls.TlsClient;
import org.kg.bouncycastle.crypto.tls.TlsClientContext;
import org.kg.bouncycastle.crypto.tls.TlsCompression;
import org.kg.bouncycastle.crypto.tls.TlsECCUtils;
import org.kg.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.kg.bouncycastle.crypto.tls.TlsFatalAlert;
import org.kg.bouncycastle.crypto.tls.TlsNullCompression;
import org.kg.bouncycastle.crypto.tls.TlsSession;
import org.kg.bouncycastle.crypto.tls.TlsUtils;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsClientContext context;
    protected Vector supportedSignatureAlgorithms;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;

    public AbstractTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public AbstractTlsClient(TlsCipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    public void init(TlsClientContext context) {
        this.context = context;
    }

    public TlsSession getSessionToResume() {
        return null;
    }

    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv12;
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = null;
        ProtocolVersion clientVersion = this.context.getClientVersion();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion)) {
            short[] hashAlgorithms = new short[]{6, 5, 4, 3, 2};
            short[] signatureAlgorithms = new short[]{1};
            this.supportedSignatureAlgorithms = new Vector();
            int i = 0;
            while (i < hashAlgorithms.length) {
                int j = 0;
                while (j < signatureAlgorithms.length) {
                    this.supportedSignatureAlgorithms.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[i], signatureAlgorithms[j]));
                    ++j;
                }
                ++i;
            }
            this.supportedSignatureAlgorithms.addElement(new SignatureAndHashAlgorithm(2, 2));
            clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientExtensions);
            TlsUtils.addSignatureAlgorithmsExtension(clientExtensions, this.supportedSignatureAlgorithms);
        }
        if (TlsECCUtils.containsECCCipherSuites(this.getCipherSuites())) {
            this.namedCurves = new int[]{23, 24};
            short[] sArray = new short[3];
            sArray[1] = 1;
            sArray[2] = 2;
            this.clientECPointFormats = sArray;
            clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientExtensions);
            TlsECCUtils.addSupportedEllipticCurvesExtension(clientExtensions, this.namedCurves);
            TlsECCUtils.addSupportedPointFormatsExtension(clientExtensions, this.clientECPointFormats);
        }
        return clientExtensions;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(serverVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    public short[] getCompressionMethods() {
        return new short[1];
    }

    public void notifySessionID(byte[] sessionID) {
    }

    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions != null) {
            if (serverExtensions.containsKey(TlsUtils.EXT_signature_algorithms)) {
                throw new TlsFatalAlert(47);
            }
            int[] namedCurves = TlsECCUtils.getSupportedEllipticCurvesExtension(serverExtensions);
            if (namedCurves != null) {
                throw new TlsFatalAlert(47);
            }
            this.serverECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(serverExtensions);
            if (this.serverECPointFormats != null && !TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                throw new TlsFatalAlert(47);
            }
        }
    }

    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

