/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.ec;

import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.crypto.ec.ECDecryptor;
import org.kg.bouncycastle.crypto.ec.ECPair;
import org.kg.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.kg.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECPoint tmp = pair.getX().multiply(this.key.getD());
        return pair.getY().add(tmp.negate()).normalize();
    }
}

