/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms.bc;

import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.KEKRecipient;
import org.kg.bouncycastle.cms.bc.CMSUtils;
import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.operator.OperatorException;
import org.kg.bouncycastle.operator.SymmetricKeyUnwrapper;
import org.kg.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;

public abstract class BcKEKRecipient
implements KEKRecipient {
    private SymmetricKeyUnwrapper unwrapper;

    public BcKEKRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        this.unwrapper = unwrapper;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            return CMSUtils.getBcKey(this.unwrapper.generateUnwrappedKey(contentEncryptionAlgorithm, encryptedContentEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

