/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1Set;
import org.kg.bouncycastle.asn1.BERSequence;
import org.kg.bouncycastle.asn1.DERSet;
import org.kg.bouncycastle.asn1.cms.ContentInfo;
import org.kg.bouncycastle.asn1.cms.SignedData;
import org.kg.bouncycastle.asn1.cms.SignerInfo;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSProcessable;
import org.kg.bouncycastle.cms.CMSProcessableByteArray;
import org.kg.bouncycastle.cms.CMSSignedHelper;
import org.kg.bouncycastle.cms.CMSTypedData;
import org.kg.bouncycastle.cms.CMSUtils;
import org.kg.bouncycastle.cms.SignerInformation;
import org.kg.bouncycastle.cms.SignerInformationStore;
import org.kg.bouncycastle.cms.SignerInformationVerifier;
import org.kg.bouncycastle.cms.SignerInformationVerifierProvider;
import org.kg.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.kg.bouncycastle.operator.OperatorCreationException;
import org.kg.bouncycastle.util.Store;

public class CMSSignedData {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSTypedData signedContent;
    SignerInformationStore signerInfoStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData c) {
        this.signedData = c.signedData;
        this.contentInfo = c.contentInfo;
        this.signedContent = c.signedContent;
        this.signerInfoStore = c.signerInfoStore;
    }

    public CMSSignedData(byte[] sigBlock) throws CMSException {
        this(CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, byte[] sigBlock) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(Map hashes, byte[] sigBlock) throws CMSException {
        this(hashes, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, InputStream sigData) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo((InputStream)new ASN1InputStream(sigData)));
    }

    public CMSSignedData(InputStream sigData) throws CMSException {
        this(CMSUtils.readContentInfo(sigData));
    }

    public CMSSignedData(final CMSProcessable signedContent, ContentInfo sigData) throws CMSException {
        this.signedContent = signedContent instanceof CMSTypedData ? (CMSTypedData)signedContent : new CMSTypedData(){

            public ASN1ObjectIdentifier getContentType() {
                return CMSSignedData.this.signedData.getEncapContentInfo().getContentType();
            }

            public void write(OutputStream out) throws IOException, CMSException {
                signedContent.write(out);
            }

            public Object getContent() {
                return signedContent.getContent();
            }
        };
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(Map hashes, ContentInfo sigData) throws CMSException {
        this.hashes = hashes;
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(ContentInfo sigData) throws CMSException {
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
        this.signedContent = this.signedData.getEncapContentInfo().getContent() != null ? new CMSProcessableByteArray(this.signedData.getEncapContentInfo().getContentType(), ((ASN1OctetString)this.signedData.getEncapContentInfo().getContent()).getOctets()) : null;
    }

    private SignedData getSignedData() throws CMSException {
        try {
            return SignedData.getInstance(this.contentInfo.getContent());
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set s = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            DefaultSignatureAlgorithmIdentifierFinder sigAlgFinder = new DefaultSignatureAlgorithmIdentifierFinder();
            int i = 0;
            while (i != s.size()) {
                SignerInfo info = SignerInfo.getInstance(s.getObjectAt(i));
                ASN1ObjectIdentifier contentType = this.signedData.getEncapContentInfo().getContentType();
                if (this.hashes == null) {
                    signerInfos.add(new SignerInformation(info, contentType, this.signedContent, null));
                } else {
                    Object obj = this.hashes.keySet().iterator().next();
                    byte[] hash = obj instanceof String ? (byte[])this.hashes.get(info.getDigestAlgorithm().getAlgorithm().getId()) : (byte[])this.hashes.get(info.getDigestAlgorithm().getAlgorithm());
                    signerInfos.add(new SignerInformation(info, contentType, null, hash));
                }
                ++i;
            }
            this.signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this.signerInfoStore;
    }

    public Store getCertificates() {
        return HELPER.getCertificates(this.signedData.getCertificates());
    }

    public Store getCRLs() {
        return HELPER.getCRLs(this.signedData.getCRLs());
    }

    public Store getAttributeCertificates() {
        return HELPER.getAttributeCertificates(this.signedData.getCertificates());
    }

    public Store getOtherRevocationInfo(ASN1ObjectIdentifier otherRevocationInfoFormat) {
        return HELPER.getOtherRevocationInfo(otherRevocationInfoFormat, this.signedData.getCRLs());
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSTypedData getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public boolean verifySignatures(SignerInformationVerifierProvider verifierProvider) throws CMSException {
        return this.verifySignatures(verifierProvider, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifySignatures(SignerInformationVerifierProvider verifierProvider, boolean ignoreCounterSignatures) throws CMSException {
        Collection signers = this.getSignerInfos().getSigners();
        Iterator it = signers.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            try {
                SignerInformationVerifier verifier = verifierProvider.get(signer.getSID());
                if (!signer.verify(verifier)) {
                    return false;
                }
                if (ignoreCounterSignatures) continue;
                Collection counterSigners = signer.getCounterSignatures().getSigners();
                Iterator cIt = counterSigners.iterator();
                while (cIt.hasNext()) {
                    SignerInformationVerifier counterVerifier;
                    SignerInformation counterSigner = (SignerInformation)cIt.next();
                    if (counterSigner.verify(counterVerifier = verifierProvider.get(signer.getSID()))) continue;
                    return false;
                }
            }
            catch (OperatorCreationException e) {
                throw new CMSException("failure in verifier provider: " + e.getMessage(), e);
            }
        }
        return true;
    }

    public static CMSSignedData replaceSigners(CMSSignedData signedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cms = new CMSSignedData(signedData);
        cms.signerInfoStore = signerInformationStore;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Iterator it = signerInformationStore.getSigners().iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            vec.add(signer.toASN1Structure());
        }
        DERSet digests = new DERSet(digestAlgs);
        DERSet signers = new DERSet(vec);
        ASN1Sequence sD = (ASN1Sequence)signedData.signedData.toASN1Primitive();
        vec = new ASN1EncodableVector();
        vec.add(sD.getObjectAt(0));
        vec.add(digests);
        int i = 2;
        while (i != sD.size() - 1) {
            vec.add(sD.getObjectAt(i));
            ++i;
        }
        vec.add(signers);
        cms.signedData = SignedData.getInstance(new BERSequence(vec));
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), cms.signedData);
        return cms;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData signedData, Store certificates, Store attrCerts, Store crls) throws CMSException {
        ASN1Set set;
        CMSSignedData cms = new CMSSignedData(signedData);
        ASN1Set certSet = null;
        ASN1Set crlSet = null;
        if (certificates != null || attrCerts != null) {
            ASN1Set set2;
            ArrayList certs = new ArrayList();
            if (certificates != null) {
                certs.addAll(CMSUtils.getCertificatesFromStore(certificates));
            }
            if (attrCerts != null) {
                certs.addAll(CMSUtils.getAttributeCertificatesFromStore(attrCerts));
            }
            if ((set2 = CMSUtils.createBerSetFromList(certs)).size() != 0) {
                certSet = set2;
            }
        }
        if (crls != null && (set = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(crls))).size() != 0) {
            crlSet = set;
        }
        cms.signedData = new SignedData(signedData.signedData.getDigestAlgorithms(), signedData.signedData.getEncapContentInfo(), certSet, crlSet, signedData.signedData.getSignerInfos());
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), cms.signedData);
        return cms;
    }
}

