/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.asn1.x509;

import org.kg.bouncycastle.asn1.ASN1Object;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1TaggedObject;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.x509.Extension;
import org.kg.bouncycastle.asn1.x509.Extensions;
import org.kg.bouncycastle.asn1.x509.PolicyInformation;

public class CertificatePolicies
extends ASN1Object {
    private final PolicyInformation[] policyInformation;

    public static CertificatePolicies getInstance(Object obj) {
        if (obj instanceof CertificatePolicies) {
            return (CertificatePolicies)obj;
        }
        if (obj != null) {
            return new CertificatePolicies(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static CertificatePolicies getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CertificatePolicies fromExtensions(Extensions extensions) {
        return CertificatePolicies.getInstance(extensions.getExtensionParsedValue(Extension.certificatePolicies));
    }

    public CertificatePolicies(PolicyInformation name) {
        this.policyInformation = new PolicyInformation[]{name};
    }

    public CertificatePolicies(PolicyInformation[] policyInformation) {
        this.policyInformation = policyInformation;
    }

    private CertificatePolicies(ASN1Sequence seq) {
        this.policyInformation = new PolicyInformation[seq.size()];
        int i = 0;
        while (i != seq.size()) {
            this.policyInformation[i] = PolicyInformation.getInstance(seq.getObjectAt(i));
            ++i;
        }
    }

    public PolicyInformation[] getPolicyInformation() {
        PolicyInformation[] tmp = new PolicyInformation[this.policyInformation.length];
        System.arraycopy(this.policyInformation, 0, tmp, 0, this.policyInformation.length);
        return tmp;
    }

    public PolicyInformation getPolicyInformation(ASN1ObjectIdentifier policyIdentifier) {
        int i = 0;
        while (i != this.policyInformation.length) {
            if (policyIdentifier.equals(this.policyInformation[i].getPolicyIdentifier())) {
                return this.policyInformation[i];
            }
            ++i;
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.policyInformation);
    }

    public String toString() {
        String p = null;
        int i = 0;
        while (i < this.policyInformation.length) {
            if (p != null) {
                p = String.valueOf(p) + ", ";
            }
            p = String.valueOf(p) + this.policyInformation[i];
            ++i;
        }
        return "CertificatePolicies: " + p;
    }
}

