/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.web;

import com.KGitextpdf.text.DocumentException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.PdfElectronicSealDetails;
import com.kinggrid.pdf.web.IOUtils;
import com.kinggrid.pdf.web.PdfResource;
import com.kinggrid.pdf.web.SignInfo;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebPDFHelper {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PdfResource pdfResource;
    private KGPdfHummer hummer;

    public void init(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        this.request = request;
        this.response = response;
    }

    /*
     * Exception decompiling
     */
    public void exec() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initHummer() throws IOException {
        Object obj;
        String id = this.request.getParameter("ID");
        String password = this.request.getParameter("password");
        byte[] p = null;
        if (password != null && !"".equals(password)) {
            p = password.getBytes();
        }
        if ((obj = this.pdfResource.get(id)) instanceof String) {
            String fileName = (String)obj;
            this.hummer = KGPdfHummer.createInstance(fileName, p, true);
        } else if (obj instanceof InputStream) {
            InputStream in = (InputStream)obj;
            this.hummer = KGPdfHummer.createInstance(in, p);
        } else {
            throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38\uff1a" + obj);
        }
    }

    public void download() throws IOException {
        String id = this.request.getParameter("ID");
        Object obj = this.pdfResource.get(id);
        if (obj instanceof String) {
            String fileName = (String)obj;
            this.down(new File(fileName));
        } else if (obj instanceof InputStream) {
            InputStream in = (InputStream)obj;
            this.down(String.valueOf(id) + ".PDF", in);
        } else {
            throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38\uff1a" + obj);
        }
    }

    protected void down(String fileName, InputStream file) throws IOException {
        this.response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8").replace("+", "%20"));
        this.response.addHeader("Content-Length", "" + file.available());
        this.response.setContentType("application/octet-stream");
        IOUtils.copyLarge(file, (OutputStream)this.response.getOutputStream());
    }

    public void down(File data) throws IOException {
        this.response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(data.getName(), "UTF-8").replace("+", "%20"));
        BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
        this.response.setContentType("application/octet-stream");
        FileInputStream fis = new FileInputStream(data);
        this.response.addHeader("Content-Length", "" + fis.available());
        try {
            IOUtils.copy(fis, toClient);
        }
        finally {
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(toClient);
        }
    }

    public void verifySingleSeal() throws DocumentException, IOException, CertificateException {
        this.initHummer();
        JSONObject obj = new JSONObject();
        String signId = this.request.getParameter("signid");
        int curpage = Integer.valueOf(this.request.getParameter("curpage"));
        PdfElectronicSealDetails pdfElectronicSealDetails = new PdfElectronicSealDetails();
        pdfElectronicSealDetails.setPagen(curpage);
        this.hummer.addExecute(pdfElectronicSealDetails);
        this.hummer.doExecute();
        List<PdfElectronicSealDetails.Signinfo> signinfos = pdfElectronicSealDetails.getSeals();
        SignInfo signInfo = this.getSigninfo(signinfos, signId);
        obj.put("signInfo", (Object)signInfo);
        this.response.getWriter().print(obj.toJSONString());
    }

    public void verifyWholeSeals() throws DocumentException, GeneralSecurityException, IOException {
        this.initHummer();
        JSONObject obj = new JSONObject();
        PdfElectronicSealDetails pdfElectronicSealDetails = new PdfElectronicSealDetails();
        this.hummer.addExecute(pdfElectronicSealDetails);
        this.hummer.doExecute();
        List<PdfElectronicSealDetails.Signinfo> signinfos = pdfElectronicSealDetails.getSeals();
        JSONArray signatures = this.hummer.getVerifySignatures();
        obj.put("signinfos", signinfos);
        obj.put("signatures", (Object)signatures);
        this.response.getWriter().print(obj.toJSONString());
    }

    public void verifySingleSignature() throws IOException, GeneralSecurityException {
        this.initHummer();
        String signId = this.request.getParameter("signid");
        String obj = this.hummer.verifySignature(signId);
        this.response.getWriter().print(obj);
    }

    private SignInfo getSigninfo(List<PdfElectronicSealDetails.Signinfo> signinfos, String id) throws CertificateException {
        KGBase64 base64 = new KGBase64();
        for (PdfElectronicSealDetails.Signinfo signinfo : signinfos) {
            if (!id.equals(signinfo.getId())) continue;
            SignInfo sInfo = new SignInfo();
            sInfo.setIndex(signinfo.getIndex());
            sInfo.setSignid(signinfo.getSignid());
            sInfo.setId(signinfo.getId());
            sInfo.setSignName(signinfo.getSignName());
            sInfo.setAppName(signinfo.getAppName());
            sInfo.setCompName(signinfo.getCompName());
            sInfo.setUserName(signinfo.getUserName());
            sInfo.setKeySn(signinfo.getKeySn());
            sInfo.setSignSn(signinfo.getSignSn());
            sInfo.setSignName(signinfo.getSignName());
            sInfo.setHash(signinfo.getHash());
            sInfo.setHashType(signinfo.getHashType());
            sInfo.setSignTime(signinfo.getSignTime());
            sInfo.setTamper(signinfo.isTamper());
            sInfo.setRect(signinfo.getRect());
            sInfo.setNewHash(new String(signinfo.getNewHash()));
            if (signinfo.getSignData() != null) {
                sInfo.setSignData(new String(signinfo.getSignData()));
            }
            if (signinfo.getCert() != null) {
                String cert = new String(signinfo.getCert());
                if (cert.indexOf("\r\n") != -1) {
                    cert = cert.replaceAll("\r\n", "");
                }
                if (cert.indexOf("\n") != -1) {
                    cert = cert.replaceAll("\n", "");
                }
                if (cert.indexOf("-----BEGIN CERTIFICATE-----") != -1) {
                    cert = cert.substring("-----BEGIN CERTIFICATE-----".length(), cert.length() - "-----BEGIN CERTIFICATE-----".length() + 2);
                }
                if (cert != null) {
                    byte[] s = base64.decode(cert);
                    ByteArrayInputStream bain = new ByteArrayInputStream(s);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate oCert = (X509Certificate)cf.generateCertificate(bain);
                    JSONObject object = new JSONObject();
                    object.put("serialNumber", (Object)oCert.getSerialNumber().toString(16));
                    object.put("subjectDN", (Object)oCert.getSubjectDN());
                    object.put("base64Cert", (Object)base64.encode(oCert.getEncoded()));
                    object.put("issuerDN", (Object)oCert.getIssuerDN());
                    object.put("sigAlg", (Object)oCert.getSigAlgName());
                    object.put("version", (Object)oCert.getVersion());
                    object.put("notBefore", (Object)oCert.getNotBefore());
                    object.put("notAfter", (Object)oCert.getNotAfter());
                    sInfo.setCert(object);
                }
            }
            return sInfo;
        }
        return null;
    }

    public void close() {
        if (this.hummer != null) {
            this.hummer.close();
        }
    }

    public PdfResource getPdfResource() {
        return this.pdfResource;
    }

    public void setPdfResource(PdfResource pdfResource) {
        this.pdfResource = pdfResource;
    }
}

