/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.kinggrid.exception.KGErrorSm2VerifyException;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.pdf.executes.signature.VerifyHelperUtils;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Date;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;

public class VerifyCertUtils {
    public static void verifySignCert(SealGM sealInfo, Certificate[] chain) throws CertificateEncodingException, IOException {
        if (!VerifyCertUtils.verifySignCertIndate(chain)) {
            throw new KGErrorSm2VerifyException("\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u7b7e\u7ae0\u4eba\u8bc1\u4e66\u6709\u6548\u671f\u8303\u56f4\u5185\uff01");
        }
        if (!VerifyCertUtils.verifySignCertWithSealCertList(sealInfo, chain)) {
            throw new KGErrorSm2VerifyException("\u7b7e\u7ae0\u4eba\u8bc1\u4e66\u4e0d\u5728\u7b7e\u7ae0\u4eba\u8bc1\u4e66\u5217\u8868\u4e2d\uff01");
        }
    }

    public static boolean verifySignCertIndate(Certificate[] chain) throws CertificateEncodingException, IOException {
        TBSCertificateStructure tbsCert = VerifyHelperUtils.getTbsCert(chain[0].getEncoded());
        return VerifyHelperUtils.verifyDate(tbsCert, new Date());
    }

    private static boolean verifySignCertWithSealCertList(SealGM sealInfo, Certificate[] chain) throws CertificateEncodingException {
        DLSequence certList = sealInfo.getCertList();
        int num = certList.size();
        DEROctetString cert = null;
        boolean flag = false;
        int i = 0;
        while (i < num) {
            cert = (DEROctetString)certList.getObjectAt(i);
            flag = Arrays.equals(chain[0].getEncoded(), cert.getOctets());
            if (flag) break;
            ++i;
        }
        return flag;
    }
}

