/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.signinter;

import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.pdf.executes.customize.DisposeSigndataToClient;
import com.kinggrid.pdf.signinter.DigitalSignatureCertBytes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Map;

public class DigitalSignatureByServerSM2
implements DigitalSignatureCertBytes {
    private static final String DEFAULT_ENCRYPTIONALGORITHM = "SM2";
    private String url;
    private String keySN;
    private String encryptionAlgorithm = "SM2";
    private boolean clientVerify = false;
    private byte[] cert;

    public DigitalSignatureByServerSM2(String url, String keySN) {
        this.url = url;
        this.keySN = keySN;
    }

    @Override
    public X509Certificate[] getCertificate() {
        return null;
    }

    @Override
    public String getHashAlgorithm() {
        return null;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return null;
    }

    @Override
    public byte[] sign(byte[] message) throws GeneralSecurityException {
        KGHttpUtils httpUtils = new KGHttpUtils();
        Map<String, Object> map = httpUtils.sign(this.url, this.keySN, message, this.encryptionAlgorithm);
        this.cert = (byte[])map.get("certBytes");
        KGBase64 base64 = new KGBase64();
        if (!this.clientVerify) {
            return base64.encode((byte[])map.get("signData")).getBytes();
        }
        byte[] ret_data = null;
        try {
            ret_data = DisposeSigndataToClient.spellSignadata(base64.encode((byte[])map.get("certBytes")), (byte[])map.get("signData"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ret_data;
    }

    @Override
    public byte[] getCert() {
        return this.cert;
    }

    public boolean isClientVerify() {
        return this.clientVerify;
    }

    public void setClientVerify(boolean clientVerify) {
        this.clientVerify = clientVerify;
    }
}

