/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.exporter;

import com.KGitextpdf.text.BadElementException;
import com.KGitextpdf.text.Document;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.pdf.PdfPageEventHelper;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.encrypt.KGBase64;
import java.io.File;
import java.io.IOException;

public class PageBackgroundImage
extends PdfPageEventHelper {
    private String imagePath;

    public PageBackgroundImage() {
    }

    public PageBackgroundImage(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    @Override
    public void onStartPage(PdfWriter pdfWriter, Document document) {
        try {
            Image image = null;
            if (this.imagePath.startsWith("data:")) {
                KGBase64 base64 = new KGBase64();
                image = Image.getInstance(base64.decode(this.imagePath.substring(5)));
            } else {
                File file = new File(this.imagePath);
                if (file.exists()) {
                    image = Image.getInstance(this.imagePath);
                }
            }
            if (image == null) {
                throw new RuntimeException("\u56fe\u7247\u8def\u5f84\u6216\u8005\u6570\u636e\u6709\u95ee\u9898\uff1aimagePath=" + this.imagePath);
            }
            image.setAlignment(8);
            image.setAbsolutePosition(0.0f, 0.0f);
            image.scaleAbsolute(document.getPageSize());
            document.add(image);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.onStartPage(pdfWriter, document);
    }
}

