/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.exporter;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.Chunk;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Font;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Paragraph;
import com.KGitextpdf.text.pdf.PdfPCell;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.exporter.KGChunk;
import com.kinggrid.pdf.exporter.KGElement;
import com.kinggrid.pdf.exporter.KGPdfExporter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public class KGPdfPCell
extends KGElement {
    private String version = "1.0";
    private String fontName;
    private float fontSize = 13.0f;
    private String fontWeight;
    private String fontColor;
    private float lineHeight = 20.0f;
    private float height = -1.0f;
    private int colspan = 1;
    private int rowspan = 1;
    private String align;
    private String valign = "top";
    private float paddingTop = 2.0f;
    private float borderWidth = 0.0f;
    private float borderWidthLeft = -1.0f;
    private float borderWidthRight = -1.0f;
    private float borderWidthTop = -1.0f;
    private float borderWidthBottom = -1.0f;
    private String borderColorLeft;
    private String borderColorRight;
    private String borderColorTop;
    private String borderColorBottom;
    private String backgroundColor;
    private String lineDash;
    private String imagePath;
    private int imgWidth = -1;
    private int imgHeight = -1;
    private int offsetX = 0;
    private int offsetY = 0;
    private String text;
    private List chunks;
    private List paragraphs;
    private KGPdfExporter pdfExporter;

    public KGPdfPCell(KGPdfExporter pdfExporter, String version) {
        this.version = version;
        this.pdfExporter = pdfExporter;
        if ("4.0".equals(this.version)) {
            this.borderWidth = 0.5f;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PdfPCell build() throws DocumentException, IOException, org.dom4j.DocumentException {
        String[] dashs;
        PdfPCell cell = null;
        this.setGlobalFontName(this.pdfExporter.getFontName());
        Font font = this.getFont(this.fontName, this.fontSize, this.fontColor, this.fontWeight);
        boolean total = false;
        if (this.text != null) {
            if ("#totalPage#".equals(this.text.trim())) {
                total = true;
                PdfTemplate totalPage = this.pdfExporter.getTotalPage();
                if (totalPage == null) {
                    totalPage = this.pdfExporter.getPdfWriter().getDirectContent().createTemplate(36.0f, font.getSize());
                }
                this.pdfExporter.setTotalPage(totalPage);
                this.pdfExporter.getHeaderFooter().setTotalPage(totalPage);
                this.pdfExporter.getHeaderFooter().setFont(font);
                cell = new PdfPCell(Image.getInstance(this.pdfExporter.getTotalPage()));
            } else {
                this.text = this.text.replaceAll("#currPage#", String.valueOf(this.pdfExporter.getPdfWriter().getCurrentPageNumber()));
            }
        }
        if (cell == null) {
            if (this.chunks != null && this.chunks.size() > 0) {
                Paragraph paragraph = new Paragraph();
                int i = 0;
                while (i < this.chunks.size()) {
                    Element element = (Element)this.chunks.get(i);
                    KGChunk kgChunk = new KGChunk(this.pdfExporter);
                    kgChunk.setText(element.getText());
                    KGPdfExporter.setterObj(kgChunk, element);
                    Chunk chunk = kgChunk.build2();
                    chunk.setLineHeight(this.lineHeight);
                    paragraph.add(chunk);
                    ++i;
                }
                cell = new PdfPCell(paragraph);
            } else if (this.paragraphs != null && this.paragraphs.size() > 0) {
                cell = new PdfPCell();
                int i = 0;
                while (i < this.paragraphs.size()) {
                    Element element = (Element)this.paragraphs.get(i);
                    Paragraph paragraph = new Paragraph();
                    KGPdfExporter.setterObj(paragraph, element);
                    String align = element.attributeValue("align");
                    if ("center".equalsIgnoreCase(align)) {
                        paragraph.setAlignment(1);
                    } else if ("right".equals(align)) {
                        paragraph.setAlignment(2);
                    } else {
                        paragraph.setAlignment(0);
                    }
                    String lineHeight = element.attributeValue("lineHeight");
                    List list = element.selectNodes("chunk");
                    int j = 0;
                    while (j < list.size()) {
                        Element chunk = (Element)list.get(j);
                        KGChunk kgChunk = new KGChunk(this.pdfExporter);
                        kgChunk.setText(chunk.getText());
                        KGPdfExporter.setterObj(kgChunk, chunk);
                        Chunk chunkElment = kgChunk.build2();
                        if (this.isNotBlank(lineHeight)) {
                            chunkElment.setLineHeight(Float.parseFloat(lineHeight));
                        }
                        paragraph.add(chunkElment);
                        ++j;
                    }
                    cell.addElement(paragraph);
                    ++i;
                }
            } else if (this.imagePath != null) {
                Image image = null;
                if (this.imagePath.startsWith("data:")) {
                    KGBase64 base64 = new KGBase64();
                    image = Image.getInstance(base64.decode(this.imagePath.substring(5)));
                } else {
                    File file = new File(this.imagePath);
                    if (file.exists()) {
                        image = Image.getInstance(this.imagePath);
                    }
                }
                if (image == null) throw new RuntimeException("\u56fe\u7247\u8def\u5f84\u9519\u8bef\uff1a" + this.imagePath);
                if (this.imgWidth != -1 && this.imgHeight != -1) {
                    image.scaleToFit(this.imgWidth, this.imgHeight);
                }
                Paragraph paragraph = new Paragraph();
                cell = new PdfPCell();
                Chunk chunk = new Chunk(image, (float)this.offsetX, this.offsetY);
                paragraph.add(chunk);
                chunk = new Chunk(this.formatText(this.text), font);
                chunk.setLineHeight(this.lineHeight);
                paragraph.add(chunk);
                cell.addElement(paragraph);
                cell.setFixedHeight(image.getScaledHeight());
                this.valign = "bottom";
            } else {
                if (this.text == null || this.text.length() == 0) {
                    this.text = "\\n";
                }
                Chunk chunk = new Chunk(this.formatText(this.text), font);
                chunk.setLineHeight(this.lineHeight);
                Paragraph paragraph = new Paragraph();
                paragraph.add(chunk);
                cell = new PdfPCell(paragraph);
            }
        }
        cell.setColspan(this.colspan);
        cell.setRowspan(this.rowspan);
        if ("center".equalsIgnoreCase(this.align)) {
            cell.setHorizontalAlignment(1);
        } else if ("right".equals(this.align)) {
            cell.setHorizontalAlignment(2);
        } else {
            cell.setHorizontalAlignment(0);
        }
        if ("top".equalsIgnoreCase(this.valign)) {
            cell.setVerticalAlignment(4);
        } else if ("bottom".equals(this.valign)) {
            cell.setVerticalAlignment(6);
        } else {
            cell.setVerticalAlignment(5);
        }
        if (!total) {
            cell.setPaddingBottom(5.0f);
        }
        if (this.height != -1.0f) {
            cell.setMinimumHeight(this.height);
        }
        cell.setUseBorderPadding(true);
        cell.setPaddingTop(this.paddingTop);
        cell.setBorderWidthLeft(this.borderWidthLeft == -1.0f ? this.borderWidth : this.borderWidthLeft);
        cell.setBorderWidthRight(this.borderWidthRight == -1.0f ? this.borderWidth : this.borderWidthRight);
        cell.setBorderWidthTop(this.borderWidthTop == -1.0f ? this.borderWidth : this.borderWidthTop);
        cell.setBorderWidthBottom(this.borderWidthBottom == -1.0f ? this.borderWidth : this.borderWidthBottom);
        if (this.isNotBlank(this.borderColorLeft)) {
            cell.setBorderColorLeft(new BaseColor(Integer.parseInt(this.borderColorLeft, 16)));
        }
        if (this.isNotBlank(this.borderColorRight)) {
            cell.setBorderColorRight(new BaseColor(Integer.parseInt(this.borderColorRight, 16)));
        }
        if (this.isNotBlank(this.borderColorTop)) {
            cell.setBorderColorTop(new BaseColor(Integer.parseInt(this.borderColorTop, 16)));
        }
        if (this.isNotBlank(this.borderColorBottom)) {
            cell.setBorderColorBottom(new BaseColor(Integer.parseInt(this.borderColorBottom, 16)));
        }
        if (this.isNotBlank(this.backgroundColor)) {
            cell.setBackgroundColor(new BaseColor(Integer.parseInt(this.backgroundColor, 16)));
        }
        if (this.lineDash == null || (dashs = this.lineDash.trim().split("[\\p{Blank}]+")).length != 4) return cell;
        int lineDashs = 0;
        if ("0".equals(dashs[0])) {
            lineDashs |= 1;
        }
        if ("0".equals(dashs[1])) {
            lineDashs |= 2;
        }
        if ("0".equals(dashs[2])) {
            lineDashs |= 4;
        }
        if ("0".equals(dashs[3])) {
            lineDashs |= 8;
        }
        cell.setLineDash(lineDashs);
        return cell;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getValign() {
        return this.valign;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public float getBorderWidthLeft() {
        return this.borderWidthLeft;
    }

    public void setBorderWidthLeft(float borderWidthLeft) {
        this.borderWidthLeft = borderWidthLeft;
    }

    public float getBorderWidthRight() {
        return this.borderWidthRight;
    }

    public void setBorderWidthRight(float borderWidthRight) {
        this.borderWidthRight = borderWidthRight;
    }

    public float getBorderWidthTop() {
        return this.borderWidthTop;
    }

    public void setBorderWidthTop(float borderWidthTop) {
        this.borderWidthTop = borderWidthTop;
    }

    public float getBorderWidthBottom() {
        return this.borderWidthBottom;
    }

    public void setBorderWidthBottom(float borderWidthBottom) {
        this.borderWidthBottom = borderWidthBottom;
    }

    public String getBorderColorLeft() {
        return this.borderColorLeft;
    }

    public void setBorderColorLeft(String borderColorLeft) {
        this.borderColorLeft = borderColorLeft;
    }

    public String getBorderColorRight() {
        return this.borderColorRight;
    }

    public void setBorderColorRight(String borderColorRight) {
        this.borderColorRight = borderColorRight;
    }

    public String getBorderColorTop() {
        return this.borderColorTop;
    }

    public void setBorderColorTop(String borderColorTop) {
        this.borderColorTop = borderColorTop;
    }

    public String getBorderColorBottom() {
        return this.borderColorBottom;
    }

    public void setBorderColorBottom(String borderColorBottom) {
        this.borderColorBottom = borderColorBottom;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public int getImgWidth() {
        return this.imgWidth;
    }

    public void setImgWidth(int imgWidth) {
        this.imgWidth = imgWidth;
    }

    public int getImgHeight() {
        return this.imgHeight;
    }

    public void setImgHeight(int imgHeight) {
        this.imgHeight = imgHeight;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }

    public List getChunks() {
        return this.chunks;
    }

    public void setChunks(List chunks) {
        this.chunks = chunks;
    }

    public String getLineDash() {
        return this.lineDash;
    }

    public void setLineDash(String lineDash) {
        this.lineDash = lineDash;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public List getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(List paragraphs) {
        this.paragraphs = paragraphs;
    }
}

