/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature.sm2;

import com.kinggrid.pdf.executes.signature.sm2.SM3Digest;
import com.kinggrid.pdf.executes.signature.sm2.Util;
import java.math.BigInteger;

class SM3 {
    public static final byte[] iv = new BigInteger("7380166f4914b2b9172442d7da8a0600a96f30bc163138aae38dee4db0fb0e4e", 16).toByteArray();
    public static int[] Tj = new int[64];

    static {
        int i = 0;
        while (i < 16) {
            SM3.Tj[i] = 2043430169;
            ++i;
        }
        i = 16;
        while (i < 64) {
            SM3.Tj[i] = 2055708042;
            ++i;
        }
    }

    SM3() {
    }

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = SM3.convert(V);
        int[] b = SM3.convert(B);
        return SM3.convert(SM3.CF(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        int i = 0;
        while (i < arr.length) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = SM3.bigEndianByteToInt(tmp);
            i += 4;
        }
        return out;
    }

    private static byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        int i = 0;
        while (i < arr.length) {
            tmp = SM3.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
            ++i;
        }
        return out;
    }

    public static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = SM3.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        int j = 0;
        while (j < 64) {
            int ss1 = SM3.bitCycleLeft(a, 12) + e + SM3.bitCycleLeft(Tj[j], j);
            ss1 = SM3.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ SM3.bitCycleLeft(a, 12);
            int tt1 = SM3.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = SM3.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = SM3.bitCycleLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = SM3.bitCycleLeft(f, 19);
            f = e;
            e = SM3.P0(tt2);
            ++j;
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(byte[] B) {
        int[] W = new int[68];
        int[] W1 = new int[64];
        byte[] tmp = new byte[4];
        int i = 0;
        while (i < B.length) {
            int j = 0;
            while (j < 4) {
                tmp[j] = B[i + j];
                ++j;
            }
            W[i / 4] = SM3.bigEndianByteToInt(tmp);
            i += 4;
        }
        i = 16;
        while (i < 68) {
            W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ SM3.bitCycleLeft(W[i - 3], 15)) ^ SM3.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
            ++i;
        }
        i = 0;
        while (i < 64) {
            W1[i] = W[i] ^ W[i + 4];
            ++i;
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static int[][] expand(int[] B) {
        int[] W = new int[68];
        int[] W1 = new int[64];
        int i = 0;
        while (i < B.length) {
            W[i] = B[i];
            ++i;
        }
        i = 16;
        while (i < 68) {
            W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ SM3.bitCycleLeft(W[i - 3], 15)) ^ SM3.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
            ++i;
        }
        i = 0;
        while (i < 64) {
            W1[i] = W[i] ^ W[i + 4];
            ++i;
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static byte[] bigEndianIntToByte(int num) {
        return SM3.back(Util.IntToByte(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return Util.ByteToInt(SM3.back(bytes));
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.FF1j(X, Y, Z);
        }
        return SM3.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.GG1j(X, Y, Z);
        }
        return SM3.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private static int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private static int P0(int X) {
        int y = SM3.rotateLeft(X, 9);
        y = SM3.bitCycleLeft(X, 9);
        int z = SM3.rotateLeft(X, 17);
        z = SM3.bitCycleLeft(X, 17);
        int t = X ^ y ^ z;
        return t;
    }

    private static int P1(int X) {
        int t = X ^ SM3.bitCycleLeft(X, 15) ^ SM3.bitCycleLeft(X, 23);
        return t;
    }

    public static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = SM3.back(Util.LongToByte(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        int i = 0;
        while (i < out.length) {
            out[i] = in[out.length - i - 1];
            ++i;
        }
        return out;
    }

    public static int rotateLeft(int x, int n) {
        return x << n | x >> 32 - n;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        byte[] tmp = SM3.bigEndianIntToByte(n);
        int byteLen = (bitLen %= 32) / 8;
        int len = bitLen % 8;
        if (byteLen > 0) {
            tmp = SM3.byteCycleLeft(tmp, byteLen);
        }
        if (len > 0) {
            tmp = SM3.bitSmall8CycleLeft(tmp, len);
        }
        return SM3.bigEndianByteToInt(tmp);
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        int i = 0;
        while (i < tmp.length) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
            ++i;
        }
        return tmp;
    }

    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }

    public static void main(String[] args) {
        SM3Digest sm3 = new SM3Digest();
        byte[] x = new byte[]{-91, 121, 123, 97, 36, -41, 109, 77, -33, 9, -50, -72, 30, 127, 19, -62, -86, 52, 120, -88, 84, 116, -50, 33, 24, -109, -87, 111, 12, 68, -84, -38};
        byte[] y = new byte[]{86, -109, -80, 40, 105, -92, 109, -108, -28, -60, -128, -32, -73, -92, 73, -58, -82, 26, -49, -83, 85, 105, -119, 109, 118, -124, -84, -17, -66, 58, -6, -14};
        String s = "1111";
        byte[] sm2Za = sm3.getSM2Za(x, y, "1234567812345678".getBytes());
        sm3.update(sm2Za, 0, sm2Za.length);
        byte[] p = s.getBytes();
        sm3.update(p, 0, p.length);
        byte[] md = new byte[32];
        sm3.doFinal(md, 0);
    }
}

