/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature.sm2;

import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.executes.signature.sm2.SM3Digest;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.kg.bouncycastle.crypto.KeyGenerationParameters;
import org.kg.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.kg.bouncycastle.crypto.params.ECDomainParameters;
import org.kg.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.kg.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.kg.bouncycastle.math.ec.ECCurve;
import org.kg.bouncycastle.math.ec.ECFieldElement;
import org.kg.bouncycastle.math.ec.ECPoint;

public class SM2 {
    private static SM2 instance = null;
    public boolean sm2Test = false;
    public String[] ecc_param = sm2_test_param;
    public static BigInteger ecc_p;
    public BigInteger ecc_a;
    public BigInteger ecc_b;
    public BigInteger ecc_n;
    public BigInteger ecc_gx;
    public BigInteger ecc_gy;
    public static ECCurve ecc_curve;
    public ECPoint ecc_point_g;
    public ECDomainParameters ecc_bc_spec;
    public ECKeyPairGenerator ecc_key_pair_generator;
    public ECFieldElement ecc_gx_fieldelement;
    public ECFieldElement ecc_gy_fieldelement;
    public static String[] sm2_test_param;
    public static String[] sm2_param;
    public static SM2 sm2;
    public static BigInteger userD;
    public static ECPoint userKey;

    static {
        sm2_test_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
        sm2_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
        userD = null;
        userKey = null;
    }

    public static SM2 getInstance() {
        if (instance == null) {
            instance = new SM2(false);
        }
        return instance;
    }

    public SM2(boolean sm2Test) {
        this.sm2Test = sm2Test;
        this.ecc_param = sm2Test ? sm2_test_param : sm2_param;
        ecc_p = new BigInteger(this.ecc_param[0], 16);
        this.ecc_a = new BigInteger(this.ecc_param[1], 16);
        this.ecc_b = new BigInteger(this.ecc_param[2], 16);
        this.ecc_n = new BigInteger(this.ecc_param[3], 16);
        this.ecc_gx = new BigInteger(this.ecc_param[4], 16);
        this.ecc_gy = new BigInteger(this.ecc_param[5], 16);
        this.ecc_gx_fieldelement = new ECFieldElement.Fp(ecc_p, this.ecc_gx);
        this.ecc_gy_fieldelement = new ECFieldElement.Fp(ecc_p, this.ecc_gy);
        ecc_curve = new ECCurve.Fp(ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(ecc_curve, this.ecc_gx_fieldelement, this.ecc_gy_fieldelement);
        this.ecc_bc_spec = new ECDomainParameters(ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    public boolean Verify(byte[] msg, byte[] signData, byte[] certPK) {
        byte[] pkX = SM2.SubByte(certPK, 0, 32);
        byte[] pkY = SM2.SubByte(certPK, 32, 32);
        BigInteger biX = new BigInteger(1, pkX);
        BigInteger biY = new BigInteger(1, pkY);
        ECFieldElement.Fp x = new ECFieldElement.Fp(ecc_p, biX);
        ECFieldElement.Fp y = new ECFieldElement.Fp(ecc_p, biY);
        ECPoint.Fp userKey = new ECPoint.Fp(ecc_curve, (ECFieldElement)x, (ECFieldElement)y);
        SM3Digest sm3 = new SM3Digest();
        byte[] sm2Za = sm3.getSM2Za(pkX, pkY, "1234567812345678".getBytes());
        sm3.update(sm2Za, 0, sm2Za.length);
        byte[] p = msg;
        sm3.update(p, 0, p.length);
        SM2.printHexString(p);
        byte[] md = new byte[32];
        sm3.doFinal(md, 0);
        SM2.printHexString(md);
        byte[] btRS = signData;
        byte[] btR = SM2.SubByte(btRS, 0, btRS.length / 2);
        byte[] btS = SM2.SubByte(btRS, btR.length, btRS.length - btR.length);
        BigInteger r = new BigInteger(1, btR);
        BigInteger s = new BigInteger(1, btS);
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint x1y1 = this.ecc_point_g.multiply(s);
        x1y1 = x1y1.add(userKey.multiply(t));
        BigInteger R = e.add(x1y1.getX().toBigInteger()).mod(this.ecc_n);
        return r.equals(R);
    }

    public boolean Verify(byte[] md, ECPoint userKey, BigInteger r, BigInteger s) {
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint x1y1 = this.ecc_point_g.multiply(s);
        x1y1 = x1y1.add(userKey.multiply(t));
        BigInteger R = e.add(x1y1.getX().toBigInteger()).mod(this.ecc_n);
        return r.equals(R);
    }

    public boolean Verify(byte[] msg, String signData) {
        KGBase64 b64 = new KGBase64();
        String[] strArray = new String(b64.decode(signData)).split("\\|");
        if (strArray.length >= 2) {
            byte[] bData = b64.decode(strArray[0]);
            byte[] bPK = b64.decode(strArray[1]);
            byte[] btR = SM2.SubByte(bData, 0, bData.length / 2);
            byte[] btS = SM2.SubByte(bData, btR.length, bData.length - btR.length);
            BigInteger r = new BigInteger(1, btR);
            BigInteger s = new BigInteger(1, btS);
            ECPoint userKey = ecc_curve.decodePoint(bPK);
            SM3Digest sm3 = new SM3Digest();
            byte[] z = this.sm2GetZ("1234567812345678".getBytes(), userKey);
            sm3.update(z, 0, z.length);
            sm3.update(msg, 0, msg.length);
            byte[] md = new byte[32];
            sm3.doFinal(md, 0);
            return this.Verify(md, userKey, r, s);
        }
        return false;
    }

    public byte[] sign(AsymmetricCipherKeyPair keyPair, byte[] sourceData) {
        SM3Digest sm3 = new SM3Digest();
        byte[] strByte = null;
        try {
            BigInteger k = null;
            ECPoint kp = null;
            BigInteger r = null;
            BigInteger s = null;
            while (true) {
                ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keyPair.getPrivate();
                ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keyPair.getPublic();
                k = ecpriv.getD();
                kp = ecpub.getQ();
                ECPoint userKey = this.ecc_point_g.multiply(k);
                byte[] z = this.sm2GetZ("1234567812345678".getBytes(), userKey);
                sm3.update(z, 0, z.length);
                sm3.update(sourceData, 0, sourceData.length);
                byte[] md = new byte[32];
                sm3.doFinal(md, 0);
                BigInteger e = new BigInteger(1, md);
                r = e.add(kp.getX().toBigInteger());
                if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
                BigInteger da_1 = k.add(BigInteger.ONE);
                da_1 = da_1.modInverse(this.ecc_n);
                s = r.multiply(k);
                s = k.subtract(s).mod(this.ecc_n);
                if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
            }
            byte[] rby = this.dealTo32(r.toByteArray());
            byte[] sby = this.dealTo32(s.toByteArray());
            strByte = new byte[rby.length + sby.length];
            System.arraycopy(rby, 0, strByte, 0, rby.length);
            System.arraycopy(sby, 0, strByte, sby.length, sby.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strByte;
    }

    private byte[] dealTo32(byte[] b) {
        byte[] by = new byte[32];
        if (b.length == 33) {
            System.arraycopy(b, 1, by, 0, 32);
        } else if (b.length == 33) {
            System.arraycopy(b, 2, by, 0, 32);
        } else {
            by = b;
        }
        return by;
    }

    public String Sign(byte[] msg) {
        String strRet = "";
        if (msg == null) {
            return strRet;
        }
        SM3Digest sm3 = new SM3Digest();
        try {
            BigInteger k = null;
            ECPoint kp = null;
            BigInteger r = null;
            BigInteger s = null;
            while (true) {
                AsymmetricCipherKeyPair keypair = this.ecc_key_pair_generator.generateKeyPair();
                ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
                ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
                k = ecpriv.getD();
                kp = ecpub.getQ();
                ECPoint userKey = this.ecc_point_g.multiply(k);
                byte[] z = this.sm2GetZ("1234567812345678".getBytes(), userKey);
                sm3.update(z, 0, z.length);
                sm3.update(msg, 0, msg.length);
                byte[] md = new byte[32];
                sm3.doFinal(md, 0);
                BigInteger e = new BigInteger(1, md);
                r = e.add(kp.getX().toBigInteger());
                if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
                BigInteger da_1 = k.add(BigInteger.ONE);
                da_1 = da_1.modInverse(this.ecc_n);
                s = r.multiply(k);
                s = k.subtract(s).mod(this.ecc_n);
                if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
            }
            byte[] strByte = new byte[r.toByteArray().length + s.toByteArray().length];
            System.arraycopy(r.toByteArray(), 0, strByte, 0, r.toByteArray().length);
            System.arraycopy(s.toByteArray(), 0, strByte, r.toByteArray().length, s.toByteArray().length);
            String strTmp = new KGBase64().encode(strByte);
            strTmp = String.valueOf(strTmp) + "|";
            strTmp = String.valueOf(strTmp) + new KGBase64().encode(kp.getEncoded());
            strRet = new KGBase64().encode(strTmp.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strRet;
    }

    public static byte[] SubByte(byte[] input, int startIndex, int length) {
        byte[] bt = new byte[length];
        int i = 0;
        while (i < length) {
            bt[i] = input[i + startIndex];
            ++i;
        }
        return bt;
    }

    public static String printHexString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        SM3Digest sm3 = new SM3Digest();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = SM2.byteConvert32Bytes(this.ecc_a);
        sm3.update(p, 0, p.length);
        p = SM2.byteConvert32Bytes(this.ecc_b);
        sm3.update(p, 0, p.length);
        p = SM2.byteConvert32Bytes(this.ecc_gx);
        sm3.update(p, 0, p.length);
        p = SM2.byteConvert32Bytes(this.ecc_gy);
        sm3.update(p, 0, p.length);
        p = SM2.byteConvert32Bytes(userKey.getX().toBigInteger());
        sm3.update(p, 0, p.length);
        p = SM2.byteConvert32Bytes(userKey.getY().toBigInteger());
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            int i = 0;
            while (i < 32 - n.toByteArray().length) {
                tmpd[i] = 0;
                ++i;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }
}

