/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature.sm2;

import com.kinggrid.pdf.executes.signature.sm2.SesSignatureStructure;
import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;

public class GMSesSignature {
    public static DERSequence getGMSesSignature(ASN1Sequence toSign, byte[] signature) throws IOException {
        ASN1EncodableVector ses_signature = new ASN1EncodableVector();
        ses_signature.add((ASN1Encodable)toSign);
        ses_signature.add((ASN1Encodable)new DERBitString(signature));
        return new DERSequence(ses_signature);
    }

    public static DERSequence getGMToSignData(byte[] eseal, String date, byte[] dataHash, String propertyInfo, byte[] cert) throws IOException {
        ASN1EncodableVector toSign = new ASN1EncodableVector();
        toSign.add((ASN1Encodable)new ASN1Integer(2L));
        ASN1InputStream inputStream = new ASN1InputStream(eseal);
        toSign.add((ASN1Encodable)inputStream.readObject());
        inputStream.close();
        toSign.add((ASN1Encodable)new DERBitString(date.getBytes()));
        toSign.add((ASN1Encodable)new DERBitString(dataHash));
        toSign.add((ASN1Encodable)new DERIA5String(propertyInfo));
        toSign.add((ASN1Encodable)new DEROctetString(cert));
        toSign.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.156.10197.1.501"));
        return new DERSequence(toSign);
    }

    public static SesSignatureStructure getSignatureInfo(byte[] sesSignature) throws IOException {
        ASN1Sequence sequence = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])sesSignature);
        ASN1Sequence toSignSeq = (ASN1Sequence)sequence.getObjectAt(0);
        DERBitString signature = (DERBitString)sequence.getObjectAt(1);
        DERInteger version = (DERInteger)toSignSeq.getObjectAt(0);
        byte[] eseal = ((ASN1Sequence)toSignSeq.getObjectAt(1)).getEncoded();
        DERBitString timeInfo = (DERBitString)toSignSeq.getObjectAt(2);
        DERBitString dataHash = (DERBitString)toSignSeq.getObjectAt(3);
        DERIA5String propertyInfo = (DERIA5String)toSignSeq.getObjectAt(4);
        DEROctetString cert = (DEROctetString)toSignSeq.getObjectAt(5);
        DERObjectIdentifier signatureAlgorithm = (DERObjectIdentifier)toSignSeq.getObjectAt(6);
        SesSignatureStructure signatureInfo = new SesSignatureStructure();
        signatureInfo.setToSign(toSignSeq.getEncoded());
        signatureInfo.setSignature(signature.getBytes());
        signatureInfo.setVersion(version.getValue().intValue());
        signatureInfo.setEseal(eseal);
        signatureInfo.setTimeInfo(new String(timeInfo.getBytes()));
        signatureInfo.setDataHash(dataHash.getBytes());
        signatureInfo.setPropertyInfo(propertyInfo.getString());
        signatureInfo.setCert(cert.getOctets());
        signatureInfo.setSignatureAlgorithm(signatureAlgorithm.getId());
        return signatureInfo;
    }
}

