/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature;

import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.exception.KGErrorSm2VerifyException;
import com.kinggrid.kgcore.gm.SM2;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.pdf.executes.signature.VerifyHelperUtils;
import com.kinggrid.pdf.utils.Asn1Utils;
import java.io.IOException;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;

public class VerifyGMSeal {
    private SealGM sealInfo;
    private Date signDate;

    public VerifyGMSeal(SealGM sealInfo, Date signDate) {
        this.sealInfo = sealInfo;
        this.signDate = signDate;
    }

    public void verify() throws IOException {
        if ("1.2.156.10197.1.501".equals(this.sealInfo.getSignatureAlgorithm())) {
            this.verifySm2Signdata();
        }
        this.verifySealValid();
    }

    private void verifySm2Signdata() throws IOException {
        byte[] toSign = null;
        if (this.sealInfo.getVersion() == 4) {
            toSign = this.sealInfo.getSesSealInfo().getEncoded();
        } else {
            ASN1EncodableVector tosignVector = new ASN1EncodableVector();
            tosignVector.add((ASN1Encodable)this.sealInfo.getSesSealInfo());
            tosignVector.add((ASN1Encodable)new DEROctetString(this.sealInfo.getCert()));
            tosignVector.add((ASN1Encodable)new ASN1ObjectIdentifier(this.sealInfo.getSignatureAlgorithm()));
            toSign = new DERSequence(tosignVector).getEncoded();
        }
        TBSCertificateStructure tbsCert = VerifyHelperUtils.getTbsCert(this.sealInfo.getCert());
        byte[] pk = VerifyHelperUtils.getPubkey(tbsCert);
        SM2 sm2 = new SM2(true);
        byte[] signData = this.sealInfo.getSignData();
        if (signData.length != 64) {
            signData = Asn1Utils.sigDataAns1To64bit(signData);
        }
        if (!sm2.Verify(toSign, signData, pk)) {
            throw new KGErrorSm2VerifyException("\u7535\u5b50\u5370\u7ae0\u7ed3\u6784\u4f53\u6570\u5b57\u7b7e\u540d\u65e0\u6548\uff01");
        }
    }

    private void verifySealValid() {
        Date startDate = this.sealInfo.getValidStart();
        Date endDate = this.sealInfo.getValidEnd();
        if (KGDateUtils.compareDate(startDate, this.signDate) > 0 || KGDateUtils.compareDate(endDate, this.signDate) < 0) {
            throw new KGErrorSm2VerifyException("\u5f53\u524d\u7b7e\u7ae0\u65f6\u95f4\u4e0d\u5728\u7535\u5b50\u5370\u7ae0\u7684\u6709\u6548\u671f\u8303\u56f4\u5185\uff01");
        }
    }
}

