/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature;

import com.KGitextpdf.text.pdf.PdfFormField;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.signature.KGPdfSignaureExecute;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kg.bouncycastle.util.encoders.Hex;

public class KGPdfSignatureZqya
extends KGPdfSignaureExecute {
    private String length;
    private byte[] sigStructureData;

    public static String getSM3Digest(String fileName) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            String string = KGPdfSignatureZqya.getSM3Digest(fileInputStream);
            return string;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static String getSM3Digest(InputStream in) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        JSONObject obj = new JSONObject();
        Security.addProvider((Provider)new BouncyCastleProvider());
        MessageDigest messageDigest = MessageDigest.getInstance("SM3", "KGBC");
        int len = -1;
        int length = 0;
        byte[] buff = new byte[4096];
        while ((len = in.read(buff)) != -1) {
            length += len;
            messageDigest.update(buff, 0, len);
        }
        byte[] digest = messageDigest.digest();
        obj.put("digest", (Object)new String(Hex.encode((byte[])digest)));
        obj.put("length", (Object)length);
        return obj.toJSONString();
    }

    public static String getSM3Digest(String fileName, int length) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        String string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            string = KGPdfSignatureZqya.getSM3Digest(fileInputStream, length);
        }
        catch (Throwable throwable) {
            KGPdfSignatureZqya.close(fileInputStream);
            throw throwable;
        }
        KGPdfSignatureZqya.close(fileInputStream);
        return string;
    }

    public static String getSM3Digest(InputStream in, int length) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        byte[] digest = null;
        ByteArrayOutputStream baos = null;
        ByteArrayOutputStream bos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            int len = 0;
            while ((len = in.read(b, 0, b.length)) != -1) {
                baos.write(b, 0, len);
            }
            byte[] totalbytes = baos.toByteArray();
            byte[] srcdocbytes = new byte[length];
            System.arraycopy(totalbytes, 0, srcdocbytes, 0, length);
            bos = new ByteArrayOutputStream();
            bos.write(srcdocbytes);
            Security.addProvider((Provider)new BouncyCastleProvider());
            MessageDigest messageDigest = MessageDigest.getInstance("SM3", "KGBC");
            messageDigest.update(srcdocbytes);
            digest = messageDigest.digest();
        }
        catch (Throwable throwable) {
            KGPdfSignatureZqya.close(bos);
            KGPdfSignatureZqya.close(baos);
            KGPdfSignatureZqya.close(in);
            throw throwable;
        }
        KGPdfSignatureZqya.close(bos);
        KGPdfSignatureZqya.close(baos);
        KGPdfSignatureZqya.close(in);
        return new String(Hex.encode((byte[])digest));
    }

    @Override
    public void execute(PdfStamper pdfStamper, PdfFormField sigField, int pagen) {
        PdfWriter pdfWriter = pdfStamper.getWriter();
        PdfStream sigStructure = new PdfStream(this.sigStructureData);
        try {
            PdfIndirectObject sigInfoIndObj = pdfWriter.addToBody(sigStructure);
            sigField.put(KGElectronicSealName.SIGSTRUCTURE, sigInfoIndObj.getIndirectReference());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public byte[] getSigStructureData() {
        return this.sigStructureData;
    }

    public void setSigStructureData(byte[] sigStructureData) {
        this.sigStructureData = sigStructureData;
    }

    public static void close(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

