/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.postil;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.authorization.AuthorizationType;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.img.CutImage;
import com.kinggrid.kgcore.KGElectronicSeal;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.pdf.executes.PdfElectronicSeal;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicSig;
import com.kinggrid.pdf.signinter.DigitalSignatureByServer;
import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

@AuthorizationType(hasAuth=true)
public class PrepareToOfficialStamp
extends PdfElectronicSeal {
    private String url;
    private int sigType = 0;
    private String pwd;
    private InputStream pfxStream;
    private Map<Integer, List<PdfDictionary>> map;
    private KGPdfElectronicSig electronicSig;
    private String stampParam;
    private int nextPage = 1;
    private int step = 1;
    private int increment = 1;
    private int startX = 0;
    private Map<Integer, Integer> orginalMap = null;
    private Map<Integer, Integer> rectMap = null;
    private Rectangle rect;
    private String imgFormat = "GIF";
    private int number;
    private String model;
    private int yDistanceOrigin;
    private int qfzWidth;
    private int qfzHeight;
    private int startPage = 1;
    private int endPage = 0;
    private Image image;
    private double qfzPercent = 0.5;

    public PrepareToOfficialStamp(String url) {
        this.url = url;
    }

    public String getStampParam() {
        return this.stampParam;
    }

    public void setStampParam(String stampParam) {
        this.stampParam = stampParam;
    }

    public void setSigType(int sigType) {
        this.sigType = sigType;
    }

    public void setCertMsg(InputStream stream, String pwd) {
        this.sigType = 2;
        this.pfxStream = stream;
        this.pwd = pwd;
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        int num = pdfReader.getNumberOfPages();
        this.map = new HashMap<Integer, List<PdfDictionary>>();
        int j = 0;
        while (j < num) {
            ArrayList<PdfDictionary> list = new ArrayList<PdfDictionary>();
            PdfDictionary page = pdfReader.getPageN(j + 1);
            PdfArray annots = page.getAsArray(PdfName.ANNOTS);
            if (annots != null) {
                int i = annots.size() - 1;
                while (i >= 0) {
                    PdfName subType;
                    PdfDictionary annot = annots.getAsDict(i);
                    if (annot != null && (subType = annot.getAsName(PdfName.SUBTYPE)) != null && subType.equals(new PdfName("prepareStamp"))) {
                        PdfString pdfString = annot.getAsString(new PdfName("AnnotExtParam"));
                        if (pdfString != null) {
                            KGBase64 base64 = new KGBase64();
                            String decodeExtParam = new String(base64.decode(pdfString.toString()), "UTF-8");
                            String isQfz = this.getIsQfz(decodeExtParam);
                            if (isQfz.equals("false")) {
                                list.add(annot);
                                annots.remove(i);
                            } else {
                                annots.remove(i);
                            }
                        } else {
                            annots.remove(i);
                        }
                    }
                    --i;
                }
                this.map.put(j + 1, list);
            }
            pdfStamper.markUsed(annots);
            pdfStamper.markUsed(page);
            ++j;
        }
        super.before(pdfReader, pdfStamper);
    }

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        if (this.stampParam != null && !this.stampParam.equals("NoQFZ")) {
            this.qfzSign(pdfReader, pdfStamper, pagen, this.stampParam);
            return;
        }
        List<PdfDictionary> annots = this.map.get(pagen);
        if (annots == null) {
            return;
        }
        int i = 0;
        while (i < annots.size()) {
            PdfDictionary annot = annots.get(i);
            String annotExtParam = annot.getAsString(new PdfName("AnnotExtParam")).toString();
            KGBase64 base64 = new KGBase64();
            String decodeExtParam = new String(base64.decode(annotExtParam), "UTF-8");
            String keySN = this.getKeysn(decodeExtParam);
            String sealName = this.getSealName(decodeExtParam);
            PdfArray pdfArray = annot.getAsArray(PdfName.RECT);
            Rectangle rect = new Rectangle(pdfArray.getAsNumber(0).floatValue(), pdfArray.getAsNumber(1).floatValue(), pdfArray.getAsNumber(2).floatValue(), pdfArray.getAsNumber(3).floatValue());
            SealInformation sealInformation = new KGElectronicSeal(this.url, KGServerTypeEnum.AUTO, keySN, null, sealName).getSeal();
            String imgExt = sealInformation.getImgFileExt().substring(1);
            this.setSealMsg(sealInformation.getKeySN(), sealInformation.getImgUnitName(), sealInformation.getImgUserName(), sealInformation.getSignSN(), sealInformation.getImgSignName());
            this.setImage(sealInformation.getImgValue(), imgExt, (int)rect.getWidth(), (int)rect.getHeight());
            this.setRect(rect);
            this.setQfzData(false);
            if (this.sigType == 1) {
                KGPdfElectronicSig electronicSig = new KGPdfElectronicSig();
                DigitalSignatureByServer digitalSignatureByServer = new DigitalSignatureByServer(this.url, keySN);
                electronicSig.setCertMsg(digitalSignatureByServer);
                this.addExtraExecute(electronicSig);
            } else if (this.sigType == 2) {
                if (this.electronicSig == null) {
                    this.electronicSig = new KGPdfElectronicSig();
                }
                this.electronicSig.setCertMsg(this.pfxStream, this.pwd);
                this.addExtraExecute(this.electronicSig);
            }
            super.execute(pdfReader, pdfStamper, pagen);
            ++i;
        }
    }

    @Override
    public void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.after(pdfReader, pdfStamper);
    }

    private String getIsQfz(String extParam) {
        String[] split = extParam.split(";");
        return split[0].split(":")[1];
    }

    private String getSealName(String extParam) {
        String[] split = extParam.split(";");
        return split[1].split(":")[1];
    }

    private String getKeysn(String extParam) {
        String[] split = extParam.split(";");
        return split[2].split(":")[1];
    }

    private String getStartPage(String extParam) {
        String[] split = extParam.split(";");
        return split[3].split(":")[1];
    }

    private String getEndPage(String extParam) {
        String[] split = extParam.split(";");
        return split[4].split(":")[1];
    }

    private String getModel(String extParam) {
        String[] split = extParam.split(";");
        return split[5].split(":")[1];
    }

    private String getNumber(String extParam) {
        String[] split = extParam.split(";");
        return split[6].split(":")[1];
    }

    private String getYDistanceOrigin(String extParam) {
        String[] split = extParam.split(";");
        return split[7].split(":")[1];
    }

    private String getQfzPrecent(String extParam) {
        String[] split = extParam.split(";");
        return split[8].split(":")[1];
    }

    private String getWidth(String extParam) {
        String[] split = extParam.split(";");
        return split[9].split(":")[1];
    }

    private String getHeight(String extParam) {
        String[] split = extParam.split(";");
        return split[10].split(":")[1];
    }

    public void qfzSign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, String decodeExtParam) throws IOException, DocumentException {
        String keySN = this.getKeysn(decodeExtParam);
        String sealName = this.getSealName(decodeExtParam);
        this.startPage = Integer.valueOf(this.getStartPage(decodeExtParam));
        this.endPage = Integer.valueOf(this.getEndPage(decodeExtParam));
        this.model = this.getModel(decodeExtParam);
        this.qfzPercent = Double.valueOf(this.getQfzPrecent(decodeExtParam));
        this.yDistanceOrigin = Integer.valueOf(this.getYDistanceOrigin(decodeExtParam));
        this.number = Integer.valueOf(this.getNumber(decodeExtParam));
        this.qfzWidth = Double.valueOf(this.getWidth(decodeExtParam)).intValue();
        this.qfzHeight = Double.valueOf(this.getHeight(decodeExtParam)).intValue();
        SealInformation sealInformation = new KGElectronicSeal(this.url, KGServerTypeEnum.AUTO, keySN, null, sealName).getSeal();
        this.setSealMsg(sealInformation.getKeySN(), sealInformation.getImgUnitName(), sealInformation.getImgUserName(), sealInformation.getSignSN(), sealInformation.getImgSignName());
        this.image = Image.getInstance(sealInformation.getImgValue());
        this.imgFormat = this.getImageType(sealInformation.getImgValue());
        int pageNumber = 0;
        if (pagen == 1) {
            this.nextPage = this.startPage;
        }
        if (this.qfzPercent < 0.04 || this.qfzPercent > 0.97) {
            throw new IllegalArgumentException("\u8bf7\u8c03\u6574\u8bbe\u7f6e\u7684\u5370\u7ae0\u9996\u9875\u5360\u6bd4\u8303\u56f4\u57280.04\u52300.97\u4e4b\u95f4\uff01");
        }
        if (this.endPage > pdfReader.getNumberOfPages()) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u622a\u6b62\u9875\u8d85\u51fa\u6587\u6863\u7684\u603b\u9875\u6570\uff0c\u6587\u6863\u7684\u603b\u9875\u6570\u4e3a\uff1a" + pdfReader.getNumberOfPages());
        }
        pageNumber = this.endPage != 0 ? this.endPage - this.startPage + 1 : pdfReader.getNumberOfPages() - this.startPage + 1;
        if (pageNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u4e24\u9875\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pageNumber);
        }
        if (this.orginalMap == null) {
            if (!this.model.equals("allPage")) {
                this.step = 2;
                if (this.model.equals("oddPage")) {
                    int numb = pageNumber % 2;
                    pageNumber = numb == 1 ? pageNumber / 2 + 1 : pageNumber / 2;
                } else {
                    pageNumber /= 2;
                    ++this.nextPage;
                }
            }
            int originalWidth = (int)this.image.getWidth();
            if (this.qfzPercent != 0.5) {
                this.orginalMap = this.getPerPagePercentF(pageNumber, originalWidth, this.number, this.qfzPercent);
                this.rectMap = this.getPerPagePercentF(pageNumber, this.qfzWidth, this.number, this.qfzPercent);
            } else {
                this.orginalMap = this.getPerPagePercent(pageNumber, originalWidth, this.number);
                this.rectMap = this.getPerPagePercent(pageNumber, this.qfzWidth, this.number);
            }
        }
        int rotation = pdfReader.getPageRotation(pagen);
        if (pagen == this.nextPage) {
            if (this.endPage != 0 && pagen > this.endPage) {
                return;
            }
            int cutImgWidth = this.orginalMap.get(this.increment);
            int rectWidth = this.rectMap.get(this.increment);
            CutImage cutImage = new CutImage(this.image.getOriginalData(), this.imgFormat);
            if ((float)(this.startX + cutImgWidth) > this.image.getWidth()) {
                this.startX = 0;
            }
            byte[] partImageData = cutImage.cut(this.startX, 0, cutImgWidth, (int)this.image.getHeight());
            Image partImage = Image.getInstance(partImageData);
            partImage.scaleToFit(rectWidth, this.qfzHeight);
            Rectangle pageRect = pdfReader.getPageSize(pagen);
            this.rect = rotation == 90 || rotation == 270 ? new Rectangle(pageRect.getHeight() - (float)rectWidth, this.yDistanceOrigin, pageRect.getHeight(), this.yDistanceOrigin + this.qfzHeight, rotation) : new Rectangle(pageRect.getWidth() - (float)rectWidth, this.yDistanceOrigin, pageRect.getWidth(), this.yDistanceOrigin + this.qfzHeight, rotation);
            this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
            if (this.sigType == 1) {
                KGPdfElectronicSig electronicSig = new KGPdfElectronicSig();
                DigitalSignatureByServer digitalSignatureByServer = new DigitalSignatureByServer(this.url, keySN);
                electronicSig.setCertMsg(digitalSignatureByServer);
                this.addExtraExecute(electronicSig);
            } else if (this.sigType == 2) {
                if (this.electronicSig == null) {
                    this.electronicSig = new KGPdfElectronicSig();
                }
                this.electronicSig.setCertMsg(this.pfxStream, this.pwd);
                this.addExtraExecute(this.electronicSig);
            }
            this.startX += cutImgWidth;
            ++this.increment;
            this.nextPage += this.step;
        }
    }

    private String getImageType(byte[] bs) throws IOException {
        String type = "";
        ByteArrayInputStream bais = null;
        MemoryCacheImageInputStream mcis = null;
        try {
            bais = new ByteArrayInputStream(bs);
            mcis = new MemoryCacheImageInputStream(bais);
            Iterator<ImageReader> itr = ImageIO.getImageReaders(mcis);
            while (itr.hasNext()) {
                ImageReader reader = itr.next();
                if (reader instanceof GIFImageReader) {
                    type = "GIF";
                    continue;
                }
                if (reader instanceof JPEGImageReader) {
                    type = "JPG";
                    continue;
                }
                if (reader instanceof PNGImageReader) {
                    type = "PNG";
                    continue;
                }
                if (!(reader instanceof BMPImageReader)) continue;
                type = "BMP";
            }
        }
        finally {
            if (type.equals("")) {
                throw new IllegalArgumentException("\u56fe\u7247\u89e3\u6790\u51fa\u9519\uff0c\u4e0d\u652f\u6301\u9664GIF,JPG,PNG,BMP\u4ee5\u5916\u7684\u56fe\u7247\uff01");
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            if (mcis != null) {
                try {
                    mcis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return type;
    }
}

