/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.postil;

import com.KGitextpdf.awt.geom.AffineTransform;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.authorization.AuthorizationType;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.img.CutImage;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGExecute;
import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

@AuthorizationType(hasAuth=true)
public class AddPostil
extends KGExecute {
    private JSONObject annotsObj;
    private int nextPage = 1;
    private int step = 1;
    private int increment = 1;
    private int startX = 0;
    private Map<Integer, Integer> orginalMap = null;
    private Map<Integer, Integer> rectMap = null;
    private Rectangle rect;
    private String imgFormat = "GIF";
    private boolean isQfz = false;
    private PdfArray childList;
    private PdfAnnotation parentAnnot;
    private PdfDictionary qfzFirstPage;
    private int qfzFirstPageNumb;

    public void setAnnotsObj(JSONObject annotsObj) {
        this.annotsObj = annotsObj;
    }

    public JSONObject getAnnotsObj() {
        return this.annotsObj;
    }

    public boolean isQfz() {
        return this.isQfz;
    }

    public void setQfz(boolean isQfz) {
        this.isQfz = isQfz;
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.before(pdfReader, pdfStamper);
        String isqfz = this.getAnnotsObj().getString("isStampOfQfz");
        if (isqfz.equals("true")) {
            this.setQfz(true);
            return;
        }
    }

    @Override
    public void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.after(pdfReader, pdfStamper);
        if (this.isQfz()) {
            this.parentAnnot.put(KGElectronicSealName.CHILDLIST, this.childList);
            pdfStamper.addAnnotation(this.parentAnnot, this.qfzFirstPageNumb);
            pdfStamper.markUsed(this.qfzFirstPage);
        }
        pdfStamper.markUsed(pdfReader.getCatalog());
    }

    @Override
    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        JSONObject jObject = this.getAnnotsObj();
        if (this.isQfz()) {
            this.qfzAnnotation(pdfReader, pdfStamper, pagen, jObject);
        } else {
            this.annotation(pdfReader, pdfStamper, pagen, jObject);
        }
    }

    protected void annotation(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, JSONObject jObject) throws IOException, DocumentException {
        int page = jObject.getIntValue("page");
        if (page != pagen) {
            return;
        }
        float x = jObject.getFloatValue("x");
        float y = jObject.getFloatValue("y");
        float width = jObject.getFloatValue("width");
        float height = jObject.getFloatValue("height");
        String sealName = jObject.getString("sealName");
        String imageBase64 = jObject.getString("imgdata");
        String keysn = jObject.getString("keysn");
        String type = jObject.getString("type");
        if (type.equals("prepareStamp")) {
            int rotation = pdfReader.getPageRotation(pagen);
            PdfDictionary pageN = pdfReader.getPageN(pagen);
            if (rotation != 0) {
                pageN.put(PdfName.ROTATE, new PdfNumber(0));
            }
            PdfAnnotation pdfAnnotation = null;
            String date = KGDateUtils.dateTime(new Date()).replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "");
            date = "D:" + date + "+08'00'";
            KGBase64 base64 = new KGBase64();
            byte[] bytes = base64.decode(imageBase64);
            Image image = Image.getInstance(bytes);
            Rectangle rect = new Rectangle(x, y, x + width, y + height);
            pdfAnnotation = PdfAnnotation.createStamp(pdfStamper.getWriter(), rect, "", "");
            PdfTemplate template = PdfTemplate.createTemplate(pdfStamper.getWriter(), rect.getWidth(), rect.getHeight());
            PdfGState gstate = new PdfGState();
            gstate.setBlendMode(PdfGState.BM_MULTIPLY);
            template.setGState(gstate);
            pdfAnnotation.setAppearance(PdfName.N, template);
            pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
            pdfAnnotation.put(PdfName.SUBTYPE, new PdfName(type));
            pdfAnnotation.put(PdfName.T, new PdfString("Kinggrid"));
            pdfAnnotation.put(PdfName.CREATIONDATE, new PdfString(date));
            String annotExtParam = "isQfz:false;sealName:" + sealName + ";keysn:" + keysn;
            pdfAnnotation.put(new PdfName("AnnotExtParam"), new PdfString(base64.encode(annotExtParam.getBytes("utf-8"))));
            float scale = this.getMin(rect.getWidth() / image.getWidth(), rect.getHeight() / image.getHeight());
            x = this.getMax((rect.getWidth() - image.getWidth() * scale) / 2.0f, 0.0f);
            y = this.getMax((rect.getHeight() - image.getHeight() * scale) / 2.0f, 0.0f);
            template.addImage(image, image.getWidth() * scale, 0.0f, 0.0f, image.getHeight() * scale, x, y);
            this.rotationApp(template, rotation);
            pdfAnnotation.put(PdfName.F, new PdfNumber(4));
            pdfStamper.addAnnotation(pdfAnnotation, page);
        }
    }

    protected void qfzAnnotation(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, JSONObject jObject) throws MalformedURLException, IOException, DocumentException {
        JSONObject obj = jObject.getJSONObject("pageAttr");
        String imageBase64 = jObject.getString("imgdata");
        float width = jObject.getFloatValue("width");
        float height = jObject.getFloatValue("height");
        String type = jObject.getString("type");
        String keysn = jObject.getString("keysn");
        String sealName = jObject.getString("sealName");
        int startPage = Integer.valueOf(obj.getString("startPage"));
        int endPage = Integer.valueOf(obj.getString("endPage"));
        String model = obj.getString("model");
        int number = Integer.valueOf(obj.getString("number"));
        double bottom = obj.getDoubleValue("bottom");
        int yDistanceOrigin = (int)Math.round(bottom);
        double qfzPercent = Double.valueOf(obj.getString("precent"));
        KGBase64 base64 = new KGBase64();
        byte[] bytes = base64.decode(imageBase64);
        this.imgFormat = this.getImageType(bytes);
        Image image = Image.getInstance(bytes);
        int pageNumber = 0;
        if (qfzPercent < 0.04 || qfzPercent > 0.97) {
            throw new IllegalArgumentException("\u8bf7\u8c03\u6574\u8bbe\u7f6e\u7684\u5370\u7ae0\u9996\u9875\u5360\u6bd4\u8303\u56f4\u57280.04\u52300.97\u4e4b\u95f4\uff01");
        }
        if (endPage > pdfReader.getNumberOfPages()) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u622a\u6b62\u9875\u8d85\u51fa\u6587\u6863\u7684\u603b\u9875\u6570\uff0c\u6587\u6863\u7684\u603b\u9875\u6570\u4e3a\uff1a" + pdfReader.getNumberOfPages());
        }
        pageNumber = endPage != 0 ? endPage - startPage + 1 : pdfReader.getNumberOfPages() - startPage + 1;
        if (pageNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u4e24\u9875\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pageNumber);
        }
        int originalWidth = (int)image.getWidth();
        int originalHeight = (int)image.getHeight();
        int qfzWidth = (int)width;
        int qfzHeight = (int)height;
        if (this.orginalMap == null) {
            this.nextPage = startPage;
            if (!model.equals("allPage")) {
                this.step = 2;
                if (model.equals("oddPage")) {
                    int numb = pageNumber % 2;
                    pageNumber = numb == 1 ? pageNumber / 2 + 1 : pageNumber / 2;
                } else {
                    pageNumber /= 2;
                    ++this.nextPage;
                }
            }
            if (qfzPercent != 0.5) {
                this.orginalMap = this.getPerPagePercentF(pageNumber, originalWidth, number, qfzPercent);
                this.rectMap = this.getPerPagePercentF(pageNumber, qfzWidth, number, qfzPercent);
            } else {
                this.orginalMap = this.getPerPagePercent(pageNumber, originalWidth, number);
                this.rectMap = this.getPerPagePercent(pageNumber, qfzWidth, number);
            }
        }
        int rotation = pdfReader.getPageRotation(pagen);
        if (pagen == this.nextPage) {
            if (endPage != 0 && pagen > endPage) {
                return;
            }
            int cutImgWidth = this.orginalMap.get(this.increment);
            int rectWidth = this.rectMap.get(this.increment);
            CutImage cutImage = new CutImage(image.getOriginalData(), this.imgFormat);
            if ((float)(this.startX + cutImgWidth) > image.getWidth()) {
                this.startX = 0;
            }
            byte[] partImageData = cutImage.cut(this.startX, 0, cutImgWidth, originalHeight);
            Image partImage = Image.getInstance(partImageData);
            partImage.scaleToFit(rectWidth, qfzHeight);
            Rectangle pageRect = pdfReader.getPageSize(pagen);
            this.rect = rotation == 90 || rotation == 270 ? new Rectangle(pageRect.getHeight() - (float)rectWidth, yDistanceOrigin, pageRect.getHeight(), yDistanceOrigin + qfzHeight, rotation) : new Rectangle(pageRect.getWidth() - (float)rectWidth, yDistanceOrigin, pageRect.getWidth(), yDistanceOrigin + qfzHeight, rotation);
            PdfDictionary pageN = pdfReader.getPageN(pagen);
            PdfAnnotation pdfAnnotation = null;
            String date = KGDateUtils.dateTime(new Date()).replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "");
            date = "D:" + date + "+08'00'";
            pdfAnnotation = PdfAnnotation.createStamp(pdfStamper.getWriter(), this.rect, "", "");
            PdfTemplate template = PdfTemplate.createTemplate(pdfStamper.getWriter(), this.rect.getWidth(), this.rect.getHeight());
            PdfGState gstate = new PdfGState();
            gstate.setBlendMode(PdfGState.BM_MULTIPLY);
            template.setGState(gstate);
            pdfAnnotation.setAppearance(PdfName.N, template);
            pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
            pdfAnnotation.put(PdfName.SUBTYPE, new PdfName(type));
            pdfAnnotation.put(PdfName.T, new PdfString("Kinggrid"));
            pdfAnnotation.put(PdfName.CREATIONDATE, new PdfString(date));
            if (this.qfzFirstPage == null) {
                String annotExtParamQfz = "isQfz:true;sealName:" + sealName + ";keysn:" + keysn + ";startPage:" + obj.getString("startPage") + ";endPage:" + obj.getString("endPage") + ";model:" + model + ";number:" + obj.getString("number") + ";bottom:" + yDistanceOrigin + ";qfzprecent:" + obj.getString("precent") + ";width:" + jObject.getFloatValue("width") + ";height:" + jObject.getFloatValue("height");
                pdfAnnotation.put(new PdfName("AnnotExtParam"), new PdfString(base64.encode(annotExtParamQfz.getBytes("utf-8"))));
            }
            template.addImage(partImage, this.rect.getWidth(), 0.0f, 0.0f, this.rect.getHeight(), 0.0f, 0.0f);
            this.rotationApp(template, rotation);
            pdfAnnotation.put(PdfName.F, new PdfNumber(4));
            if (this.qfzFirstPage == null) {
                this.qfzFirstPage = pageN;
                this.qfzFirstPageNumb = pagen;
                this.parentAnnot = pdfAnnotation;
                this.childList = new PdfArray();
            } else {
                pdfAnnotation.put(PdfName.P, this.qfzFirstPage.getIndRef());
                pdfAnnotation.put(PdfName.PARENT, this.parentAnnot.getIndirectReference());
                this.childList.add(pageN.getIndRef());
                this.childList.add(pdfAnnotation.getIndirectReference());
                pdfStamper.addAnnotation(pdfAnnotation, pageN);
            }
            this.startX += cutImgWidth;
            ++this.increment;
            this.nextPage += this.step;
        }
    }

    protected Map<Integer, Integer> getPerPagePercent(int pagesOfNumber, int image_width, int numb) {
        if (pagesOfNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u6709\u4e24\u4e2a\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pagesOfNumber);
        }
        if (numb < 2 || numb > 32) {
            throw new IllegalArgumentException("\u81f3\u5c112\u9875\u3001\u6700\u591a32\u9875\u5e73\u5747\u5206\u4e00\u4e2a\u7ae0.");
        }
        int cow = pagesOfNumber / numb;
        int mod = pagesOfNumber % numb;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(pagesOfNumber);
        int i = 1;
        int[] row_width = this.getRowWidth(image_width, numb);
        if (mod == 0) {
            i = 1;
            while (i <= pagesOfNumber) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
        } else if (mod == 1) {
            i = 1;
            while (i <= (cow - 1) * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, numb + 1);
            int k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        } else {
            i = 1;
            while (i <= cow * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, mod);
            int k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        }
        return map;
    }

    protected Map<Integer, Integer> getPerPagePercentF(int pagesOfNumber, int image_width, int numb, double qfzPercent) {
        int k;
        if (pagesOfNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u6709\u4e24\u4e2a\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pagesOfNumber);
        }
        if (numb < 2 || numb > 32) {
            throw new IllegalArgumentException("\u81f3\u5c112\u9875\u3001\u6700\u591a32\u9875\u5e73\u5747\u5206\u4e00\u4e2a\u7ae0.");
        }
        int first = (int)Math.round((double)image_width * qfzPercent);
        int second = image_width - first;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(pagesOfNumber -= 2);
        HashMap<Integer, Integer> newmap = new HashMap<Integer, Integer>(pagesOfNumber);
        int cow = pagesOfNumber / numb;
        int mod = pagesOfNumber % numb;
        int i = 1;
        int[] row_width = this.getRowWidth(image_width, numb);
        if (mod == 0) {
            i = 1;
            while (i <= pagesOfNumber) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
        } else if (mod == 1) {
            i = 1;
            while (i <= (cow - 1) * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, numb + 1);
            k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        } else {
            i = 1;
            while (i <= cow * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, mod);
            k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        }
        newmap.put(1, first);
        newmap.put(2, second);
        for (Map.Entry entry : map.entrySet()) {
            int key = (Integer)entry.getKey();
            int value = (Integer)entry.getValue();
            newmap.put(key + 2, value);
        }
        return newmap;
    }

    private int[] getRowWidth(int width, int rowNumber) {
        int per_page_width = width / rowNumber;
        int mod_width = width % rowNumber;
        int[] row_width = new int[rowNumber];
        Arrays.fill(row_width, per_page_width);
        if (mod_width != 0) {
            row_width[0] = row_width[0] + 1;
            int i = rowNumber - 1;
            int j = mod_width - 1;
            while (j > 0) {
                int n = i--;
                row_width[n] = row_width[n] + 1;
                --j;
            }
        }
        return row_width;
    }

    private float getMin(float a, float b) {
        return a < b ? a : b;
    }

    private float getMax(float a, float b) {
        return a > b ? a : b;
    }

    private String getImageType(byte[] bs) throws IOException {
        String type = "";
        ByteArrayInputStream bais = null;
        MemoryCacheImageInputStream mcis = null;
        try {
            bais = new ByteArrayInputStream(bs);
            mcis = new MemoryCacheImageInputStream(bais);
            Iterator<ImageReader> itr = ImageIO.getImageReaders(mcis);
            while (itr.hasNext()) {
                ImageReader reader = itr.next();
                if (reader instanceof GIFImageReader) {
                    type = "GIF";
                    continue;
                }
                if (reader instanceof JPEGImageReader) {
                    type = "JPG";
                    continue;
                }
                if (reader instanceof PNGImageReader) {
                    type = "PNG";
                    continue;
                }
                if (!(reader instanceof BMPImageReader)) continue;
                type = "BMP";
            }
        }
        finally {
            if (type.equals("")) {
                throw new IllegalArgumentException("\u56fe\u7247\u89e3\u6790\u51fa\u9519\uff0c\u4e0d\u652f\u6301\u9664GIF,JPG,PNG,BMP\u4ee5\u5916\u7684\u56fe\u7247\uff01");
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            if (mcis != null) {
                try {
                    mcis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return type;
    }

    protected void rotationApp(PdfTemplate app, int rotation) {
        if (rotation != 0) {
            AffineTransform transform = null;
            switch (rotation % 360) {
                case 0: {
                    break;
                }
                case 90: {
                    transform = new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
                    break;
                }
                case 180: {
                    transform = new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
                    break;
                }
                case 270: {
                    transform = new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not suport the rotation : " + rotation);
                }
            }
            if (transform != null) {
                double[] matrix = new double[6];
                transform.getMatrix(matrix);
                app.setMatrix((float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
            }
        }
    }
}

