/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.fields;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.AcroFields;
import com.KGitextpdf.text.pdf.BaseFont;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PdfFieldsFillText
extends KGExecute {
    private boolean force = true;
    private BaseFont font;
    private AcroFields acroFields;
    private String fields;
    private Map<String, String> map;

    public PdfFieldsFillText(String fields) {
        this.fields = fields;
    }

    public PdfFieldsFillText(Map<String, String> fields) {
        this.map = fields;
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.before(pdfReader, pdfStamper);
        if (this.map == null) {
            try {
                Document document = DocumentHelper.parseText((String)this.fields);
                List list = document.selectNodes("/items/item");
                this.map = new HashMap<String, String>(list.size());
                int i = 0;
                while (i < list.size()) {
                    Element element = (Element)list.get(i);
                    this.map.put(element.attributeValue("name"), element.getText());
                    ++i;
                }
            }
            catch (org.dom4j.DocumentException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.force && this.font == null) {
            this.font = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", true);
        }
        this.acroFields = pdfStamper.getAcroFields();
    }

    @Override
    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            int i = 0;
            while (i < annots.size()) {
                PdfDictionary annot = annots.getAsDict(i);
                if (PdfName.WIDGET.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    PdfString name = annot.getAsString(PdfName.T);
                    PdfString tu = annot.getAsString(PdfName.TU);
                    PdfName ft = annot.getAsName(PdfName.FT);
                    PdfString tm = annot.getAsString(PdfName.TM);
                    PdfDictionary parent = annot.getAsDict(PdfName.PARENT);
                    if (name == null && parent != null) {
                        name = parent.getAsString(PdfName.T);
                    }
                    if (name != null) {
                        String val;
                        String nameUnicode;
                        String nameVal = nameUnicode = name.toUnicodeString();
                        if (PdfName.TX.equals(ft) && (tm != null || parent != null)) {
                            nameVal = nameVal.substring(0, nameVal.length() - 3);
                        }
                        if ((val = this.map.get(nameVal)) != null) {
                            this.acroFields.setFont(this.font);
                            if (tm != null && this.acroFields.getField(tm.toUnicodeString()) != null) {
                                this.acroFields.setField(tm.toUnicodeString(), val);
                            } else if (nameUnicode != null && this.acroFields.getField(nameUnicode) != null) {
                                this.acroFields.setField(nameUnicode, val);
                            } else if (tu != null) {
                                this.acroFields.setField(tu.toString(), val);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont font) {
        this.font = font;
    }
}

