/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.electronicseal.sig;

import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import com.kinggrid.pdf.utils.HashPDFDoc10;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;

public abstract class KGPdfElectronicExecute4Sig
extends KGPdfElectronicExecute {
    public void execute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen, byte[] hash) {
        try {
            PdfWriter writer = pdfStamper.getWriter();
            byte[] cert = null;
            byte[] saveCert = null;
            if (this.getChain() == null || this.getChain().length < 1) {
                cert = this.getChainByte();
                if (cert == null) {
                    return;
                }
                saveCert = cert;
            } else {
                cert = this.getChain()[0].getEncoded();
                saveCert = new byte[2612];
                System.arraycopy(cert, 0, saveCert, 0, cert.length);
            }
            PdfNumber certContextNumber = new PdfNumber(saveCert.length);
            PdfIndirectObject certContextNumberIndObj = writer.addToBody(certContextNumber);
            PdfStream certContext = new PdfStream(saveCert);
            certContext.put(KGElectronicSealName.STRLEN, certContextNumberIndObj.getIndirectReference());
            PdfIndirectObject certContextRef = writer.addToBody(certContext);
            annotation.put(new PdfName("certContext"), certContextRef.getIndirectReference());
            byte[] encodedSig = this.sign(hash);
            KGBase64 base64 = new KGBase64();
            encodedSig = base64.encode(encodedSig).getBytes("UTF-16LE");
            PdfNumber signedNumber = new PdfNumber(encodedSig.length);
            PdfIndirectObject signedNumberIndObj = writer.addToBody(signedNumber);
            PdfStream certSignMsg = new PdfStream(encodedSig);
            certSignMsg.put(KGElectronicSealName.STRLEN, signedNumberIndObj.getIndirectReference());
            PdfIndirectObject certSignMsgRef = writer.addToBody(certSignMsg);
            annotation.put(new PdfName("certSignMsg"), certSignMsgRef.getIndirectReference());
            signedNumber = new PdfNumber(encodedSig.length);
            signedNumberIndObj = writer.addToBody(signedNumber);
            PdfStream certSignMsg6 = new PdfStream(encodedSig);
            certSignMsg6.put(KGElectronicSealName.STRLEN, signedNumberIndObj.getIndirectReference());
            PdfIndirectObject certSignMsg6Ref = writer.addToBody(certSignMsg6);
            annotation.put(new PdfName("certSignMsg6"), certSignMsg6Ref.getIndirectReference());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getChainByte() {
        return null;
    }

    public abstract Certificate[] getChain();

    public abstract byte[] sign(byte[] var1) throws GeneralSecurityException;

    @Override
    public void execute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen, String hash) {
        this.execute(pdfStamper, annotation, pagen, HashPDFDoc10.debase64(hash));
    }
}

