/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.electronicseal;

import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.encrypt.KGSignature;
import com.kinggrid.encrypt.SM3Utils;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import com.kinggrid.pdf.executes.signature.sm2.SesSignature;
import com.kinggrid.pdf.signinter.DigitalSignature;
import com.kinggrid.pdf.signinter.DigitalSignatureByServerSM2;
import com.kinggrid.pdf.signinter.DigitalSignatureCertBytes;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;

public class KGPdfElectronicSig
extends KGPdfElectronicExecute {
    private int sigType = 0;
    private String certSignMsg;
    private String certContext;
    private String pwd;
    private InputStream pfxStream;
    private DigitalSignature digitalSignature;
    private PdfIndirectReference refCertSignMsg;
    private PdfIndirectReference refCertContext;
    private KGSignature kgSignature;
    private String signatureAlgorithm = "RSA";
    private byte[] sm2Cert;
    private String sealData;
    private String esType;

    @Deprecated
    public void setSig(String certSignMsg, String certContext) {
        this.sigType = 0;
        this.certSignMsg = certSignMsg;
        this.certContext = certContext;
    }

    public void setCertMsg(InputStream stream, String pwd) {
        this.sigType = 1;
        this.pfxStream = stream;
        this.pwd = pwd;
    }

    public void setCertMsg(DigitalSignature digitalSignature) {
        this.sigType = 2;
        this.digitalSignature = digitalSignature;
    }

    public void setRef(PdfIndirectReference refCertSignMsg, PdfIndirectReference refCertContext) {
        this.refCertContext = refCertContext;
        this.refCertSignMsg = refCertSignMsg;
    }

    @Override
    public void execute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen, String hash) {
        try {
            if (this.sigType == 1) {
                KGBase64 base64 = new KGBase64();
                byte[] hashData = hash.getBytes("GBK");
                if (this.kgSignature == null) {
                    this.kgSignature = new KGSignature(this.pfxStream, this.pwd, this.pwd);
                }
                this.kgSignature.update(hashData);
                byte[] digest = this.kgSignature.sign();
                Certificate[] chain = this.kgSignature.getChain();
                PdfPKCS7 pkcs7 = new PdfPKCS7(null, chain, "SHA1", "KGBC", null, false);
                pkcs7.setExternalDigest(digest, hashData, "RSA");
                byte[] p7 = pkcs7.getEncodedPKCS7();
                String cert = "-----BEGIN CERTIFICATE-----\n" + base64.encode(chain[0].getEncoded()) + "\n-----END CERTIFICATE-----\n";
                this.certSignMsg = base64.encode(p7);
                this.certContext = cert;
            } else if (this.sigType == 2 && this.digitalSignature != null) {
                if ("RSA".equals(this.signatureAlgorithm)) {
                    this.sigWithRSA(hash);
                } else if ("SM2".equals(this.signatureAlgorithm)) {
                    this.sigWithSM2(hash);
                } else {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u7b97\u6cd5\uff1a" + this.signatureAlgorithm);
                }
            }
            if (this.esType != null) {
                annotation.put(new PdfName("ESType"), new PdfString(this.esType));
            }
            if (this.refCertSignMsg == null) {
                byte[] streambyte = this.certSignMsg.getBytes("UTF-16LE");
                PdfStream certSignMsgStream = new PdfStream(streambyte);
                PdfIndirectObject refObj = pdfStamper.getWriter().addToBody(certSignMsgStream);
                this.refCertSignMsg = refObj.getIndirectReference();
            }
            annotation.put(new PdfName("certSignMsg"), this.refCertSignMsg);
            if (this.refCertContext == null) {
                byte[] streambyte1;
                byte[] tmp = streambyte1 = this.certContext.getBytes("UTF-16LE");
                streambyte1 = new byte[tmp.length * 2];
                System.arraycopy(tmp, 0, streambyte1, 0, tmp.length);
                PdfStream certContextStream = new PdfStream(streambyte1);
                PdfIndirectObject refObj1 = pdfStamper.getWriter().addToBody(certContextStream);
                this.refCertContext = refObj1.getIndirectReference();
            }
            annotation.put(new PdfName("certContext"), this.refCertContext);
            pdfStamper.markUsed(annotation);
        }
        catch (KGServerInterfaceErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sigWithRSA(String hash) throws Exception {
        KGBase64 base64 = new KGBase64();
        byte[] hashData = hash.getBytes("GBK");
        Certificate[] chain = null;
        byte[] digest = null;
        digest = this.digitalSignature.sign(hashData);
        chain = this.digitalSignature.getCertificate();
        PdfPKCS7 pkcs7 = new PdfPKCS7(null, chain, "SHA1", "KGBC", null, false);
        pkcs7.setExternalDigest(digest, hashData, "RSA");
        byte[] p7 = pkcs7.getEncodedPKCS7();
        String cert = "-----BEGIN CERTIFICATE-----\n" + base64.encode(chain[0].getEncoded()) + "\n-----END CERTIFICATE-----\n";
        this.certSignMsg = base64.encode(p7);
        this.certContext = cert;
    }

    private void sigWithSM2(String hash) throws Exception {
        KGBase64 base64 = new KGBase64();
        byte[] hashData = hash.getBytes("GBK");
        byte[] digest = null;
        byte[] certdata = null;
        int ver = 0;
        if (this.sealData != null && !this.sealData.equals("")) {
            SealGM sealgm = SealUtil.getSealInfo(base64.decode(this.sealData));
            ver = sealgm.getVersion();
        }
        if (ver == 4) {
            byte[] gmData = base64.decode(this.sealData);
            Date timeDate = Calendar.getInstance().getTime();
            String format = KGDateUtils.format2GMTTime(timeDate, "yyyyMMddHHmmss");
            String date = String.valueOf(format) + "Z";
            byte[] newSM3Hash = SM3Utils.sm3Digest(hashData);
            DERSequence tosigndataSeq = SesSignature.getToSignData(gmData, date, newSM3Hash, "hash");
            byte[] hashDatagm = tosigndataSeq.getEncoded();
            this.setEsType("GMV4");
            if (this.digitalSignature instanceof DigitalSignatureByServerSM2) {
                ((DigitalSignatureByServerSM2)this.digitalSignature).setClientVerify(false);
            }
            digest = this.digitalSignature.sign(hashDatagm);
            digest = base64.decode(new String(digest));
            X509Certificate[] chain = this.digitalSignature.getCertificate();
            if (chain != null) {
                certdata = chain[0].getEncoded();
            } else if (this.digitalSignature instanceof DigitalSignatureCertBytes) {
                DigitalSignatureCertBytes digitalSignatureCertBytes = (DigitalSignatureCertBytes)this.digitalSignature;
                certdata = digitalSignatureCertBytes.getCert();
            } else {
                certdata = this.sm2Cert;
            }
            byte[] timestamp = null;
            if (this.timeStampInter != null) {
                timestamp = this.timeStampInter.getTimeStamp(digest);
            }
            digest = SesSignature.getSesSignature((ASN1Sequence)tosigndataSeq, certdata, digest, timestamp).getEncoded();
            digest = base64.encode(digest).getBytes("UTF-8");
        } else {
            digest = this.digitalSignature.sign(hashData);
            X509Certificate[] chain = this.digitalSignature.getCertificate();
            if (chain != null) {
                certdata = chain[0].getEncoded();
            } else if (this.digitalSignature instanceof DigitalSignatureCertBytes) {
                DigitalSignatureCertBytes digitalSignatureCertBytes = (DigitalSignatureCertBytes)this.digitalSignature;
                certdata = digitalSignatureCertBytes.getCert();
            } else {
                certdata = this.sm2Cert;
            }
        }
        String cert = "-----BEGIN CERTIFICATE-----\n" + base64.encode(certdata) + "\n-----END CERTIFICATE-----\n";
        this.certSignMsg = new String(digest);
        this.certContext = cert;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public byte[] getSm2Cert() {
        return this.sm2Cert;
    }

    public void setSm2Cert(byte[] sm2Cert) {
        this.sm2Cert = sm2Cert;
    }

    public String getEsType() {
        return this.esType;
    }

    public void setEsType(String esType) {
        this.esType = esType;
    }

    public String getSealData() {
        return this.sealData;
    }

    public void setSealData(String sealData) {
        this.sealData = sealData;
    }

    public DigitalSignature getDigitalSignature() {
        return this.digitalSignature;
    }
}

