/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.electronicseal;

import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.log.Logger;
import com.KGitextpdf.text.log.LoggerFactory;
import com.KGitextpdf.text.pdf.codec.Base64;
import com.KGitextpdf.text.pdf.security.BouncyCastleDigest;
import com.KGitextpdf.text.pdf.security.DigestAlgorithms;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.executes.electronicseal.IElecTSA;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.tsp.TSPException;
import org.kg.bouncycastle.tsp.TimeStampRequest;
import org.kg.bouncycastle.tsp.TimeStampRequestGenerator;
import org.kg.bouncycastle.tsp.TimeStampResponse;
import org.kg.bouncycastle.tsp.TimeStampToken;
import org.kg.bouncycastle.tsp.TimeStampTokenInfo;
import org.kg.bouncycastle.util.Store;

public class KGElecTSAClient
implements IElecTSA {
    private static final Logger LOGGER = LoggerFactory.getLogger(KGElecTSAClient.class);
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected int tokenSizeEstimate;
    protected String digestAlgorithm;
    protected TimeStampToken timeStampToken;
    public static final int DEFAULTTOKENSIZE = 4096;
    public static final String DEFAULTHASHALGORITHM = "SHA-256";
    protected KGBase64 base64 = new KGBase64();

    public KGElecTSAClient(String url) {
        this.tsaURL = url;
        this.tsaUsername = null;
        this.tsaPassword = null;
        this.tokenSizeEstimate = 4096;
        this.digestAlgorithm = DEFAULTHASHALGORITHM;
    }

    public KGElecTSAClient(String url, String username, String password) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = 4096;
        this.digestAlgorithm = DEFAULTHASHALGORITHM;
    }

    public KGElecTSAClient(String url, String username, String password, int tokenSizeEstimate, String digestAlgorithm) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = tokenSizeEstimate;
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public void sendTsaRequest(String hash) {
        try {
            MessageDigest messageDigest = this.getMessageDigest();
            messageDigest.update(hash.getBytes());
            byte[] tsImprint = messageDigest.digest();
            this.getTimeStampToken(tsImprint);
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u65f6\u95f4\u6233\u4fe1\u606f\u5931\u8d25\uff01", e);
        }
        catch (TSPException e) {
            throw new RuntimeException("\u83b7\u53d6\u65f6\u95f4\u6233\u4fe1\u606f\u5931\u8d25\uff01", e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("\u83b7\u53d6\u65f6\u95f4\u6233\u4fe1\u606f\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public String getTSTime() {
        if (this.timeStampToken == null) {
            throw new RuntimeException("\u83b7\u53d6\u65f6\u95f4\u6233\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Date dateTime = this.timeStampToken.getTimeStampInfo().getGenTime();
        String s = KGDateUtils.format(dateTime, "yyyy-MM-dd HH:mm:ss");
        return this.base64.encode(s.getBytes());
    }

    @Override
    public String getTSCert() {
        String cert = "";
        try {
            Store store = this.timeStampToken.getCertificates();
            Collection collection = store.getMatches(null);
            for (X509CertificateHolder certificate : collection) {
                cert = this.base64.encode(certificate.getEncoded());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u65f6\u95f4\u6233\u8bc1\u4e66\u5931\u8d25\uff01", e);
        }
        return cert;
    }

    public int getTokenSizeEstimate() {
        return this.tokenSizeEstimate;
    }

    public byte[] getTimeStampToken(byte[] imprint) throws IOException, TSPException {
        int value;
        byte[] respBytes = null;
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = tsqGenerator.generate(new ASN1ObjectIdentifier(DigestAlgorithms.getAllowedDigests(this.digestAlgorithm)), imprint, nonce);
        byte[] requestBytes = request.getEncoded();
        respBytes = this.getTSAResponse(requestBytes);
        TimeStampResponse response = new TimeStampResponse(respBytes);
        response.validate(request);
        PKIFailureInfo failure = response.getFailInfo();
        int n = value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new IOException(MessageLocalization.getComposedMessage("invalid.tsa.1.response.code.2", this.tsaURL, String.valueOf(value)));
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new IOException(MessageLocalization.getComposedMessage("tsa.1.failed.to.return.time.stamp.token.2", this.tsaURL, response.getStatusString()));
        }
        this.timeStampToken = tsToken;
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        LOGGER.info("Timestamp generated: " + tsTokenInfo.getGenTime());
        this.tokenSizeEstimate = encoded.length + 32;
        return encoded;
    }

    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        URLConnection tsaConnection;
        URL url = new URL(this.tsaURL);
        try {
            tsaConnection = url.openConnection();
        }
        catch (IOException ioe) {
            throw new IOException(MessageLocalization.getComposedMessage("failed.to.get.tsa.response.from.1", this.tsaURL));
        }
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.tsaUsername != null && !this.tsaUsername.equals("")) {
            String userPassword = String.valueOf(this.tsaUsername) + ":" + this.tsaPassword;
            tsaConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(userPassword.getBytes(), 8));
        }
        OutputStream out = tsaConnection.getOutputStream();
        out.write(requestBytes);
        out.close();
        InputStream inp = tsaConnection.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            respBytes = Base64.decode(new String(respBytes));
        }
        return respBytes;
    }

    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return new BouncyCastleDigest().getMessageDigest(this.digestAlgorithm);
    }
}

