/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize.yunqian;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.BaseFont;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PdfAction;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.executes.customize.yunqian.KGLink;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PdfLinkAndText
extends KGExecute {
    private String envelopeid;
    private Map<Integer, List<KGLink>> links = null;
    private BaseFont font = null;
    private float x = 20.0f;
    private float y = 25.0f;

    public PdfLinkAndText(String envelopeid, Map<Integer, List<KGLink>> links) {
        this.envelopeid = envelopeid;
        this.links = links;
    }

    @Override
    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PdfDictionary xobject;
        List<KGLink> kgLinks;
        PdfDictionary pageDic = pdfReader.getPageN(pagen);
        Rectangle pageRect = pdfReader.getPageSize(pagen);
        if (this.font == null) {
            this.font = BaseFont.createFont("STSongStd-Light", "UniGB-UCS2-H", false);
        }
        PdfTemplate template = PdfTemplate.createTemplate(pdfStamper.getWriter(), pageRect.getWidth(), pageRect.getHeight());
        template.beginText();
        template.setFontAndSize(this.font, 10.0f);
        template.setColorFill(BaseColor.BLACK);
        template.showTextAligned(0, this.envelopeid, this.x, pageRect.getHeight() - this.y, 0.0f);
        template.endText();
        if (this.links != null && (kgLinks = this.links.get(pagen)) != null) {
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            if (annots == null) {
                annots = new PdfArray();
                pageDic.put(PdfName.ANNOTS, annots);
            }
            for (KGLink link : kgLinks) {
                Image image = link.getImage();
                Rectangle linkRect = link.getRect();
                image.scaleAbsolute(linkRect);
                image.setAbsolutePosition(linkRect.getLeft(), linkRect.getBottom());
                PdfGState gstate = new PdfGState();
                gstate.setBlendMode(PdfGState.BM_MULTIPLY);
                template.setGState(gstate);
                template.addImage(image);
                PdfAction action = new PdfAction(link.getUrl());
                PdfAnnotation annot = PdfAnnotation.createLink(pdfStamper.getWriter(), linkRect, PdfAnnotation.HIGHLIGHT_INVERT, action);
                annot.put(PdfName.BORDER, new PdfArray(new int[3]));
                annots.add(annot);
            }
        }
        PdfStream pdfStream = template.getFormXObject(0);
        PdfIndirectObject formXObjectRef = pdfStamper.getWriter().addToBody(pdfStream);
        PdfDictionary resources = pageDic.getAsDict(PdfName.RESOURCES);
        if (resources == null) {
            resources = new PdfDictionary();
            pageDic.put(PdfName.RESOURCES, resources);
        }
        if ((xobject = resources.getAsDict(PdfName.XOBJECT)) == null) {
            xobject = new PdfDictionary();
            resources.put(PdfName.XOBJECT, xobject);
        }
        int index = 1;
        while (xobject.get(new PdfName("X" + index)) != null) {
            ++index;
        }
        String name = "X" + index;
        xobject.put(new PdfName(name), formXObjectRef.getIndirectReference());
        String content = "Q q /" + name + " Do Q";
        PdfStream contentStream = new PdfStream(content.getBytes());
        PdfIndirectObject contentRef = pdfStamper.getWriter().addToBody(contentStream);
        PdfObject contects = pageDic.get(PdfName.CONTENTS);
        if (contects.isArray()) {
            PdfArray pdfArray = (PdfArray)contects;
            pdfArray.add(contentRef.getIndirectReference());
        } else if (contects.isIndirect()) {
            PdfArray pdfArray = new PdfArray();
            PdfStream s = new PdfStream("q".getBytes());
            PdfIndirectObject sRef = pdfStamper.getWriter().addToBody(s);
            pdfArray.add(sRef.getIndirectReference());
            PRIndirectReference ref = (PRIndirectReference)contects;
            pdfArray.add(ref);
            pdfArray.add(contentRef.getIndirectReference());
            pageDic.put(PdfName.CONTENTS, pdfArray);
        }
        pdfStamper.markUsed(xobject);
        pdfStamper.markUsed(resources);
        pdfStamper.markUsed(pageDic);
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont font) {
        this.font = font;
    }

    public void setXY(float x, float y) {
        this.x = x;
        this.y = y;
    }
}

