/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize.iwebpdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.ImgRaw;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.executes.PdfElectronicSeal;
import com.kinggrid.pdf.executes.customize.iwebpdf.KGSealInfo;
import com.kinggrid.pdf.executes.customize.iwebpdf.KGiWebPdfParser;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicSig;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicTSA;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PdfElecSeal4SaveSignDataToLocal2
extends PdfElectronicSeal {
    private List<KGSealInfo> sealInfos;
    private boolean reCalcHash = false;
    private KGPdfElectronicTSA electronicTSA = new KGPdfElectronicTSA();
    private KGPdfElectronicSig electronicSig = new KGPdfElectronicSig();
    private int platform = 0;

    protected PdfElecSeal4SaveSignDataToLocal2(List<KGSealInfo> sealInfos) {
        this.sealInfos = sealInfos;
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        KGSealInfo sealInfo;
        if (this.sealInfos.size() > 0) {
            sealInfo = this.sealInfos.get(0);
            String[] pageids = sealInfo.getPageID().split("\\^");
            int k = 0;
            while (k < pageids.length) {
                PdfDictionary dict = pdfReader.getPageNRelease(k + 1);
                if (dict != null) {
                    dict.put(PdfName.ID, new PdfString(pageids[k]));
                }
                ++k;
            }
        }
        if ((sealInfo = this.sealInfos.get(0)).getBatchID() != null || sealInfo.getStraddleType() != null) {
            this.setQfzData(true);
            if (sealInfo.getStraddleType() == null) {
                sealInfo.setStraddleType("1");
            }
            this.setStraddleType(sealInfo.getStraddleType());
            this.setQfzSigCertSetChildNode(true);
        }
        this.setCombine(true);
        super.before(pdfReader, pdfStamper);
        if (sealInfo.getBatchID() == null) {
            this.setQfzData(false);
        }
    }

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen1) throws DocumentException, IOException {
        if (this.sealInfos == null) {
            return;
        }
        int i = 0;
        while (i < this.sealInfos.size()) {
            KGBase64 base64;
            KGSealInfo sealInfo = this.sealInfos.get(i);
            int pagen = sealInfo.getPage();
            int rotation = pdfReader.getPageRotation(pagen);
            Rectangle rect = new Rectangle(sealInfo.getLeft(), sealInfo.getBottom(), sealInfo.getRight(), sealInfo.getTop(), 0);
            rect.normalize();
            float width = rect.getWidth();
            float height = rect.getHeight();
            if (rotation == 90 || rotation == 270) {
                width = rect.getHeight();
                height = rect.getWidth();
            }
            float x = (sealInfo.getLeft() + sealInfo.getRight()) / 2.0f;
            float y = (sealInfo.getBottom() + sealInfo.getTop()) / 2.0f;
            Rectangle pageRect = pdfReader.getPageSizeWithRotation(pagen);
            float tmp = 0.0f;
            if (rotation == 90) {
                tmp = x;
                x = y;
                y = pageRect.getHeight() - tmp;
            } else if (rotation == 180) {
                x = pageRect.getWidth() - x;
                y = pageRect.getHeight() - y;
            } else if (rotation == 270) {
                tmp = x;
                x = pageRect.getWidth() - y;
                y = tmp;
            }
            if (sealInfo.getIcon() != null) {
                this.platform = 0;
                PdfStream icon = KGiWebPdfParser.createImg(sealInfo, pdfStamper);
                PdfIndirectObject pdfIndirectObject = pdfStamper.getWriter().addToBody(icon);
                ImgRaw image = new ImgRaw((int)width, (int)height, 1, 1, null);
                image.setDirectReference(pdfIndirectObject.getIndirectReference());
                image.setDeflated(true);
                KGBase64 base642 = new KGBase64();
                byte[] iconbyte = base642.decode(sealInfo.getIcon());
                image.setRawData(iconbyte);
                this.setImage(image);
            } else if (sealInfo.getIcon2018() != null) {
                this.platform = 1;
                base64 = new KGBase64();
                base64.setBase64Table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-");
                byte[] imgdata = base64.decode(sealInfo.getIcon2018());
                this.setImage(imgdata, "png", (int)width, (int)height);
            }
            if (this.platform == 0) {
                this.setRect(new Rectangle(x - width / 2.0f, y - height / 2.0f, x + width / 2.0f, y + height / 2.0f, 0));
            } else if (this.platform == 1) {
                this.setXY(x, y);
            }
            if (this.isNotEmpty(sealInfo.getSealSource())) {
                this.setSealSource(sealInfo.getSealSource());
            }
            this.setSubVersion(0);
            if (this.reCalcHash) {
                base64 = new KGBase64();
                base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
                String baseInfo = new String(base64.decode(sealInfo.getBaseInfo()), "UTF-16LE");
                Map<String, String> map = KGPdfUtils.getBaseInfo(baseInfo);
                this.setSealMsg(map.get("KeySerial"), map.get("CompName"), map.get("UserName"), map.get("SealSerial"), map.get("KeyName"));
                this.setProtectDoc(map.get("bProtectDoc"));
                this.setProversion(6);
            } else {
                if (sealInfo.getProVersion() != 0) {
                    this.setProversion(sealInfo.getProVersion());
                }
                if (this.isNotEmpty(sealInfo.getBaseInfo())) {
                    this.setSealMsg(sealInfo.getBaseInfo());
                }
                base64 = new KGBase64();
                if (sealInfo.getCertSignMsg() != null && sealInfo.getCertContext() != null) {
                    this.electronicSig.setSig(new String(base64.decode(sealInfo.getCertSignMsg()), "UTF-16LE"), new String(base64.decode(sealInfo.getCertContext()), "UTF-16LE"));
                    this.addExtraExecute(this.electronicSig);
                }
            }
            if (sealInfo.getTsTime() != null && sealInfo.getTsCert() != null) {
                this.electronicTSA.setRSA(sealInfo.getTsTime(), sealInfo.getTsCert());
                this.addExtraExecute(this.electronicTSA);
            }
            super.execute(pdfReader, pdfStamper, pagen);
            ++i;
        }
        this.sealInfos = null;
    }

    public boolean isReCalcHash() {
        return this.reCalcHash;
    }

    public void setReCalcHash(boolean reCalcHash) {
        this.reCalcHash = reCalcHash;
    }

    @Override
    public String getHash() {
        return super.getHash().toUpperCase();
    }

    public List<KGSealInfo> getSealInfos() {
        return this.sealInfos;
    }

    public void setSealInfos(List<KGSealInfo> sealInfos) {
        this.sealInfos = sealInfos;
    }

    private boolean isNotEmpty(String val) {
        return val != null && val.length() > 0;
    }
}

