/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize;

import com.kinggrid.encrypt.KGBase64;
import java.io.IOException;
import java.math.BigInteger;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.Certificate;

public class DisposeSigndataToClient {
    public static byte[] spellSignadata(String cert, byte[] signdata) throws IOException {
        KGBase64 base64 = new KGBase64();
        String certContext = "-----BEGIN CERTIFICATE-----" + cert + "-----END CERTIFICATE-----";
        ASN1InputStream aIn = new ASN1InputStream(base64.decode(cert));
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        aIn.close();
        Certificate certificate = Certificate.getInstance((Object)seq);
        byte[] pubKey = certificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        byte[] cert_1 = new byte[64];
        byte[] cert_2 = new byte[64];
        System.arraycopy(pubKey, 1, cert_1, 32, 32);
        System.arraycopy(pubKey, 33, cert_2, 32, 32);
        String str_cert_1 = base64.encode(cert_1);
        String str_cert_2 = base64.encode(cert_2);
        byte[] r = new byte[64];
        byte[] s = new byte[64];
        ASN1Sequence sequence = (ASN1Sequence)DLSequence.fromByteArray((byte[])signdata);
        ASN1Integer ans1Int0 = (ASN1Integer)sequence.getObjectAt(0);
        ASN1Integer ans1Int1 = (ASN1Integer)sequence.getObjectAt(1);
        byte[] sig1 = ans1Int0.getValue().toByteArray();
        if (sig1.length == 33) {
            System.arraycopy(sig1, 1, r, 32, 32);
        } else {
            int start = 32 - sig1.length;
            System.arraycopy(sig1, 0, r, 32 + start, sig1.length);
        }
        byte[] sig2 = ans1Int1.getValue().toByteArray();
        if (sig2.length == 33) {
            System.arraycopy(sig2, 1, s, 32, 32);
        } else {
            int start = 32 - sig2.length;
            System.arraycopy(sig2, 0, s, 32 + start, sig2.length);
        }
        String str_r = base64.encode(r);
        String str_s = base64.encode(s);
        String ret = "ECC" + str_r + "|" + str_s + "@" + str_cert_1 + "|" + str_cert_2 + "|" + "256&" + certContext + "&BASE64_NO";
        byte[] ret_data = base64.encode(ret.getBytes()).getBytes();
        return ret_data;
    }

    public static byte[] dismantleSigndata(byte[] signdata) throws IOException {
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        String sign = new String(base64.decode(new String(signdata)));
        sign = sign.substring(3, sign.indexOf("@"));
        String[] rs = sign.split("\\|");
        byte[] r64 = base64.decode(rs[0]);
        byte[] s64 = base64.decode(rs[1]);
        byte[] r32 = DisposeSigndataToClient.removeZero(r64);
        byte[] s32 = DisposeSigndataToClient.removeZero(s64);
        BigInteger rbInteger = new BigInteger(r32);
        BigInteger sbInteger = new BigInteger(s32);
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        asn1EncodableVector.add((ASN1Encodable)new ASN1Integer(rbInteger));
        asn1EncodableVector.add((ASN1Encodable)new ASN1Integer(sbInteger));
        DERSequence sequence = new DERSequence(asn1EncodableVector);
        return sequence.getEncoded();
    }

    private static byte[] removeZero(byte[] buf) {
        byte[] ret = null;
        if (buf[32] >= 0) {
            ret = new byte[32];
            System.arraycopy(buf, 32, ret, 0, 32);
        } else {
            ret = new byte[33];
            System.arraycopy(buf, 32, ret, 1, 32);
        }
        return ret;
    }
}

