/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.exception.KGElecDigitalSigVerifyException;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.electronicseal.customize.PdfElecWriter;
import com.kinggrid.pdf.executes.electronicseal.customize.PdfElecWriterAspect;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class PdfElectronicSealDetails
extends PdfElecWriter {
    private List<Signinfo> seals = new ArrayList<Signinfo>();
    private PdfElecDigitalSigVerify pdfElecDigitalSigVerify;

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.before(pdfReader, pdfStamper);
        this.addExtraExecute(new PdfElecWriterAspect(){

            @Override
            public void execute(PdfReader pdfReader, PdfStamper pdfStamper, PdfDictionary annot, int pagen, String hash) throws IOException {
                if (KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    Map<String, String> map = KGPdfUtils.parseSeal(annot);
                    PdfArray asArray = annot.getAsArray(PdfName.RECT);
                    PdfString id = annot.getAsString(new PdfName("id"));
                    if (map != null) {
                        PdfString tstime;
                        String extParam;
                        String hashType;
                        Signinfo signinfo = new Signinfo();
                        signinfo.setPage(PdfElectronicSealDetails.this.getpages(pdfReader, annot, pagen));
                        signinfo.setIndex(Integer.valueOf(map.get("sealIndex")));
                        signinfo.setAppName(map.get("AppName"));
                        signinfo.setCompName(map.get("CompName"));
                        signinfo.setKeySn(map.get("KeySerial"));
                        signinfo.setSignSn(map.get("SealSerial"));
                        signinfo.setSignTime(map.get("CreateTime"));
                        signinfo.setUserName(map.get("UserName"));
                        signinfo.setSignName(map.get("KeyName"));
                        signinfo.setSignid(String.valueOf(id));
                        PRIndirectReference inf = annot.getIndRef();
                        if (inf != null) {
                            signinfo.setId(inf.toString());
                        }
                        if ((hashType = map.get("hashType")) != null) {
                            signinfo.setHashType(hashType);
                        }
                        if ((extParam = map.get("ExtParam1")) != null) {
                            signinfo.setExtParam(extParam);
                        }
                        PdfDictionary info = annot.getAsDict(PdfName.INFO);
                        PdfNumber subVersion = info.getAsNumber(KGElectronicSealName.SUBVERSION);
                        PdfString oldNewHash = info.getAsString(KGElectronicSealName.NEWHASH);
                        if (oldNewHash != null) {
                            String newNewHash = null;
                            PdfNumber KGFlags = info.getAsNumber(KGElectronicSealName.KGFLAGS);
                            newNewHash = KGFlags == null ? KGPdfUtils.calc10NewHash(annot, hash, PdfElectronicSealDetails.this.getMessageDigest()) : KGPdfUtils.calc10NewHash(pdfReader, annot, hash, PdfElectronicSealDetails.this.getMessageDigest(), true, PdfElectronicSealDetails.this.refsMap);
                            if (!newNewHash.equals(oldNewHash.toString())) {
                                signinfo.setTamper(true);
                            }
                            if (subVersion.intValue() == 2) {
                                signinfo.setHash(oldNewHash.toString());
                                signinfo.setNewHash(newNewHash);
                            } else {
                                signinfo.setHash(map.get("strMd5"));
                                signinfo.setNewHash(hash);
                            }
                        } else {
                            String singleHash = map.get("strMd5");
                            if (!singleHash.equalsIgnoreCase(hash)) {
                                signinfo.setTamper(true);
                            }
                            signinfo.setHash(singleHash);
                            signinfo.setNewHash(hash);
                        }
                        PdfIndirectReference certRef = annot.getAsIndirectObject(new PdfName("certContext"));
                        PdfIndirectReference signDataRef = annot.getAsIndirectObject(new PdfName("certSignMsg"));
                        if (certRef != null && signDataRef != null) {
                            PRStream certStream = (PRStream)pdfReader.getPdfObject(certRef.getNumber());
                            byte[] certData = PdfReader.getStreamBytesRaw(certStream);
                            if (PdfName.FLATEDECODE.equals(certStream.get(PdfName.FILTER))) {
                                certData = PdfReader.FlateDecode(certData);
                            }
                            signinfo.setCert(new String(certData, "UTF-16LE").getBytes("UTF-8"));
                            PRStream signDataStream = (PRStream)pdfReader.getPdfObject(signDataRef.getNumber());
                            byte[] signData = PdfReader.getStreamBytesRaw(signDataStream);
                            if (PdfName.FLATEDECODE.equals(signDataStream.get(PdfName.FILTER))) {
                                signData = PdfReader.FlateDecode(signData);
                            }
                            signinfo.setSignData(new String(signData, "UTF-16LE").getBytes("UTF-8"));
                            if (PdfElectronicSealDetails.this.pdfElecDigitalSigVerify != null) {
                                try {
                                    boolean result = PdfElectronicSealDetails.this.pdfElecDigitalSigVerify.verify(signinfo.getSignData(), signinfo.getNewHash().getBytes("GBK"), signinfo.getCert(), annot);
                                    if (result && !signinfo.isTamper()) {
                                        signinfo.setDigitalSigVerify("1");
                                    } else {
                                        signinfo.setDigitalSigVerify("2");
                                    }
                                }
                                catch (KGElecDigitalSigVerifyException e) {
                                    signinfo.setDigitalSigVerify("2");
                                    signinfo.setErrorInfo(e.getMessage());
                                }
                            }
                        }
                        if ((tstime = annot.getAsString(new PdfName("TSTime"))) != null) {
                            signinfo.setTsIsTamper(String.valueOf(signinfo.isTamper()));
                            signinfo.setTsTime(tstime.toString());
                        }
                        Rectangle pagRect = pdfReader.getPageSize(pagen);
                        int rotation = pdfReader.getPageRotation(pagen);
                        float width = pagRect.getWidth();
                        float height = pagRect.getHeight();
                        Map<String, Float> ll = KGPdfUtils.RotationXY(asArray.getAsNumber(0).floatValue(), asArray.getAsNumber(1).floatValue(), width, height, rotation);
                        Map<String, Float> ur = KGPdfUtils.RotationXY(asArray.getAsNumber(2).floatValue(), asArray.getAsNumber(3).floatValue(), width, height, rotation);
                        Rectangle rect = new Rectangle(ll.get("x").floatValue(), ll.get("y").floatValue(), ur.get("x").floatValue(), ur.get("y").floatValue());
                        rect.normalize();
                        signinfo.setRect(rect);
                        PdfElectronicSealDetails.this.seals.add(signinfo);
                    }
                }
            }
        });
    }

    private LinkedHashSet<Integer> getpages(PdfReader pdfReader, PdfDictionary annot, int pagen) {
        LinkedHashSet<Integer> pages = new LinkedHashSet<Integer>();
        pages.add(pagen);
        PdfArray childArray = annot.getAsArray(new PdfName("ChildList"));
        if (childArray == null) {
            return pages;
        }
        int i = 0;
        while (i < childArray.size()) {
            PdfIndirectReference ref = childArray.getAsIndirectObject(i);
            PdfDictionary pdfDictionary = (PdfDictionary)pdfReader.getPdfObject(ref.getNumber());
            PdfName value = pdfDictionary.getAsName(PdfName.TYPE);
            if (PdfName.PAGE.toString().equals(value.toString())) {
                int nums = pdfReader.getNumberOfPages();
                int j = 1;
                while (j <= nums) {
                    PdfDictionary pageNDictionary = pdfReader.getPageN(j);
                    int pageNRef = pageNDictionary.getIndRef().getNumber();
                    if (pageNRef == ref.getNumber()) {
                        pages.add(j);
                    }
                    ++j;
                }
            }
            i += 2;
        }
        return pages;
    }

    @Override
    protected void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.after(pdfReader, pdfStamper);
        Collections.sort(this.seals, new Comparator<Signinfo>(){

            @Override
            public int compare(Signinfo o1, Signinfo o2) {
                return o1.getIndex() > o2.getIndex() ? 1 : 0;
            }
        });
    }

    public List<Signinfo> getSeals() {
        return this.seals;
    }

    public void setPdfElecDigitalSigVerify(PdfElecDigitalSigVerify pdfElecDigitalSigVerify) {
        this.pdfElecDigitalSigVerify = pdfElecDigitalSigVerify;
    }

    public static interface PdfElecDigitalSigVerify {
        public boolean verify(byte[] var1, byte[] var2, byte[] var3, PdfDictionary var4);
    }

    public class Signinfo {
        private LinkedHashSet<Integer> page;
        private int index;
        private String signid;
        private String id;
        private String signName;
        private String appName;
        private String compName;
        private String userName;
        private String keySn;
        private String signSn;
        private String signTime;
        private String hash;
        private boolean isTamper;
        private byte[] cert;
        private byte[] signData;
        private String newHash;
        private String extParam;
        private String errorInfo;
        private String tsIsTamper;
        private String tsTime;
        private String digitalSigVerify = "0";
        private String hashType = "0";
        private Rectangle rect;

        public String getErrorInfo() {
            return this.errorInfo;
        }

        public void setErrorInfo(String errorInfo) {
            this.errorInfo = errorInfo;
        }

        public String getSignName() {
            return this.signName;
        }

        public void setSignName(String signName) {
            this.signName = signName;
        }

        public LinkedHashSet<Integer> getPage() {
            return this.page;
        }

        public void setPage(LinkedHashSet<Integer> page) {
            this.page = page;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getCompName() {
            return this.compName;
        }

        public void setCompName(String compName) {
            this.compName = compName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getKeySn() {
            return this.keySn;
        }

        public void setKeySn(String keySn) {
            this.keySn = keySn;
        }

        public String getSignSn() {
            return this.signSn;
        }

        public void setSignSn(String signSn) {
            this.signSn = signSn;
        }

        public String getSignTime() {
            return this.signTime;
        }

        public void setSignTime(String signTime) {
            this.signTime = signTime;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public boolean isTamper() {
            return this.isTamper;
        }

        public void setTamper(boolean isTamper) {
            this.isTamper = isTamper;
        }

        public byte[] getCert() {
            return this.cert;
        }

        public void setCert(byte[] cert) {
            this.cert = cert;
        }

        public byte[] getSignData() {
            return this.signData;
        }

        public void setSignData(byte[] signData) {
            this.signData = signData;
        }

        public String getNewHash() {
            return this.newHash;
        }

        public void setNewHash(String newHash) {
            this.newHash = newHash;
        }

        public String getHashType() {
            return this.hashType;
        }

        public void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public Rectangle getRect() {
            return this.rect;
        }

        public void setRect(Rectangle rect) {
            this.rect = rect;
        }

        public String getDigitalSigVerify() {
            return this.digitalSigVerify;
        }

        public void setDigitalSigVerify(String digitalSigVerify) {
            this.digitalSigVerify = digitalSigVerify;
        }

        public String toString() {
            return "KgPdfSignInfo [index=" + this.index + ", signName=" + this.signName + ", appName=" + this.appName + ", compName=" + this.compName + ", userName=" + this.userName + ", keySn=" + this.keySn + ", signSn=" + this.signSn + ", signTime=" + this.signTime + ", signid=" + this.signid + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + (this.signTime == null ? 0 : this.signTime.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Signinfo other = (Signinfo)obj;
            if (this.index != other.index) {
                return false;
            }
            return !(this.signTime == null ? other.signTime != null : !this.signTime.equals(other.signTime));
        }

        public String getSignid() {
            return this.signid;
        }

        public void setSignid(String signid) {
            this.signid = signid;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String tsIsTamper() {
            return this.tsIsTamper;
        }

        public void setTsIsTamper(String tsIsTamper) {
            this.tsIsTamper = tsIsTamper;
        }

        public String getTsTime() {
            return this.tsTime;
        }

        public void setTsTime(String tsTime) {
            this.tsTime = tsTime;
        }

        public String getExtParam() {
            return this.extParam;
        }

        public void setExtParam(String extParam) {
            this.extParam = extParam;
        }
    }
}

