/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.kgcore.KGElectronicSeal;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.pdf.executes.PdfElectronicSeal;
import java.io.IOException;

public class PdfElectronicSeal4KG
extends PdfElectronicSeal {
    private String resetKeysn;
    private String resetUserName;
    private float resetImageWidth;
    private float resetImageHeight;

    public PdfElectronicSeal4KG(String keyPath, int sealNumb, String sealPwd) {
        this.kgElectronicSeal = new KGElectronicSeal(keyPath, sealNumb, sealPwd);
    }

    public PdfElectronicSeal4KG(String url, KGServerTypeEnum type, String keySN, String password, String signName) {
        this.kgElectronicSeal = new KGElectronicSeal(url, type, keySN, password, signName);
    }

    public PdfElectronicSeal4KG(String url, KGServerTypeEnum type, String keySN, String password, int index) {
        this.kgElectronicSeal = new KGElectronicSeal(url, type, keySN, password, index);
    }

    public PdfElectronicSeal4KG(String userInfo, String netFileSignatures, KGServerTypeEnum type) {
        this.kgElectronicSeal = new KGElectronicSeal(userInfo, netFileSignatures, type);
    }

    @Override
    public void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        if (this.getImage() == null && this.getQfzSealMap() == null) {
            SealInformation sealInformation = this.kgElectronicSeal.getSeal();
            float width = Float.valueOf(sealInformation.getImgWidth()).floatValue() * this.cm2px();
            float height = Float.valueOf(sealInformation.getImgHeight()).floatValue() * this.cm2px();
            String imgExt = sealInformation.getImgFileExt().substring(1);
            if (this.resetImageWidth != 0.0f && this.resetImageHeight != 0.0f) {
                width = this.resetImageWidth;
                height = this.resetImageHeight;
            }
            this.setImage(sealInformation.getImgValue(), imgExt, (int)width, (int)height);
            if (this.resetKeysn != null) {
                sealInformation.setKeySN(this.resetKeysn);
                sealInformation.setImgUserName(this.resetUserName);
            }
            if (sealInformation.getSealData() != null) {
                this.sealData = sealInformation.getSealData();
            }
            this.setSealMsg(sealInformation.getKeySN(), sealInformation.getImgUnitName(), sealInformation.getImgUserName(), sealInformation.getSignSN(), sealInformation.getImgSignName());
            if (this.logEntity != null) {
                this.logEntity.setLogType("00");
                this.logEntity.setLogSort("13");
                this.logEntity.setKeySN(sealInformation.getKeySN());
                this.logEntity.setSignSN(sealInformation.getSignSN());
            }
        }
        this.addText2Img();
        super.before(pdfReader, pdfStamper);
    }

    public void resetImageSize(float resetImageWidth, float resetImageHeight) {
        this.resetImageWidth = resetImageWidth;
        this.resetImageHeight = resetImageHeight;
    }

    public void resetSealMsg(String keysn, String userName) {
        this.resetKeysn = keysn;
        this.resetUserName = userName;
    }
}

