/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.BaseFont;
import com.KGitextpdf.text.pdf.PdfAnnotation;
import com.KGitextpdf.text.pdf.PdfAppearance;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfContentByte;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.Version;
import com.kinggrid.pdf.enmu.KGPoistionEnum;
import com.kinggrid.pdf.executes.AbstractSign;
import com.kinggrid.pdf.executes.electronicseal.KGDefaultMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicSig;
import com.kinggrid.pdf.signinter.DigitalSignature;
import com.kinggrid.pdf.signinter.DigitalSignatureByServer;
import com.kinggrid.pdf.utils.HashPDFDoc10;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.kg.bouncycastle.util.encoders.Hex;

public class PdfElectronicSeal
extends AbstractSign {
    private String strMd5;
    private String newHash;
    private String strMd6;
    private String keySN;
    private String keyName;
    private String compName;
    private String userName;
    private String signSN;
    private int sealNumb = -1;
    private PdfDictionary qfzFirstPage;
    private int qfzFirstPageNumb;
    private PdfAnnotation parentAnnot;
    private Image parentImage;
    private PdfArray childList;
    private List<KGPdfElectronicExecute> executes;
    private KGMessageDigest messageDigest;
    private int proversion = 6;
    private int subVersion = 1;
    private PdfNumber hashType = KGElectronicSealName.HASH_TYPE_SHA1;
    private String protectDoc = "1";
    private String sealMsg;
    private IBaseinfo baseinfoInter;
    protected String sealData;
    private String extParam;
    private boolean isCombine;
    private boolean qfzSigCertSetChildNode = false;
    private LinkedHashMap<Integer, PdfIndirectReference> refsMap = new LinkedHashMap();
    private String printExtParamStr;
    private String antiFakeText;
    private String fontPath;
    private int fontSize;
    private int alpha;
    private String bSignByCalibrary;
    private boolean onlyShowInIWebPDF = false;

    public void setBaseinfoInter(IBaseinfo baseinfoInter) {
        this.baseinfoInter = baseinfoInter;
    }

    public void setPrintExtParam(String strText, float alpha) {
        this.printExtParamStr = String.valueOf(strText) + ";" + alpha;
    }

    public void setExtParam(String extParam) {
        this.extParam = extParam;
    }

    public void setAntiFakeInfo(String antiFakeText, String fontPath, int fontSize, int alpha) {
        this.antiFakeText = antiFakeText;
        this.fontPath = fontPath;
        this.fontSize = fontSize;
        this.alpha = alpha;
    }

    public void setBSignByCalibraryValue(String bSignByCalibrary) {
        this.bSignByCalibrary = bSignByCalibrary;
    }

    public void onlyShowInIWebPDF() {
        this.onlyShowInIWebPDF = true;
    }

    private boolean isqfz() {
        return this.position == KGPoistionEnum.QFZ || this.isQfzData();
    }

    public boolean isQfzSigCertSetChildNode() {
        return this.qfzSigCertSetChildNode;
    }

    public void setQfzSigCertSetChildNode(boolean qfzSigCertSetChildNode) {
        this.qfzSigCertSetChildNode = qfzSigCertSetChildNode;
    }

    @Override
    protected void sign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, Image image, Rectangle rect) throws DocumentException {
        if (this.sealNumb == -1) {
            this.sealNumb = this.getSealNum(pdfReader);
        }
        PdfWriter pdfWriter = pdfStamper.getWriter();
        rect.normalize();
        PdfAnnotation annotation = new PdfAnnotation(pdfWriter, rect);
        annotation.put(new PdfName("id"), new PdfString(UUID.randomUUID().toString()));
        annotation.put(PdfName.TYPE, PdfName.ANNOT);
        annotation.put(PdfName.SUBTYPE, KGElectronicSealName.SEAL);
        if (this.getBatchID() != null && !"".equals(this.getBatchID())) {
            annotation.put(new PdfName("BatchID"), new PdfString(this.getBatchID()));
        }
        if (this.getSealSource() != null && !"".equals(this.getSealSource())) {
            annotation.put(new PdfName("SealSource"), new PdfString(this.getSealSource()));
        }
        if (this.bSignByCalibrary != null && !"".equals(this.bSignByCalibrary)) {
            annotation.put(new PdfName("bSignByCalibrary"), new PdfString(this.bSignByCalibrary));
        }
        annotation.setFlags(4);
        if (this.isqfz()) {
            annotation.put(KGElectronicSealName.STRADDLETYPE, new PdfNumber(this.getStraddleType()));
        }
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfAppearance app = PdfAppearance.createAppearance(pdfWriter, rect.getWidth(), rect.getHeight());
        PdfGState gstate = new PdfGState();
        gstate.setBlendMode(this.getBlendMode());
        app.setGState(gstate);
        if (this.position == KGPoistionEnum.QFZ) {
            this.rotationApp(app, rect.getRotation());
        } else if (!this.isRotation()) {
            this.rotationApp(app, rect.getRotation() + (360 - this.getRotationAngle()));
        }
        if (!image.isDeflated() && image.isImgRaw()) {
            this.compression(image);
        }
        app.addImage(image, rect.getWidth(), 0.0f, 0.0f, rect.getHeight(), 0.0f, 0.0f);
        if (this.antiFakeText != null && !"".equals(this.antiFakeText)) {
            this.addAntiFakeInfo(app, this.antiFakeText, this.alpha);
        }
        if (this.onlyShowInIWebPDF) {
            annotation.setAppearanceGGP(PdfAnnotation.APPEARANCE_NORMAL, app);
        } else {
            annotation.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, app);
        }
        if (this.isqfz()) {
            if (this.qfzFirstPage == null) {
                this.qfzFirstPage = page;
                this.qfzFirstPageNumb = pagen;
                this.parentAnnot = annotation;
                this.parentImage = image;
                this.childList = new PdfArray();
                int straddle = 1;
                PdfNumber straddleNumb = pdfReader.getCatalog().getAsNumber(KGElectronicSealName.STRADDLE);
                if (straddleNumb != null) {
                    straddle = straddleNumb.intValue() + 1;
                }
                if (!this.isCombine) {
                    this.calcHash(pdfReader, annotation, app, image);
                }
                if (this.subVersion != 0 && !this.isCombine) {
                    this.messageDigest.update(this.strMd5.getBytes());
                    for (Map.Entry<Integer, PdfIndirectReference> entry : this.refsMap.entrySet()) {
                        PdfObject refObj = PdfReader.getPdfObject(entry.getValue());
                        try {
                            HashPDFDoc10.hashObject(refObj, 2, false, pdfReader, this.messageDigest, true, null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (this.subVersion != 0 && !this.isCombine) {
                    rect = this.rotateRect(pdfReader, pagen, rect);
                    this.clacAnnotRectAndAp(app, image, rect);
                }
                pdfReader.getCatalog().put(KGElectronicSealName.SEALNUM, new PdfNumber(this.sealNumb + 1));
                pdfReader.getCatalog().put(KGElectronicSealName.STRADDLE, new PdfNumber(straddle));
            } else {
                if (this.subVersion != 0 && !this.isCombine) {
                    rect = this.rotateRect(pdfReader, pagen, rect);
                    this.clacAnnotRectAndAp(app, image, rect);
                }
                annotation.put(PdfName.P, this.qfzFirstPage.getIndRef());
                annotation.put(PdfName.PARENT, this.parentAnnot.getIndirectReference());
                this.childList.add(page.getIndRef());
                this.childList.add(annotation.getIndirectReference());
                if (this.qfzSigCertSetChildNode) {
                    this.doExecute(pdfStamper, annotation, pagen);
                }
                pdfStamper.addAnnotation(annotation, page);
            }
        } else {
            this.clacHashAndInfoMessage(pdfReader, pdfStamper, pagen, annotation, app, image, rect);
            this.doExecute(pdfStamper, annotation, pagen);
            pdfReader.getCatalog().put(KGElectronicSealName.SEALNUM, new PdfNumber(++this.sealNumb));
            pdfStamper.addAnnotation(annotation, page);
        }
    }

    private void compression(Image image) {
        if (image.getCompressionLevel() == 0) {
            image.setCompressionLevel(-1);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(image.getCompressionLevel());
        DeflaterOutputStream zip = new DeflaterOutputStream((OutputStream)stream, deflater);
        try {
            zip.write(image.getRawData());
            zip.close();
            deflater.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        image.setDeflated(true);
        image.setRawData(stream.toByteArray());
    }

    private void clacHashAndInfoMessage(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, PdfAnnotation annotation, PdfAppearance app, Image image, Rectangle rect) {
        if (!this.isCombine || this.sealMsg == null) {
            this.calcHash(pdfReader, annotation, app, image);
            Map<String, String> map = this.generateSealMsg(pdfReader, pdfStamper, image, pagen);
            if (this.subVersion != 0) {
                this.newHash(pdfReader, pdfStamper, pagen, annotation, app, image, rect);
            }
            if (this.baseinfoInter != null) {
                if (this.subVersion == 2) {
                    this.baseinfoInter.invoke(map, pdfStamper, annotation, pagen, this.newHash);
                } else {
                    this.baseinfoInter.invoke(map, pdfStamper, annotation, pagen, this.strMd5);
                }
            }
        }
        PdfIndirectReference indirectRef = this.getKGSealInfoRef(pdfReader, pdfStamper, this.newHash);
        annotation.put(PdfName.INFO, indirectRef);
    }

    private void newHash(PdfReader pdfReader, PdfStamper pdfStamper, int pagen, PdfAnnotation annotation, PdfAppearance app, Image image, Rectangle rect) {
        this.messageDigest.update(this.strMd5.getBytes());
        for (Map.Entry<Integer, PdfIndirectReference> entry : this.refsMap.entrySet()) {
            PdfIndirectReference ref = entry.getValue();
            PdfObject refObj = PdfReader.getPdfObject(ref);
            try {
                HashPDFDoc10.hashObject(refObj, 2, false, pdfReader, this.messageDigest, true, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        rect = this.rotateRect(pdfReader, pagen, rect);
        this.clacAnnotRectAndAp(app, image, rect);
        this.messageDigest.update(this.sealMsg.getBytes());
        this.newHash = new String(Hex.encode((byte[])this.messageDigest.digest()));
    }

    private void clacAnnotRectAndAp(PdfAppearance app, Image image, Rectangle rect) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String annotRect = String.valueOf(decimalFormat.format(rect.getLeft())) + " " + decimalFormat.format(rect.getBottom()) + " " + decimalFormat.format(rect.getRight()) + " " + decimalFormat.format(rect.getTop());
        this.messageDigest.update(annotRect.getBytes());
        Rectangle box = app.getBoundingBox();
        String imgbox = String.valueOf(decimalFormat.format(box.getLeft())) + " " + decimalFormat.format(box.getBottom()) + " " + decimalFormat.format(box.getRight()) + " " + decimalFormat.format(box.getTop());
        this.messageDigest.update(imgbox.getBytes());
        PdfArray matrix = app.getMatrix();
        String imgMatix = "";
        if (matrix != null) {
            int i = 0;
            while (i < matrix.size()) {
                imgMatix = String.valueOf(imgMatix) + String.valueOf(matrix.getAsNumber(i).intValue()) + " ";
                ++i;
            }
            imgMatix = imgMatix.substring(0, imgMatix.length() - 1);
        } else {
            imgMatix = "1 0 0 1 0 0";
        }
        this.messageDigest.update(imgMatix.getBytes());
        try {
            PdfStream objStream = app.getFormXObject(-1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            objStream.writeContent(baos);
            byte[] nData = baos.toByteArray();
            this.messageDigest.update(nData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.messageDigest.update(image.getRawData());
    }

    private void calcHash(PdfReader pdfReader, PdfAnnotation annotation, PdfAppearance app, Image image) {
        if (this.messageDigest == null) {
            this.messageDigest = new KGDefaultMessageDigest();
        }
        if (this.strMd5 != null) {
            return;
        }
        if (this.proversion == 10) {
            try {
                byte[] hash = HashPDFDoc10.getHashByte(pdfReader, this.messageDigest, false, this.refsMap);
                this.strMd5 = HashPDFDoc10.base64(hash);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            byte[] hash = KGPdfUtils.calculatePdfHash4Elec(pdfReader, this.messageDigest);
            this.strMd5 = new String(Hex.encode((byte[])hash));
        }
    }

    private PdfIndirectReference getKGSealInfoRef(PdfReader pdfReader, PdfStamper pdfStamper, String newHash) {
        PdfDictionary dicInfo = new PdfDictionary();
        dicInfo.put(KGElectronicSealName.PROVERSION, new PdfNumber(this.proversion));
        dicInfo.put(KGElectronicSealName.UNICODE, new PdfBoolean(true));
        dicInfo.put(KGElectronicSealName.HASH_TYPE, this.hashType);
        if (this.subVersion != 0) {
            dicInfo.put(KGElectronicSealName.SUBVERSION, new PdfNumber(this.subVersion));
            dicInfo.put(KGElectronicSealName.KGFLAGS, new PdfNumber(1));
            dicInfo.put(KGElectronicSealName.NEWHASH, new PdfString(newHash));
        }
        PdfWriter pdfWriter = pdfStamper.getWriter();
        try {
            PdfStream baseInfo = new PdfStream(this.sealMsg.getBytes());
            PdfNumber pdfNumber = new PdfNumber(this.sealMsg.length());
            PdfIndirectObject pdfNumberIndObj = pdfWriter.addToBody(pdfNumber);
            baseInfo.put(KGElectronicSealName.STRLEN, pdfNumberIndObj.getIndirectReference());
            PdfIndirectObject baseInfoIndObj = pdfWriter.addToBody(baseInfo);
            dicInfo.put(KGElectronicSealName.BASEINFO, baseInfoIndObj.getIndirectReference());
            PdfIndirectObject dicInfoUndObj = pdfWriter.addToBody(dicInfo);
            return dicInfoUndObj.getIndirectReference();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> generateSealMsg(PdfReader pdfReader, PdfStamper pdfStamper, Image image, int pagen) {
        String typeSign = "1";
        if (this.isqfz()) {
            typeSign = "5";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sealIndex", String.valueOf(this.sealNumb));
        map.put("Width", String.valueOf(image.getWidth()));
        map.put("Height", String.valueOf(image.getHeight()));
        map.put("actWidth", String.valueOf(image.getScaledWidth()));
        map.put("actHeight", String.valueOf(image.getScaledHeight()));
        map.put("bProtectDoc", this.protectDoc);
        map.put("bEffect", "1");
        map.put("bCertSign", "0");
        map.put("AppName", Version.getApiVersion());
        map.put("KeyName", this.keyName);
        map.put("CompName", this.compName);
        map.put("UserName", this.userName);
        map.put("KeySerial", this.keySN);
        map.put("SealSerial", this.signSN);
        map.put("CreateTime", KGDateUtils.dateTime(new Date()));
        map.put("strMd5", this.strMd5);
        map.put("strMd6", this.strMd6);
        map.put("typeSign", typeSign);
        map.put("doffSign", "0");
        map.put("DateCheck", "0");
        map.put("noConnection", "0");
        if (this.printExtParamStr != null && !"".equals(this.printExtParamStr)) {
            map.put("PrintExtParam", this.printExtParamStr);
        }
        if (this.extParam != null && !"".equals(this.extParam)) {
            map.put("ExtParam1", this.extParam);
        }
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        try {
            this.sealMsg = base64.encode(this.getBaseInfo(map).getBytes("UTF-16LE"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    @Override
    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.before(pdfReader, pdfStamper);
        this.proversion = Integer.valueOf(Version.getProperty("proversion"));
        this.subVersion = Integer.valueOf(Version.getProperty("subVersion"));
        if (this.pagenType == -1) {
            if (this.getPagen() != 0) {
                return;
            }
            this.setQfzData(true);
            this.setStartPage(this.getStartPage());
        } else if (this.pagenType == 1 && this.pagens.length > 1) {
            this.setQfzData(true);
            this.setStartPage(this.pagens[0]);
        }
    }

    @Override
    public void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        super.after(pdfReader, pdfStamper);
        if (this.isqfz()) {
            if (this.sealMsg == null) {
                Map<String, String> map = this.generateSealMsg(pdfReader, pdfStamper, this.parentImage, this.qfzFirstPageNumb);
                if (this.subVersion != 0) {
                    this.messageDigest.update(this.sealMsg.getBytes());
                    this.newHash = new String(Hex.encode((byte[])this.messageDigest.digest()));
                }
                if (this.baseinfoInter != null) {
                    if (this.subVersion == 2) {
                        this.baseinfoInter.invoke(map, pdfStamper, this.parentAnnot, this.qfzFirstPageNumb, this.newHash);
                    } else {
                        this.baseinfoInter.invoke(map, pdfStamper, this.parentAnnot, this.qfzFirstPageNumb, this.strMd5);
                    }
                }
            }
            PdfIndirectReference indirectRef = this.getKGSealInfoRef(pdfReader, pdfStamper, this.newHash);
            this.parentAnnot.put(PdfName.INFO, indirectRef);
            this.parentAnnot.put(KGElectronicSealName.CHILDLIST, this.childList);
            this.doExecute(pdfStamper, this.parentAnnot, this.qfzFirstPageNumb);
            pdfStamper.addAnnotation(this.parentAnnot, this.qfzFirstPageNumb);
            pdfStamper.markUsed(this.qfzFirstPage);
        }
        pdfStamper.markUsed(pdfReader.getCatalog());
    }

    private int getSealNum(PdfReader pdfReader) {
        PdfNumber pdfNumber = pdfReader.getCatalog().getAsNumber(KGElectronicSealName.SEALNUM);
        if (pdfNumber != null) {
            return pdfNumber.intValue();
        }
        return 0;
    }

    private Rectangle rotateRect(PdfReader reader, int pagen, Rectangle rect) {
        Rectangle rotateRect = null;
        int rotation = reader.getPageRotation(pagen);
        Rectangle pageSize = reader.getPageSizeWithRotation(pagen);
        switch (rotation) {
            case 90: {
                rotateRect = new Rectangle(pageSize.getTop() - rect.getTop(), pageSize.getLeft() + rect.getRight(), pageSize.getTop() - rect.getBottom(), pageSize.getLeft() + rect.getLeft());
                break;
            }
            case 180: {
                rotateRect = new Rectangle(pageSize.getRight() - rect.getLeft(), pageSize.getTop() - rect.getBottom(), pageSize.getRight() - rect.getRight(), pageSize.getTop() - rect.getTop());
                break;
            }
            case 270: {
                rotateRect = new Rectangle(pageSize.getBottom() + rect.getBottom(), pageSize.getRight() - rect.getLeft(), pageSize.getBottom() + rect.getTop(), pageSize.getRight() - rect.getRight());
                break;
            }
            default: {
                rotateRect = new Rectangle(pageSize.getLeft() + rect.getLeft(), pageSize.getBottom() + rect.getBottom(), pageSize.getLeft() + rect.getRight(), pageSize.getBottom() + rect.getTop());
            }
        }
        return rotateRect;
    }

    public void addExtraExecute(KGPdfElectronicExecute execute) {
        if (this.executes == null) {
            this.executes = new ArrayList<KGPdfElectronicExecute>();
        }
        this.executes.add(execute);
    }

    public List<KGPdfElectronicExecute> getExtraExecute() {
        return this.executes;
    }

    private void doExecute(PdfStamper pdfStamper, PdfAnnotation annotation, int pagen) {
        if (this.executes != null) {
            for (KGPdfElectronicExecute pdfElectronicExecute : this.executes) {
                if (pdfElectronicExecute instanceof KGPdfElectronicSig) {
                    KGPdfElectronicSig pdfElectronicSig = (KGPdfElectronicSig)pdfElectronicExecute;
                    DigitalSignature digitalSignature = pdfElectronicSig.getDigitalSignature();
                    if (digitalSignature instanceof DigitalSignatureByServer) {
                        DigitalSignatureByServer digitalSignatureByServer = (DigitalSignatureByServer)digitalSignature;
                        digitalSignatureByServer.setSignSN(this.signSN);
                    }
                    pdfElectronicSig.setSealData(this.sealData);
                }
                String hash = this.subVersion == 2 ? this.newHash : this.strMd5;
                pdfElectronicExecute.execute(pdfStamper, annotation, pagen, hash);
            }
        }
    }

    private String getBaseInfo(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            builder.append(String.valueOf(key) + "=" + map.get(key)).append("\r\n");
        }
        return builder.toString();
    }

    private void addAntiFakeInfo(PdfAppearance app, String antiFakeText, int alpha) throws DocumentException {
        try {
            Random r = new Random();
            BaseFont baseFont = BaseFont.createFont(this.fontPath, "Identity-H", false);
            app.setFontAndSize(baseFont, this.fontSize);
            app.setRGBColorFill(255, 255, 255 - alpha);
            float ascentPoint = baseFont.getAscentPoint(antiFakeText, this.fontSize);
            float descentPoint = baseFont.getDescentPoint(antiFakeText, this.fontSize);
            float fontHeight = ascentPoint - descentPoint;
            float firstLinePosition = app.getHeight() - ascentPoint;
            int row = (int)app.getHeight() / ((int)fontHeight + 8);
            int i = 0;
            while (i <= row) {
                app.beginText();
                int num = 16 - r.nextInt(32) + 1;
                app.moveText(num, firstLinePosition - (float)i * (fontHeight + 8.0f));
                app.showText(antiFakeText);
                app.endText();
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addExtraImage(KGPdfHummer hummer) throws IOException, DocumentException {
        SealInformation sealInformation = this.kgElectronicSeal.getSeal();
        float width = Float.valueOf(sealInformation.getImgWidth()).floatValue() * this.cm2px();
        float height = Float.valueOf(sealInformation.getImgHeight()).floatValue() * this.cm2px();
        String imgExt = sealInformation.getImgFileExt().substring(1);
        this.setImage(sealInformation.getImgValue(), imgExt, (int)width, (int)height);
        this.setSealMsg(sealInformation.getKeySN(), sealInformation.getImgUnitName(), sealInformation.getImgUserName(), sealInformation.getSignSN(), sealInformation.getImgSignName());
        PdfStamper pdfStamper = hummer.getPdfStamper();
        int[] pages = null;
        if (this.getPagenType() == 1) {
            pages = this.getPagens();
        } else if (this.getPagen() == 0) {
            int pageSize = hummer.getPdfReader().getNumberOfPages();
            pages = new int[pageSize];
            int i = 0;
            while (i < pageSize) {
                pages[i] = i + 1;
                ++i;
            }
        } else {
            pages = new int[]{this.getPagen()};
        }
        int i = 1;
        while (i <= pages.length) {
            if (this.position == KGPoistionEnum.XY) {
                Rectangle rect = new Rectangle(this.x - width / 2.0f, this.y - height / 2.0f, this.x + width / 2.0f, this.y + height / 2.0f);
                this.addImage(pdfStamper, i, this.getImage(), rect);
            } else if (this.position == KGPoistionEnum.TEXT) {
                List<Rectangle> rects = hummer.getKGPdfHummerUtils().getPositionByText(i, this.text, this.onceFindReturn);
                int j = 0;
                while (j < rects.size()) {
                    Rectangle rect = new Rectangle(rects.get(j).getLeft() + rects.get(j).getWidth() / 2.0f - width / 2.0f, rects.get(j).getBottom() + rects.get(j).getHeight() / 2.0f - height / 2.0f, rects.get(j).getLeft() - rects.get(j).getWidth() / 2.0f + width / 2.0f, rects.get(j).getBottom() - rects.get(j).getHeight() / 2.0f + height / 2.0f);
                    this.addImage(pdfStamper, i, this.getImage(), rect);
                    ++j;
                }
            } else {
                throw new RuntimeException("\u4e0d\u652f\u6301\u6b64\u79cd\u5b9a\u4f4d\u65b9\u5f0f\uff01");
            }
            ++i;
        }
        pdfStamper.close();
        hummer.close();
    }

    private void addImage(PdfStamper pdfStamper, int pagen, Image image, Rectangle rect) throws DocumentException {
        PdfGState gstate = new PdfGState();
        gstate.setBlendMode(PdfGState.BM_MULTIPLY);
        PdfContentByte pdfContentByte = pdfStamper.getOverContent(pagen);
        pdfContentByte.beginMarkedContentSequence(new PdfName("KINGGRID"));
        pdfContentByte.setGState(gstate);
        image.setAbsolutePosition(rect.getLeft(), rect.getBottom());
        pdfContentByte.addImage(image);
        pdfContentByte.endMarkedContentSequence();
    }

    public PdfNumber getHashType() {
        return this.hashType;
    }

    public void setHashType(PdfNumber hashType) {
        this.hashType = hashType;
    }

    public int getSealNumb() {
        return this.sealNumb;
    }

    public void setSealNumb(int sealNumb) {
        this.sealNumb = sealNumb;
    }

    public void setSealMsg(String keySN, String unitName, String userName, String signSN, String signName) {
        this.keySN = keySN;
        this.compName = unitName;
        this.userName = userName;
        this.signSN = signSN;
        this.keyName = signName;
    }

    public void setMessageDigest(KGMessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public String getHash() {
        return this.strMd5;
    }

    public void setHash(String hash) {
        this.strMd5 = hash;
    }

    public String getProtectDoc() {
        return this.protectDoc;
    }

    public void setProtectDoc(String protectDoc) {
        this.protectDoc = protectDoc;
    }

    public String getSealMsg() {
        return this.sealMsg;
    }

    public void setSealMsg(String sealMsg) {
        this.sealMsg = sealMsg;
    }

    public int getProversion() {
        return this.proversion;
    }

    public void setProversion(int proversion) {
        this.proversion = proversion;
    }

    public void setSubVersion(int subVersion) {
        this.subVersion = subVersion;
    }

    public void setNewHash(String newHash) {
        this.newHash = newHash;
    }

    public boolean isCombine() {
        return this.isCombine;
    }

    public void setCombine(boolean isCombine) {
        this.isCombine = isCombine;
    }

    public int getQfzFirstPageNumb() {
        return this.qfzFirstPageNumb;
    }

    public String getSealData() {
        return this.sealData;
    }

    public void setSealData(String sealData) {
        this.sealData = sealData;
    }

    public static interface IBaseinfo {
        public void invoke(Map<String, String> var1, PdfStamper var2, PdfAnnotation var3, int var4, String var5);
    }
}

