/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;

public class DeleteWatermark
extends KGExecute {
    private final String DEFAULT_WATERMARKNAME = "KINGGRID";
    private String watermarkName;
    private boolean watermarknamePrefix = false;

    public boolean isWatermarknamePrefix() {
        return this.watermarknamePrefix;
    }

    public void setWatermarknamePrefix(boolean watermarknamePrefix) {
        this.watermarknamePrefix = watermarknamePrefix;
    }

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        if (this.watermarkName == null) {
            this.watermarkName = "KINGGRID";
        }
        byte[] buff = pdfReader.getPageContent(pagen);
        String contents = new String(buff, "iso8859-1");
        int index = -1;
        int end = -1;
        String wn = null;
        wn = this.isWatermarknamePrefix() ? "KIng@GRid-" + this.watermarkName : this.watermarkName;
        PdfName pdfName = new PdfName(wn);
        while ((index = contents.indexOf(String.valueOf(pdfName.toString()) + " BMC")) != -1) {
            end = contents.indexOf("EMC", index) + 4;
            this.deleteWatermarkResource(pagen, contents.substring(index, end), pdfReader);
            String bf = contents.substring(0, index);
            String af = contents.substring(end);
            contents = String.valueOf(bf) + af;
        }
        pdfReader.setPageContent(pagen, contents.getBytes("iso8859-1"));
    }

    private void deleteWatermarkResource(int pageNumber, String waterMarkContent, PdfReader pdfReader) {
        PdfDictionary pdfDictionary = pdfReader.getPageN(pageNumber);
        PdfDictionary resources = pdfDictionary.getAsDict(PdfName.RESOURCES);
        if (resources == null) {
            return;
        }
        PdfDictionary extGState = resources.getAsDict(PdfName.EXTGSTATE);
        int index = -1;
        int endIndex = -1;
        index = waterMarkContent.indexOf("BMC") + 3;
        endIndex = waterMarkContent.indexOf("gs") - 1;
        String gsName = waterMarkContent.substring(index, endIndex).trim();
        PdfName pdfGsName = new PdfName(gsName.substring(1));
        PRIndirectReference pdfGsRef = (PRIndirectReference)extGState.get(pdfGsName);
        pdfReader.removePdfObject(pdfGsRef.getNumber());
        extGState.remove(pdfGsName);
        if (waterMarkContent.indexOf("BT") == -1) {
            index = waterMarkContent.indexOf(113);
            endIndex = waterMarkContent.indexOf(81);
            String imgContent = waterMarkContent.substring(index, endIndex).trim();
            String resource = imgContent.split(" ")[8];
            PdfDictionary XObjects = resources.getAsDict(PdfName.XOBJECT);
            if (XObjects != null) {
                PdfName name = new PdfName(resource.substring(1));
                PRIndirectReference ref = (PRIndirectReference)XObjects.get(name);
                pdfReader.removePdfObject(ref.getNumber());
                XObjects.remove(name);
            }
        }
    }

    public String getWatermarkName() {
        return this.watermarkName;
    }

    public void setWatermarkName(String watermarkName) {
        this.watermarkName = watermarkName;
    }
}

