/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PRAcroForm;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGErrorException;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.crypto.engines.RC4Engine;
import org.kg.bouncycastle.crypto.params.KeyParameter;

public class DeleteSignature
extends KGExecute {
    private String keysn;
    private List<KGExecute> exes = null;
    private DelSignType delSignType = DelSignType.DELALL;
    private boolean hasParam;

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PRAcroForm acroForm = pdfReader.getAcroForm();
        if (acroForm != null) {
            block5: {
                PdfArray fields = acroForm.getAsArray(PdfName.FIELDS);
                try {
                    if (this.delSignType == DelSignType.DELLASTONE) {
                        this.delLastOne(fields, pdfReader, pdfStamper);
                        break block5;
                    }
                    if (this.delSignType == DelSignType.DELALL) {
                        this.delAll(pdfReader, pdfStamper, fields);
                        break block5;
                    }
                    throw new KGErrorException("\u4e0d\u652f\u6301\u8be5\u5220\u9664\u7c7b\u578b\uff01");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            pdfStamper.markUsed(acroForm);
            pdfStamper.markUsed(pdfReader.getCatalog());
        }
        this.exes.remove(this);
    }

    public void delAll(PdfReader pdfReader, PdfStamper pdfStamper, PdfArray fields) {
        int i = fields.size() - 1;
        while (i >= 0) {
            PdfDictionary item = fields.getAsDict(i);
            if (!PdfName.SIG.equals(item.getAsName(PdfName.FT))) {
                --i;
                continue;
            }
            fields.remove(i--);
            PdfString t = item.getAsString(PdfName.T);
            PdfDictionary page = item.getAsDict(PdfName.P);
            PdfArray annots = page.getAsArray(PdfName.ANNOTS);
            if (annots == null) {
                return;
            }
            int k = 0;
            while (k < annots.size()) {
                if (t != null) {
                    this.delAllSigWithT(pdfReader, pdfStamper, t);
                }
                ++k;
            }
        }
    }

    public void delAllSigWithT(PdfReader pdfReader, PdfStamper pdfStamper, PdfString t1) {
        int i = 1;
        while (i <= pdfReader.getNumberOfPages()) {
            PdfDictionary pageDic = pdfReader.getPageN(i);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            if (annots != null) {
                int j = 0;
                while (j < annots.size()) {
                    PdfDictionary annot = annots.getAsDict(j);
                    PdfString t2 = annot.getAsString(PdfName.T);
                    if (t2 != null && t1.toString().equals(t2.toString())) {
                        annots.remove(j--);
                        pdfStamper.markUsed(annots);
                        pdfStamper.markUsed(pageDic);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void delLastOne(PdfArray fields, PdfReader pdfReader, PdfStamper pdfStamper) throws IOException, org.dom4j.DocumentException, KGErrorException {
        if (fields == null) {
            return;
        }
        int vRefNumber = -1;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = fields.size() - 1;
        while (i >= 0) {
            PdfDictionary annot = fields.getAsDict(i);
            if (PdfName.SIG.equals(annot.getAsName(PdfName.FT))) {
                int annotRefNumber = annot.getIndRef().getNumber();
                if (vRefNumber == -1) {
                    PRStream kgpropertyStream = (PRStream)annot.getAsStream(new PdfName("KGPROPERTY"));
                    PRStream ispStream = (PRStream)annot.getAsStream(new PdfName("ISP"));
                    if (kgpropertyStream == null && ispStream == null) {
                        throw new KGErrorException("\u5220\u9664\u5931\u8d25\uff1a\u6587\u6863\u4e2d\u7684\u6700\u540e\u4e00\u4e2a\u5370\u7ae0\u4e0d\u662f\u8be5keysn\u7528\u6237\u52a0\u76d6\uff01");
                    }
                    JSONObject obj = null;
                    obj = kgpropertyStream != null ? this.parseKgProperty(kgpropertyStream) : this.parseISP(ispStream);
                    if (this.hasParam && !obj.getString("keySN").equals(this.keysn)) {
                        throw new KGErrorException("\u5220\u9664\u5931\u8d25\uff1a\u6587\u6863\u4e2d\u7684\u6700\u540e\u4e00\u4e2a\u5370\u7ae0\u4e0d\u662f\u8be5keysn\u7528\u6237\u52a0\u76d6\uff01");
                    }
                    PdfDictionary vDic = annot.getAsDict(PdfName.V);
                    vRefNumber = vDic.getIndRef().getNumber();
                    fields.remove(i);
                    map.put(annotRefNumber, -1);
                } else {
                    int _vRefNumber;
                    PdfDictionary vDic = annot.getAsDict(PdfName.V);
                    if (vDic != null && vRefNumber == (_vRefNumber = vDic.getIndRef().getNumber())) {
                        fields.remove(i);
                        map.put(annotRefNumber, -1);
                    }
                }
            }
            --i;
        }
        int k = 1;
        while (k <= pdfReader.getNumberOfPages()) {
            PdfDictionary pageDic = pdfReader.getPageN(k);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            if (annots != null) {
                boolean remove = false;
                int l = 0;
                while (l < annots.size()) {
                    PdfDictionary annot = annots.getAsDict(l);
                    int n = annot.getIndRef().getNumber();
                    if (map.get(n) != null) {
                        remove = true;
                        map.remove(n);
                        annots.remove(l--);
                    }
                    ++l;
                }
                if (remove) {
                    pdfStamper.markUsed(annots);
                    pdfStamper.markUsed(pageDic);
                }
            }
            ++k;
        }
    }

    public JSONObject parseKgProperty(PRStream kgProperty) throws IOException, org.dom4j.DocumentException {
        JSONObject sealObj = new JSONObject();
        byte[] data = PdfReader.getStreamBytes(kgProperty);
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-");
        byte[] encData = base64.decode(new String(data));
        RC4Engine rc4_engine = new RC4Engine();
        KeyParameter params_a = new KeyParameter("www.goldgrid.com".getBytes());
        rc4_engine.init(false, (CipherParameters)params_a);
        byte[] temp = new byte[encData.length];
        rc4_engine.processBytes(encData, 0, encData.length, temp, 0);
        rc4_engine.reset();
        String keypProperty = new String(temp, "UTF-8").substring(39);
        Document document = DocumentHelper.parseText((String)keypProperty);
        sealObj.put("appName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureApp").getText());
        sealObj.put("keySN", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureKeySN").getText());
        sealObj.put("userName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureUser").getText());
        sealObj.put("unitName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureUnit").getText());
        sealObj.put("signSN", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureSN").getText());
        sealObj.put("signName", (Object)document.selectSingleNode("/KGSignaturePDF/SignatureName").getText());
        sealObj.put("createTime", (Object)"");
        return sealObj;
    }

    public JSONObject parseISP(PRStream isp) throws IOException, org.dom4j.DocumentException {
        JSONObject sealObj = new JSONObject();
        byte[] data = PdfReader.getStreamBytes(isp);
        KGBase64 base64 = new KGBase64();
        String ispstr = new String(base64.decode(new String(data)), "GBK");
        String[] ispArray = ispstr.split(";");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = ispArray;
        int n = ispArray.length;
        int n2 = 0;
        while (n2 < n) {
            String kv = stringArray[n2];
            int idx = kv.indexOf(58);
            map.put(kv.substring(0, idx), kv.substring(idx + 1));
            ++n2;
        }
        sealObj.put("appName", (Object)("iWebPDF 2015+ " + (String)map.get("SignatureApp")));
        sealObj.put("keySN", map.get("SignatureKeySN"));
        sealObj.put("userName", map.get("SignatureUser"));
        sealObj.put("unitName", map.get("SignatureUnit"));
        sealObj.put("signSN", map.get("SignatureSN"));
        sealObj.put("signName", map.get("SignatureName"));
        sealObj.put("createTime", (Object)"");
        return sealObj;
    }

    @Override
    public void setKGHummderExecutes(List<KGExecute> exes) {
        this.exes = exes;
    }

    public void deleteLastOne(String keysn) {
        this.delSignType = DelSignType.DELLASTONE;
        this.keysn = keysn;
        this.hasParam = true;
    }

    public void deleteLastOne() {
        this.delSignType = DelSignType.DELLASTONE;
        this.hasParam = false;
    }

    private static enum DelSignType {
        DELALL,
        DELLASTONE;

    }
}

