/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;

public class DeleteElectronicSeal
extends KGExecute {
    private boolean deleteLastOneSeal;
    private boolean hasDeleteLast;
    private int straddleNum = -1;

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        int numb = this.getSealNum(pdfReader);
        if (this.straddleNum == -1) {
            this.straddleNum = this.getStraddleNum(pdfReader);
        }
        if (this.hasDeleteLast) {
            return;
        }
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots == null || annots.size() == 0) {
            return;
        }
        int delSealNumb = 0;
        int delStraddleNum = 0;
        int i = annots.size() - 1;
        while (i >= 0) {
            PdfDictionary annot = annots.getAsDict(i);
            if (KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE))) {
                PdfObject straddletype = this.getStraddleType(annot);
                if (!this.deleteLastOneSeal) {
                    annots.remove(i);
                    ++delSealNumb;
                    if (straddletype != null) {
                        ++delStraddleNum;
                    }
                } else {
                    int lastOneSealRefNum = this.getLastOneSealRefNum(pdfReader);
                    if (annot.getIndRef().getNumber() == lastOneSealRefNum) {
                        annots.remove(i);
                        ++delSealNumb;
                        if (straddletype != null) {
                            PdfArray childlist = annot.getAsArray(KGElectronicSealName.CHILDLIST);
                            this.deleteChildlist(pdfReader, pdfStamper, childlist);
                        }
                        this.hasDeleteLast = true;
                        break;
                    }
                }
            }
            --i;
        }
        if (delSealNumb > 0) {
            PdfDictionary root = pdfReader.getCatalog();
            if (numb >= delSealNumb) {
                numb -= delSealNumb;
            }
            root.put(KGElectronicSealName.SEALNUM, new PdfNumber(numb));
            if (this.getStraddleNum(pdfReader) != 0 && delStraddleNum > 0) {
                root.put(KGElectronicSealName.STRADDLE, new PdfNumber(this.getStraddleNum(pdfReader) - delStraddleNum));
            }
            pdfStamper.markUsed(annots);
            pdfStamper.markUsed(page);
        }
    }

    @Override
    public void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        pdfStamper.markUsed(pdfReader.getCatalog());
    }

    private PdfObject getStraddleType(PdfDictionary annot) {
        PdfObject straddleType = annot.getAsNumber(KGElectronicSealName.STRADDLETYPE);
        if (straddleType == null) {
            straddleType = annot.getAsString(KGElectronicSealName.STRADDLETYPE);
        }
        return straddleType;
    }

    private int getLastOneSealRefNum(PdfReader pdfReader) {
        int i = pdfReader.getNumberOfPages();
        while (i > 0) {
            PdfDictionary page = pdfReader.getPageN(i);
            PdfArray annots = page.getAsArray(PdfName.ANNOTS);
            if (annots != null && annots.size() != 0) {
                int j = annots.size() - 1;
                while (j >= 0) {
                    PdfDictionary annot = annots.getAsDict(j);
                    if (KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE))) {
                        int lastOneSealRefNum = -1;
                        lastOneSealRefNum = annot.getAsIndirectObject(PdfName.PARENT) == null ? annot.getIndRef().getNumber() : annot.getAsIndirectObject(PdfName.PARENT).getNumber();
                        return lastOneSealRefNum;
                    }
                    --j;
                }
            }
            --i;
        }
        return -1;
    }

    private void deleteChildlist(PdfReader pdfReader, PdfStamper pdfStamper, PdfArray childlist) {
        int i = 0;
        while (i < childlist.size()) {
            PdfIndirectReference pageRef = childlist.getAsIndirectObject(i);
            PdfIndirectReference annotRef = childlist.getAsIndirectObject(i + 1);
            PdfDictionary pageDic = (PdfDictionary)PdfReader.getPdfObject(pageRef);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            int idx = 0;
            while (idx < annots.length()) {
                PdfDictionary _annot = annots.getAsDict(idx);
                if (_annot.getIndRef().getNumber() == annotRef.getNumber()) {
                    annots.remove(idx);
                    break;
                }
                ++idx;
            }
            pdfStamper.markUsed(annots);
            pdfStamper.markUsed(pageDic);
            i += 2;
        }
    }

    public boolean isDeleteLastOneSeal() {
        return this.deleteLastOneSeal;
    }

    public void setDeleteLastOneSeal(boolean deleteLastOneSeal) {
        this.deleteLastOneSeal = deleteLastOneSeal;
    }

    private int getSealNum(PdfReader pdfReader) {
        return this.getStraddleNum(pdfReader, KGElectronicSealName.SEALNUM);
    }

    private int getStraddleNum(PdfReader pdfReader) {
        return this.getStraddleNum(pdfReader, KGElectronicSealName.STRADDLE);
    }

    private int getStraddleNum(PdfReader pdfReader, PdfName name) {
        PdfNumber pdfNumber = pdfReader.getCatalog().getAsNumber(name);
        if (pdfNumber != null) {
            return pdfNumber.intValue();
        }
        return 0;
    }
}

