/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.awt.geom.AffineTransform;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.KGitextpdf.text.pdf.parser.PdfReaderContentParser;
import com.kinggrid.img.CutImage;
import com.kinggrid.img.ImageUtils;
import com.kinggrid.img.KGTextInfo;
import com.kinggrid.kgcore.KGElectronicSeal;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.kgcore.LogEntity;
import com.kinggrid.kgcore.SaveLogListener;
import com.kinggrid.kgcore.enmu.KGQueryByEnum;
import com.kinggrid.kgcore.enmu.KGSealTypeEnum;
import com.kinggrid.kgcore.enmu.LanguageEnum;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.core.Coordinate;
import com.kinggrid.pdf.core.KGTextMarginFinder;
import com.kinggrid.pdf.enmu.KGPoistionEnum;
import com.kinggrid.pdf.enmu.KGQfzModeEnum;
import com.kinggrid.pdf.enmu.XYType;
import com.kinggrid.pdf.executes.entity.QfzSealData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public abstract class AbstractSign
extends KGExecute {
    protected KGElectronicSeal kgElectronicSeal;
    protected KGPoistionEnum position = KGPoistionEnum.RECT;
    private Rectangle rect;
    private Image image;
    private PdfName blendMode = PdfGState.BM_MULTIPLY;
    protected String text;
    private float offsetX;
    private float offsetY;
    private boolean hasFindText;
    protected boolean onceFindReturn;
    private boolean rotation;
    private int rotationAngle = 0;
    protected float x;
    protected float y;
    protected float xPercent;
    protected float yPercent;
    private XYType xyType = XYType.LOWER_LEFT;
    private List<KGTextInfo> textInfoList;
    private String batchID;
    private String SealSource;
    private int number;
    private KGQfzModeEnum qfzMode;
    private int yDistanceOrigin;
    private Map<Integer, Integer> orginalMap = null;
    private Map<Integer, Integer> rectMap = null;
    private int step = 1;
    private int startPage = 1;
    private int endPage = 0;
    private int nextPage = 1;
    private int increment = 1;
    private int startX = 0;
    private String imgFormat = "GIF";
    private int qfzWidth;
    private int qfzHeight;
    private double qfzPercent = 0.5;
    private boolean bilateralOff = false;
    private byte[] leftImgb;
    private byte[] rightImgb;
    private boolean qfzData = false;
    private Map<Integer, List<QfzSealData>> qfzSealMap;
    private List<SaveLogListener> saveLogListeners = new ArrayList<SaveLogListener>();
    private String straddleType = "1";
    private String StraddleEnd;
    protected LogEntity logEntity;

    public Rectangle getRect() {
        return this.rect;
    }

    public KGQfzModeEnum getQfzMode() {
        return this.qfzMode;
    }

    public void setQfzMode(KGQfzModeEnum qfzMode) {
        this.qfzMode = qfzMode;
    }

    public KGPoistionEnum getPosition() {
        return this.position;
    }

    public void setRect(Rectangle rect) {
        this.rect = rect;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public PdfName getBlendMode() {
        return this.blendMode;
    }

    public void setBlendMode(PdfName blendMode) {
        this.blendMode = blendMode;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public int getRotationAngle() {
        return this.rotationAngle;
    }

    public int getyDistanceOrigin() {
        return this.yDistanceOrigin;
    }

    public int getQfzHeight() {
        return this.qfzHeight;
    }

    public int getQfzWidth() {
        return this.qfzWidth;
    }

    public int getNumber() {
        return this.number;
    }

    public void setRotationAngle(int rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        if (startPage < 1) {
            throw new IllegalArgumentException("startPage \u4e0d\u80fd\u5c0f\u4e8e1.");
        }
        this.nextPage = this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public String getBatchID() {
        return this.batchID;
    }

    public void setBatchID(String batchID) {
        this.batchID = batchID;
    }

    public String getStraddleType() {
        return this.straddleType;
    }

    public void setStraddleType(String straddleType) {
        this.straddleType = straddleType;
    }

    public String getStraddleEnd() {
        return this.StraddleEnd;
    }

    public void setStraddleEnd(String straddleEnd) {
        this.StraddleEnd = straddleEnd;
    }

    public void setXY(float x, float y) {
        this.position = KGPoistionEnum.XY;
        this.x = x;
        this.y = y;
    }

    public void setXY(XYType xyType, float x, float y) {
        this.xyType = xyType;
        this.setXY(x, y);
    }

    public void setXYPercent(XYType xyType, float xPercent, float yPercent) {
        this.xyType = xyType;
        this.position = KGPoistionEnum.XYPERCENT;
        this.xPercent = xPercent;
        this.yPercent = yPercent;
    }

    public void setLeftTopPercent(XYType xyType, float leftPercent, float topPercent) {
        this.xyType = xyType;
        this.position = KGPoistionEnum.LEFTTOPPERCENT;
        this.xPercent = leftPercent;
        this.yPercent = topPercent;
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public void setText(String text, boolean onceFindReturn) {
        this.position = KGPoistionEnum.TEXT;
        this.text = text;
        this.onceFindReturn = onceFindReturn;
    }

    public void setTextOffset(float offsetX, float offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void qfz(int number, KGQfzModeEnum qfzMode, int yDistanceOrigin) throws DocumentException, IOException {
        this.position = KGPoistionEnum.QFZ;
        this.number = number;
        this.qfzMode = qfzMode;
        this.yDistanceOrigin = yDistanceOrigin;
    }

    public void qfz(int number, KGQfzModeEnum qfzMode, int yDistanceOrigin, double qfzPercent) throws DocumentException, IOException {
        this.position = KGPoistionEnum.QFZ;
        this.number = number;
        this.qfzMode = qfzMode;
        this.yDistanceOrigin = yDistanceOrigin;
        this.qfzPercent = qfzPercent;
    }

    public void qfz(Map<Integer, List<QfzSealData>> qfzSealMap) {
        this.position = KGPoistionEnum.QFZ;
        this.qfzSealMap = qfzSealMap;
    }

    public void qfzBilateralOff(int yDistanceOrigin) throws DocumentException, IOException {
        this.bilateralOff = true;
        this.qfz(-1, KGQfzModeEnum.ALLPAGE, yDistanceOrigin);
    }

    public void setImage(byte[] imgb, String imgFormat, int width, int height) throws DocumentException, IOException {
        try {
            this.image = Image.getInstance(imgb);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u5370\u7ae0\u56fe\u7247\u4fe1\u606f\u89e3\u6790\u51fa\u9519\uff0c\u539f\u56e0\uff1a\u5bf9\u63a5\u7b7e\u7ae0\u670d\u52a1\u5668\u7248\u672c\u9519\u8bef\u3010NET\u3001CA0\u3001CA2\u3001CA3\u3001GA\u3011\r\n" + e.toString());
        }
        this.image.scaleAbsolute(width, height);
        this.imgFormat = imgFormat;
        this.qfzWidth = width;
        this.qfzHeight = height;
    }

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        if (this.position == KGPoistionEnum.TEXT) {
            if (this.onceFindReturn && this.hasFindText) {
                return;
            }
            this.textSign(pdfReader, pdfStamper, pagen);
        } else if (this.position == KGPoistionEnum.QFZ) {
            this.qfzSign(pdfReader, pdfStamper, pagen);
        } else if (this.position == KGPoistionEnum.XY) {
            this.xySign(pdfReader, pdfStamper, pagen);
        } else if (this.position == KGPoistionEnum.XYPERCENT) {
            this.xySign(pdfReader, pdfStamper, pagen);
        } else if (this.position == KGPoistionEnum.LEFTTOPPERCENT) {
            this.xySign(pdfReader, pdfStamper, pagen);
        } else if (this.position == KGPoistionEnum.RECT) {
            this.sign(pdfReader, pdfStamper, pagen, this.image, this.rect);
        } else {
            throw new RuntimeException("not suport this positon: " + this.position.name());
        }
    }

    @Override
    public void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        if (this.position == KGPoistionEnum.TEXT && !this.hasFindText) {
            throw new DocumentException("Not find the text \uff1a" + this.text);
        }
        this.saveLog();
    }

    public void xySign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException {
        int rotation = pdfReader.getPageRotation(pagen);
        PdfDictionary pageNRelease = pdfReader.getPageNRelease(pagen);
        PdfArray cropbox = pageNRelease.getAsArray(PdfName.CROPBOX);
        float x = this.x;
        float y = this.y;
        Rectangle pageSizeWithRotation = pdfReader.getPageSizeWithRotation(pagen);
        if (this.position == KGPoistionEnum.XYPERCENT) {
            x = pageSizeWithRotation.getWidth() * this.xPercent;
            y = pageSizeWithRotation.getHeight() * this.yPercent;
        }
        if (this.position == KGPoistionEnum.LEFTTOPPERCENT) {
            x = pageSizeWithRotation.getWidth() * this.xPercent + this.image.getScaledWidth() / 2.0f;
            y = pageSizeWithRotation.getHeight() * this.yPercent + this.image.getScaledHeight() / 2.0f;
        }
        if (this.position == KGPoistionEnum.XY || this.position == KGPoistionEnum.XYPERCENT || this.position == KGPoistionEnum.LEFTTOPPERCENT) {
            if (this.xyType == XYType.LOWER_LEFT) {
                Rectangle pageSize = pdfReader.getPageSize(pagen);
                if (cropbox != null) {
                    Rectangle cropboxRect = new Rectangle(cropbox.getAsNumber(0).floatValue(), cropbox.getAsNumber(1).floatValue(), cropbox.getAsNumber(2).floatValue(), cropbox.getAsNumber(3).floatValue());
                    cropboxRect.normalize();
                    if (pageSize.getWidth() != cropboxRect.getWidth() || pageSize.getHeight() != cropboxRect.getHeight()) {
                        float lxDis = cropboxRect.getLeft() - pageSize.getLeft();
                        float rxDis = pageSize.getRight() - cropboxRect.getRight();
                        float byDis = cropboxRect.getBottom() - pageSize.getBottom();
                        float tyDis = pageSize.getTop() - cropboxRect.getTop();
                        if (rotation == 0) {
                            x += lxDis;
                            y += byDis;
                        } else if (rotation == 90) {
                            x += byDis;
                            y += rxDis;
                        } else if (rotation == 180) {
                            x += rxDis;
                            y += tyDis;
                        } else if (rotation == 270) {
                            x += tyDis;
                            y += lxDis;
                        }
                    }
                }
            } else if (this.xyType == XYType.LOWER_RIGHT) {
                x = pageSizeWithRotation.getWidth() - x;
            } else if (this.xyType == XYType.TOP_LEFT) {
                y = pageSizeWithRotation.getHeight() - y;
            } else if (this.xyType == XYType.UPPER_RIGHT) {
                x = pageSizeWithRotation.getWidth() - x;
                y = pageSizeWithRotation.getHeight() - y;
            }
        }
        this.rect = this.isRotation() ? (rotation == 90 || rotation == 270 ? new Rectangle(x - this.image.getScaledHeight() / 2.0f, y - this.image.getScaledWidth() / 2.0f, x + this.image.getScaledHeight() / 2.0f, y + this.image.getScaledWidth() / 2.0f, rotation) : new Rectangle(x - this.image.getScaledWidth() / 2.0f, y - this.image.getScaledHeight() / 2.0f, x + this.image.getScaledWidth() / 2.0f, y + this.image.getScaledHeight() / 2.0f, rotation)) : (this.getRotationAngle() == 90 || this.getRotationAngle() == 270 ? new Rectangle(x - this.image.getScaledHeight() / 2.0f, y - this.image.getScaledWidth() / 2.0f, x + this.image.getScaledHeight() / 2.0f, y + this.image.getScaledWidth() / 2.0f, rotation) : new Rectangle(x - this.image.getScaledWidth() / 2.0f, y - this.image.getScaledHeight() / 2.0f, x + this.image.getScaledWidth() / 2.0f, y + this.image.getScaledHeight() / 2.0f, rotation));
        this.sign(pdfReader, pdfStamper, pagen, this.image, this.rect);
    }

    private void textSign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws IOException, DocumentException {
        int rotation = pdfReader.getPageRotation(pagen);
        Rectangle pageRect = pdfReader.getPageSize(pagen);
        float width = pageRect.getWidth();
        float height = pageRect.getHeight();
        PdfReaderContentParser pdfReaderContentParser = new PdfReaderContentParser(pdfReader);
        KGTextMarginFinder textMarginFinder = new KGTextMarginFinder();
        if (this.onceFindReturn) {
            textMarginFinder.setTextsOnceFind(this.text);
        } else {
            textMarginFinder.setTexts(this.text);
        }
        pdfReaderContentParser.processContent(pagen, textMarginFinder);
        List<Coordinate> positions = textMarginFinder.getPositions();
        for (Coordinate coordinate : positions) {
            this.x = coordinate.getX();
            this.y = coordinate.getY();
            float tmp = this.x;
            if (rotation == 90) {
                this.x = this.y;
                this.y = width - tmp;
            } else if (rotation == 180) {
                this.x = width - this.x;
                this.y = height - this.y;
            } else if (rotation == 270) {
                this.x = height - this.y;
                this.y = tmp;
            }
            this.x += this.offsetX;
            this.y += this.offsetY;
            this.xySign(pdfReader, pdfStamper, pagen);
            this.hasFindText = true;
        }
    }

    public void qfzSign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws IOException, DocumentException {
        if (this.qfzSealMap != null) {
            List<QfzSealData> sealDatas = this.qfzSealMap.get(pagen);
            if (sealDatas == null || sealDatas.size() == 0) {
                return;
            }
            for (QfzSealData qfzSealData : sealDatas) {
                Rectangle oldRect = qfzSealData.getRect();
                float pagesizeTop = pdfReader.getPageSizeWithRotation(pagen).getTop();
                int pageRotation = pdfReader.getPageRotation(pagen);
                Rectangle rect = new Rectangle(oldRect.getLeft(), pagesizeTop - oldRect.getTop() - oldRect.getHeight(), oldRect.getRight(), pagesizeTop - oldRect.getTop(), pageRotation);
                this.sign(pdfReader, pdfStamper, pagen, qfzSealData.getImage(), rect);
            }
            return;
        }
        int pageNumber = 0;
        if (this.qfzPercent < 0.04 || this.qfzPercent > 0.97) {
            throw new IllegalArgumentException("\u8bf7\u8c03\u6574\u8bbe\u7f6e\u7684\u5370\u7ae0\u9996\u9875\u5360\u6bd4\u8303\u56f4\u57280.04\u52300.97\u4e4b\u95f4\uff01");
        }
        if (this.endPage > pdfReader.getNumberOfPages()) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u622a\u6b62\u9875\u8d85\u51fa\u6587\u6863\u7684\u603b\u9875\u6570\uff0c\u6587\u6863\u7684\u603b\u9875\u6570\u4e3a\uff1a" + pdfReader.getNumberOfPages());
        }
        pageNumber = this.endPage != 0 ? this.endPage - this.startPage + 1 : pdfReader.getNumberOfPages() - this.startPage + 1;
        if (pageNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u4e24\u9875\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pageNumber);
        }
        if (this.orginalMap == null && !this.bilateralOff) {
            if (this.qfzMode != KGQfzModeEnum.ALLPAGE) {
                this.step = 2;
                if (this.qfzMode == KGQfzModeEnum.ODDPAGE) {
                    int numb = pageNumber % 2;
                    pageNumber = numb == 1 ? pageNumber / 2 + 1 : pageNumber / 2;
                } else {
                    pageNumber /= 2;
                    ++this.nextPage;
                }
            }
            int originalWidth = (int)this.image.getWidth();
            if (this.qfzPercent != 0.5) {
                this.orginalMap = this.getPerPagePercentF(pageNumber, originalWidth, this.number, this.qfzPercent);
                this.rectMap = this.getPerPagePercentF(pageNumber, this.qfzWidth, this.number, this.qfzPercent);
            } else {
                this.orginalMap = this.getPerPagePercent(pageNumber, originalWidth, this.number);
                this.rectMap = this.getPerPagePercent(pageNumber, this.qfzWidth, this.number);
            }
        }
        int rotation = pdfReader.getPageRotation(pagen);
        if (pagen == this.nextPage) {
            if (this.endPage != 0 && pagen > this.endPage) {
                return;
            }
            if (!this.bilateralOff) {
                int cutImgWidth = this.orginalMap.get(this.increment);
                int rectWidth = this.rectMap.get(this.increment);
                CutImage cutImage = new CutImage(this.image.getOriginalData(), this.imgFormat);
                if ((float)(this.startX + cutImgWidth) > this.image.getWidth()) {
                    this.startX = 0;
                }
                byte[] partImageData = cutImage.cut(this.startX, 0, cutImgWidth, (int)this.image.getHeight());
                Image partImage = Image.getInstance(partImageData);
                partImage.scaleToFit(rectWidth, this.qfzHeight);
                Rectangle pageRect = pdfReader.getPageSize(pagen);
                this.rect = rotation == 90 || rotation == 270 ? new Rectangle(pageRect.getHeight() - (float)rectWidth, this.yDistanceOrigin, pageRect.getHeight(), this.yDistanceOrigin + this.qfzHeight, rotation) : new Rectangle(pageRect.getWidth() - (float)rectWidth, this.yDistanceOrigin, pageRect.getWidth(), this.yDistanceOrigin + this.qfzHeight, rotation);
                this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
                this.startX += cutImgWidth;
                ++this.increment;
            } else {
                if (this.leftImgb == null) {
                    int leftImgWidth = (int)this.image.getWidth() / 2;
                    CutImage cutImage = new CutImage(this.image.getOriginalData(), this.imgFormat);
                    this.leftImgb = cutImage.cut(0, 0, leftImgWidth, (int)this.image.getHeight());
                    this.rightImgb = cutImage.cut(leftImgWidth, 0, (int)this.image.getWidth(), (int)this.image.getHeight());
                }
                int rectLeftWidth = this.qfzWidth / 2;
                int rectRightWidth = this.qfzWidth - rectLeftWidth;
                if (pagen == 1) {
                    Image partImage = Image.getInstance(this.leftImgb);
                    partImage.scaleToFit(rectLeftWidth, this.qfzHeight);
                    Rectangle pageRect = pdfReader.getPageSize(pagen);
                    this.rect = rotation == 90 || rotation == 270 ? new Rectangle(pageRect.getHeight() - (float)rectLeftWidth, this.yDistanceOrigin, pageRect.getHeight(), this.yDistanceOrigin + this.qfzHeight, rotation) : new Rectangle(pageRect.getWidth() - (float)rectLeftWidth, this.yDistanceOrigin, pageRect.getWidth(), this.yDistanceOrigin + this.qfzHeight, rotation);
                    this.straddleType = "2";
                    this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
                } else if (this.endPage == 0 && pagen == pdfReader.getNumberOfPages() || this.endPage != 0 && pagen == this.endPage) {
                    Image partImage = Image.getInstance(this.rightImgb);
                    partImage.scaleToFit(rectRightWidth, this.qfzHeight);
                    this.rect = new Rectangle(0.0f, this.yDistanceOrigin, rectRightWidth, this.yDistanceOrigin + this.qfzHeight, rotation);
                    this.straddleType = "3";
                    this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
                } else {
                    Image partImage;
                    if (pagen != this.startPage) {
                        partImage = Image.getInstance(this.rightImgb);
                        partImage.scaleToFit(rectRightWidth, this.qfzHeight);
                        this.rect = new Rectangle(0.0f, this.yDistanceOrigin, rectRightWidth, this.yDistanceOrigin + this.qfzHeight, rotation);
                        this.straddleType = "3";
                        this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
                    }
                    partImage = Image.getInstance(this.leftImgb);
                    partImage.scaleToFit(rectLeftWidth, this.qfzHeight);
                    Rectangle pageRect = pdfReader.getPageSize(pagen);
                    this.rect = rotation == 90 || rotation == 270 ? new Rectangle(pageRect.getHeight() - (float)rectLeftWidth, this.yDistanceOrigin, pageRect.getHeight(), this.yDistanceOrigin + this.qfzHeight, rotation) : new Rectangle(pageRect.getWidth() - (float)rectLeftWidth, this.yDistanceOrigin, pageRect.getWidth(), this.yDistanceOrigin + this.qfzHeight, rotation);
                    this.straddleType = "2";
                    this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
                }
            }
            this.nextPage += this.step;
        }
    }

    protected void rotationApp(PdfTemplate app, int rotation) {
        if (rotation != 0) {
            AffineTransform transform = null;
            switch (rotation % 360) {
                case 0: {
                    break;
                }
                case 90: {
                    transform = new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
                    break;
                }
                case 180: {
                    transform = new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
                    break;
                }
                case 270: {
                    transform = new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not suport the rotation : " + rotation);
                }
            }
            if (transform != null) {
                double[] matrix = new double[6];
                transform.getMatrix(matrix);
                app.setMatrix((float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
            }
        }
    }

    protected abstract void sign(PdfReader var1, PdfStamper var2, int var3, Image var4, Rectangle var5) throws DocumentException;

    public void addImgText(KGTextInfo textInfo) {
        if (this.textInfoList == null) {
            this.textInfoList = new ArrayList<KGTextInfo>();
        }
        this.textInfoList.add(textInfo);
    }

    protected void addText2Img() throws IOException, DocumentException {
        if (this.textInfoList != null) {
            byte[] imgb = this.getImage().getOriginalData();
            ImageIcon imageIcon = new ImageIcon(imgb);
            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
            Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
            g2D.setBackground(Color.WHITE);
            g2D.fillRect(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
            g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
            g2D.dispose();
            float imgWidth = bufferedImage.getWidth();
            float imgHeight = bufferedImage.getHeight();
            BufferedImage buffImg = ImageUtils.addText(bufferedImage, this.textInfoList);
            float percentW = (float)buffImg.getWidth() / imgWidth;
            float percentH = (float)buffImg.getHeight() / imgHeight;
            float width = this.getImage().getScaledWidth() * percentW;
            float height = this.getImage().getScaledHeight() * percentH;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)buffImg, "PNG", byteArrayOutputStream);
            this.setImage(byteArrayOutputStream.toByteArray(), "PNG", (int)width, (int)height);
            this.textInfoList = null;
        }
    }

    public void setAuthOrizeCode(String authOrizeCode) {
        this.kgElectronicSeal.setAuthOrizeCode(authOrizeCode);
    }

    public void forceValidatePwd() {
        if (this.kgElectronicSeal != null) {
            this.kgElectronicSeal.forceValidatePwd();
        }
    }

    public KGQueryByEnum getQueryBy() {
        return this.kgElectronicSeal.getQueryBy();
    }

    public void setQueryBy(KGQueryByEnum queryBy) {
        this.kgElectronicSeal.setQueryBy(queryBy);
    }

    protected Map<Integer, Integer> getPerPagePercent(int pagesOfNumber, int image_width, int numb) {
        if (pagesOfNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u6709\u4e24\u4e2a\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pagesOfNumber);
        }
        if (numb < 2 || numb > 32) {
            throw new IllegalArgumentException("\u81f3\u5c112\u9875\u3001\u6700\u591a32\u9875\u5e73\u5747\u5206\u4e00\u4e2a\u7ae0.");
        }
        int cow = pagesOfNumber / numb;
        int mod = pagesOfNumber % numb;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(pagesOfNumber);
        int i = 1;
        int[] row_width = this.getRowWidth(image_width, numb);
        if (mod == 0) {
            i = 1;
            while (i <= pagesOfNumber) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
        } else if (mod == 1) {
            i = 1;
            while (i <= (cow - 1) * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, numb + 1);
            int k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        } else {
            i = 1;
            while (i <= cow * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, mod);
            int k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        }
        return map;
    }

    protected Map<Integer, Integer> getPerPagePercentF(int pagesOfNumber, int image_width, int numb, double qfzPercent) {
        int k;
        if (pagesOfNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u6709\u4e24\u4e2a\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pagesOfNumber);
        }
        if (numb < 2 || numb > 32) {
            throw new IllegalArgumentException("\u81f3\u5c112\u9875\u3001\u6700\u591a32\u9875\u5e73\u5747\u5206\u4e00\u4e2a\u7ae0.");
        }
        int first = (int)Math.round((double)image_width * qfzPercent);
        int second = image_width - first;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(pagesOfNumber -= 2);
        HashMap<Integer, Integer> newmap = new HashMap<Integer, Integer>(pagesOfNumber);
        int cow = pagesOfNumber / numb;
        int mod = pagesOfNumber % numb;
        int i = 1;
        int[] row_width = this.getRowWidth(image_width, numb);
        if (mod == 0) {
            i = 1;
            while (i <= pagesOfNumber) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
        } else if (mod == 1) {
            i = 1;
            while (i <= (cow - 1) * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, numb + 1);
            k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        } else {
            i = 1;
            while (i <= cow * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, mod);
            k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        }
        newmap.put(1, first);
        newmap.put(2, second);
        for (Map.Entry entry : map.entrySet()) {
            int key = (Integer)entry.getKey();
            int value = (Integer)entry.getValue();
            newmap.put(key + 2, value);
        }
        return newmap;
    }

    private int[] getRowWidth(int width, int rowNumber) {
        int per_page_width = width / rowNumber;
        int mod_width = width % rowNumber;
        int[] row_width = new int[rowNumber];
        Arrays.fill(row_width, per_page_width);
        if (mod_width != 0) {
            row_width[0] = row_width[0] + 1;
            int i = rowNumber - 1;
            int j = mod_width - 1;
            while (j > 0) {
                int n = i--;
                row_width[n] = row_width[n] + 1;
                --j;
            }
        }
        return row_width;
    }

    protected float cm2px() {
        return 28.346457f;
    }

    protected void saveLog() {
        if (this.saveLogListeners.size() > 0 && this.logEntity != null) {
            for (SaveLogListener listener : this.saveLogListeners) {
                listener.saveLog(this.logEntity);
            }
            this.logEntity = null;
        } else if (this.kgElectronicSeal != null && this.kgElectronicSeal.isSealFromServer() && this.logEntity != null) {
            KGHttpUtils http = new KGHttpUtils();
            http.setLanguage(this.getLanguage());
            http.saveLog(this.kgElectronicSeal.getUrl(), this.logEntity);
            if (this.position == KGPoistionEnum.QFZ) {
                this.logEntity = null;
            }
        }
    }

    public void saveLog(String documentID, String documentName, String logMemo, String extparam1, String extparam2) {
        this.logEntity = new LogEntity();
        this.logEntity.setDocumentID(documentID);
        this.logEntity.setDocumentName(documentName);
        this.logEntity.setLogMemo(logMemo);
        this.logEntity.setExtparam1(extparam1);
        this.logEntity.setExtparam2(extparam2);
    }

    public void addSaveLogListener(SaveLogListener listener) {
        this.saveLogListeners.add(listener);
    }

    public void removeSaveLogListener(SaveLogListener listener) {
        this.saveLogListeners.remove(listener);
    }

    public boolean isQfzData() {
        return this.qfzData;
    }

    public void setQfzData(boolean qfzData) {
        this.qfzData = qfzData;
    }

    public LanguageEnum getLanguage() {
        return this.kgElectronicSeal.getLanguage();
    }

    public void setLanguage(LanguageEnum language) {
        this.kgElectronicSeal.setLanguage(language);
    }

    public String getSealSource() {
        return this.SealSource;
    }

    public void setSealSource(String sealSource) {
        this.SealSource = sealSource;
    }

    public KGSealTypeEnum getSealType() {
        return this.kgElectronicSeal.getSealType();
    }

    public void setSealType(KGSealTypeEnum sealType) {
        this.kgElectronicSeal.setSealType(sealType);
    }

    public Map<Integer, List<QfzSealData>> getQfzSealMap() {
        return this.qfzSealMap;
    }

    public void setQfzSealMap(Map<Integer, List<QfzSealData>> qfzSealMap) {
        this.qfzSealMap = qfzSealMap;
    }
}

