/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.core;

import com.KGitextpdf.awt.geom.Rectangle2D;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.CMapAwareDocumentFont;
import com.KGitextpdf.text.pdf.parser.ImageRenderInfo;
import com.KGitextpdf.text.pdf.parser.Matrix;
import com.KGitextpdf.text.pdf.parser.RenderListener;
import com.KGitextpdf.text.pdf.parser.TextRenderInfo;
import com.kinggrid.pdf.core.Coordinate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KGTextMarginFinder
implements RenderListener {
    private Rectangle2D.Float textRectangle = null;
    private List<TextRenderInfo> renderInfos = new ArrayList<TextRenderInfo>();
    private float lx = -1.0f;
    private float ly = -1.0f;
    private StringBuilder text = new StringBuilder();
    private String ptext;
    private List<String> texts = null;
    private int[] indexOfTexts = null;
    private boolean onceFindReturn = false;
    private boolean onceFined = false;
    private boolean landscape;
    private List<Coordinate> positions = null;
    private List<Rectangle> rectangles = null;
    private List<Matrix> matrixs = null;
    private List<Matrix> dblIocnMatrixs = null;
    private boolean findByImageN = false;
    private boolean autoDate = false;

    public void setTexts(String text) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(text);
        this.setTexts(list);
    }

    public void setTextsOnceFind(String text) {
        this.texts = new ArrayList<String>();
        this.texts.add(text);
        this.onceFindReturn = true;
        this.onceFined = false;
        this.indexOfTexts = new int[this.texts.size()];
        Arrays.fill(this.indexOfTexts, 0);
        this.positions = new ArrayList<Coordinate>();
        this.rectangles = new ArrayList<Rectangle>();
    }

    public void setTexts(List<String> texts) {
        this.onceFindReturn = false;
        this.onceFined = false;
        this.texts = texts;
        this.indexOfTexts = new int[texts.size()];
        Arrays.fill(this.indexOfTexts, 0);
        this.positions = new ArrayList<Coordinate>();
        this.rectangles = new ArrayList<Rectangle>();
    }

    public void setAutoDate() {
        this.onceFined = false;
        this.autoDate = true;
        this.positions = new ArrayList<Coordinate>();
        this.rectangles = new ArrayList<Rectangle>();
    }

    public List<Coordinate> getPositions() {
        this.finallyLineFindText();
        return this.positions;
    }

    public List<Rectangle> getRectangles() {
        this.finallyLineFindText();
        return this.rectangles;
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        if (this.onceFined) {
            return;
        }
        if (!(this.texts != null && this.texts.size() != 0 || this.autoDate)) {
            return;
        }
        this.textRectangle = renderInfo.getDescentLine().getBoundingRectange();
        if (Float.isNaN(this.textRectangle.x) && Float.isNaN(this.textRectangle.y) && Float.isNaN(this.textRectangle.width) && Float.isNaN(this.textRectangle.height)) {
            return;
        }
        String currentText = renderInfo.getText().trim();
        if (currentText.length() == 0) {
            return;
        }
        boolean isNewLine = false;
        float number = 3.0f;
        number = this.checkChinafont(renderInfo.getText());
        boolean bl = this.landscape = this.textRectangle.getHeight() == 0.0;
        if (this.landscape) {
            if (Math.abs(this.getLly() - this.ly) > number && this.renderInfos.size() > 0) {
                isNewLine = true;
            }
            this.lx = -1.0f;
            this.ly = this.getLly();
        } else {
            if (Math.abs(this.getLlx() - this.lx) > number && this.renderInfos.size() > 0) {
                isNewLine = true;
            }
            this.lx = this.getLlx();
            this.ly = -1.0f;
        }
        renderInfo.setText(this.dealBlank(renderInfo.getText()));
        if (!isNewLine) {
            this.renderInfos.add(renderInfo);
            return;
        }
        this.findText();
        this.text = new StringBuilder();
        if (this.indexOfTexts != null) {
            Arrays.fill(this.indexOfTexts, 0);
        }
        this.renderInfos.clear();
        this.renderInfos.add(renderInfo);
    }

    private float checkChinafont(String text) {
        float number = 3.0f;
        float standardmin = 3.0f;
        float standardmax = 6.0f;
        if (this.ptext != null) {
            Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
            Matcher fm = p.matcher(String.valueOf(text));
            Matcher pfm = p.matcher(this.ptext);
            p = Pattern.compile("[\uff01]|[\uff0c-\uff0e]|[\uff1a-\uff1b]|[\uff1f]|[\uff08-\uff09]|[\u3001-\u3002]|[\u3010-\u3011]|[\u201c-\u201d]|[\u2013-\u2014]|[\u2018-\u2019]|[\u2026]|[\u3008-\u300f]|[\u3014-\u3015]");
            Matcher pbm = p.matcher(this.ptext);
            if (fm.find()) {
                if (pfm.find()) {
                    number = standardmin;
                } else if (!pfm.find()) {
                    number = pbm.find() ? standardmin : standardmax;
                }
            } else if (!fm.find()) {
                if (pbm.find()) {
                    number = pfm.find() ? standardmin : (pbm.find() ? standardmin : standardmax);
                } else if (!pbm.find()) {
                    number = pfm.find() ? standardmax : (pbm.find() ? standardmax : standardmin);
                }
            }
        }
        this.ptext = text;
        return number;
    }

    private String dealBlank(String text) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < text.length()) {
            String firstText = text.substring(i, i + 1);
            if (!firstText.equals(" ")) {
                list.add(i);
            }
            ++i;
        }
        if (list.size() > 1) {
            String newtext = text.substring((Integer)list.get(0), (Integer)list.get(list.size() - 1) + 1);
            text = text.replace(newtext, newtext.replace(" ", ""));
        }
        return text;
    }

    private void findText() {
        if (this.onceFindReturn && this.onceFined) {
            return;
        }
        if (this.landscape) {
            Collections.sort(this.renderInfos, new Comparator<TextRenderInfo>(){

                @Override
                public int compare(TextRenderInfo o1, TextRenderInfo o2) {
                    float f1 = o1.getDescentLine().getBoundingRectange().x;
                    float f2 = o2.getDescentLine().getBoundingRectange().x;
                    return Float.compare(f1, f2);
                }
            });
        } else {
            Collections.sort(this.renderInfos, new Comparator<TextRenderInfo>(){

                @Override
                public int compare(TextRenderInfo o1, TextRenderInfo o2) {
                    float f1 = o1.getDescentLine().getBoundingRectange().y;
                    float f2 = o2.getDescentLine().getBoundingRectange().y;
                    return Float.compare(f1, f2);
                }
            });
        }
        int i = 0;
        while (i < this.renderInfos.size()) {
            TextRenderInfo bTextRenderInfo;
            TextRenderInfo textRenderInfo = this.renderInfos.get(i);
            if (i < 1 || !(bTextRenderInfo = this.renderInfos.get(i - 1)).getText().trim().equals(textRenderInfo.getText().trim()) || !(textRenderInfo.getDescentLine().getBoundingRectange().x - bTextRenderInfo.getDescentLine().getBoundingRectange().x < 2.0f)) {
                this.text.append(textRenderInfo.getText().trim());
            }
            ++i;
        }
        String lineText = this.text.toString();
        if (this.autoDate) {
            if (lineText.indexOf("\u4e8c") == 0 && lineText.indexOf("\u65e5") == lineText.length() - 1 && lineText.indexOf("\u5e74") != -1 && lineText.indexOf("\u6708") != -1) {
                Rectangle2D.Float startRectangle = this.renderInfos.get(0).getDescentLine().getBoundingRectange();
                Rectangle2D.Float endRectangle = this.renderInfos.get(this.renderInfos.size() - 1).getAscentLine().getBoundingRectange();
                Coordinate coordinate = new Coordinate();
                coordinate.setX((float)(endRectangle.getX() + startRectangle.getX() + (double)endRectangle.width) / 2.0f);
                coordinate.setY((float)(endRectangle.getY() + startRectangle.getY()) / 2.0f);
                coordinate.setText(lineText);
                this.positions.add(coordinate);
                Rectangle rect = new Rectangle((float)startRectangle.getX(), (float)startRectangle.getY(), (float)endRectangle.getX() + endRectangle.width, (float)endRectangle.getY());
                this.rectangles.add(rect);
                if (this.onceFindReturn) {
                    this.onceFined = true;
                    return;
                }
            }
        } else {
            int k = 0;
            while (k < this.texts.size()) {
                String text_position = this.texts.get(k);
                int len = text_position.length();
                int i2 = this.indexOfTexts[k];
                while ((i2 = lineText.indexOf(text_position, i2)) != -1) {
                    int length = 0;
                    boolean hasStart = false;
                    float startX = 0.0f;
                    float startY = 0.0f;
                    float endX = 0.0f;
                    float endY = 0.0f;
                    int j = 0;
                    while (j < this.renderInfos.size()) {
                        TextRenderInfo bTextRenderInfo;
                        TextRenderInfo textRenderInfo = this.renderInfos.get(j);
                        boolean flag = this.dealSpace(textRenderInfo.getText());
                        String ltext = textRenderInfo.getText().trim();
                        if (j < 1 || !(bTextRenderInfo = this.renderInfos.get(j - 1)).getText().trim().equals(ltext) || !(textRenderInfo.getDescentLine().getBoundingRectange().x - bTextRenderInfo.getDescentLine().getBoundingRectange().x < 2.0f)) {
                            float fontsize;
                            float textRenderInfoWidth;
                            float width;
                            float textWidth;
                            CMapAwareDocumentFont font;
                            Rectangle2D.Float rectangle;
                            int ltext_length = ltext.length();
                            if (!hasStart && length + ltext_length >= i2 + 1) {
                                hasStart = true;
                                int start = i2 - length;
                                rectangle = textRenderInfo.getDescentLine().getBoundingRectange();
                                font = (CMapAwareDocumentFont)textRenderInfo.getFont();
                                textWidth = font.getWidth(ltext);
                                width = 0.0f;
                                textRenderInfoWidth = 0.0f;
                                textRenderInfoWidth = rectangle.getHeight() == 0.0 ? (float)rectangle.getWidth() : (float)rectangle.getHeight();
                                if (flag) {
                                    fontsize = textRenderInfo.getFontSize();
                                    startX = rectangle.x + rectangle.width - fontsize * (float)len;
                                    startY = rectangle.y - fontsize;
                                    endX = rectangle.x + rectangle.width;
                                    endY = rectangle.y;
                                } else {
                                    width = textWidth != 0.0f ? (float)font.getWidth(ltext.substring(0, start)) / textWidth * textRenderInfoWidth : textRenderInfoWidth / (float)ltext_length * (float)start;
                                    if (rectangle.getHeight() == 0.0) {
                                        startX = rectangle.x + width;
                                        startY = rectangle.y;
                                    } else {
                                        startX = rectangle.x;
                                        startY = rectangle.y + width;
                                    }
                                }
                            }
                            if (hasStart && length + ltext_length >= i2 + len) {
                                int end = i2 + len - length;
                                rectangle = textRenderInfo.getAscentLine().getBoundingRectange();
                                font = (CMapAwareDocumentFont)textRenderInfo.getFont();
                                textWidth = font.getWidth(ltext);
                                width = 0.0f;
                                textRenderInfoWidth = 0.0f;
                                textRenderInfoWidth = rectangle.getHeight() == 0.0 ? (float)rectangle.getWidth() : (float)rectangle.getHeight();
                                width = textWidth != 0.0f ? (float)font.getWidth(ltext.substring(0, end)) / textWidth * textRenderInfoWidth : (textRenderInfoWidth != 0.0f ? textRenderInfoWidth / (float)ltext_length * (float)end : textRenderInfo.getFontSize() * (float)end);
                                if (flag) {
                                    fontsize = textRenderInfo.getFontSize();
                                    startX = rectangle.x + rectangle.width - fontsize * (float)len;
                                    startY = rectangle.y - fontsize;
                                    endX = rectangle.x + rectangle.width;
                                    endY = rectangle.y;
                                } else if (rectangle.getHeight() == 0.0) {
                                    endX = rectangle.x + width;
                                    endY = rectangle.y;
                                } else {
                                    endX = rectangle.x;
                                    endY = rectangle.y + width;
                                }
                                Coordinate coordinate = new Coordinate();
                                coordinate.setX((endX + startX) / 2.0f);
                                coordinate.setY((endY + startY) / 2.0f);
                                coordinate.setText(text_position);
                                this.positions.add(coordinate);
                                Rectangle rect = new Rectangle(startX, startY, endX, endY);
                                this.rectangles.add(rect);
                                hasStart = false;
                                if (!this.onceFindReturn) break;
                                this.onceFined = true;
                                return;
                            }
                            length += ltext_length;
                        }
                        ++j;
                    }
                    this.indexOfTexts[k] = i2 += len;
                }
                ++k;
            }
        }
    }

    private void finallyLineFindText() {
        this.findText();
    }

    public float getLlx() {
        return this.textRectangle.x;
    }

    public float getLly() {
        return this.textRectangle.y;
    }

    public float getUrx() {
        return this.textRectangle.x + this.textRectangle.width;
    }

    public float getUry() {
        return this.textRectangle.y + this.textRectangle.height;
    }

    public float getWidth() {
        return this.textRectangle.width;
    }

    public float getHeight() {
        return this.textRectangle.height;
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        if (this.findByImageN) {
            if (this.matrixs == null) {
                this.matrixs = new ArrayList<Matrix>();
            }
            this.matrixs.add(renderInfo.getImageCTM());
        }
    }

    public void setFindByImageN(boolean findByImageN) {
        this.findByImageN = findByImageN;
    }

    public boolean getFindByImageN() {
        return this.findByImageN;
    }

    public List<Matrix> getDblMarixIndex() {
        if (this.dblIocnMatrixs == null && this.matrixs != null) {
            this.dblIocnMatrixs = new ArrayList<Matrix>();
            HashMap<String, Matrix> maps = new HashMap<String, Matrix>();
            int i = 0;
            while (i < this.matrixs.size()) {
                Matrix matrix = this.matrixs.get(i);
                if (matrix != null) {
                    String key = String.valueOf(matrix.get(0)) + " " + matrix.get(4) + " " + matrix.get(6) + " " + matrix.get(7);
                    if (!maps.containsKey(key)) {
                        maps.put(key, matrix);
                    } else {
                        this.dblIocnMatrixs.add(matrix);
                    }
                }
                ++i;
            }
        }
        return this.dblIocnMatrixs;
    }

    public boolean dealSpace(String text) {
        boolean flag = true;
        int i = 0;
        while (i < text.length()) {
            String firstText = text.substring(i, i + 1);
            if (!firstText.equals(" ")) {
                flag = false;
                break;
            }
            ++i;
        }
        return flag;
    }
}

